/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.jdk.Target_java_lang_Package;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

@TargetClass(className="jdk.internal.loader.BootLoader", onlyWith={JDK11OrLater.class})
final class Target_jdk_internal_loader_BootLoader {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ConcurrentHashMap.class)
    static ConcurrentHashMap<?, ?> CLASS_LOADER_VALUE_MAP;

    Target_jdk_internal_loader_BootLoader() {
    }

    @Substitute
    static Package getDefinedPackage(String name) {
        if (name != null) {
            Target_java_lang_Package pkg = new Target_java_lang_Package(name, null, null, null, null, null, null, null, null);
            return SubstrateUtil.cast(pkg, Package.class);
        }
        return null;
    }

    @Substitute
    private static Class<?> loadClassOrNull(String name) {
        return ClassForNameSupport.forNameOrNull(name, false);
    }

    @Substitute
    private static Class<?> loadClass(Target_java_lang_Module module, String name) {
        return ClassForNameSupport.forNameOrNull(name, false);
    }

    @Substitute
    private static boolean hasClassPath() {
        return true;
    }

    @Substitute
    private static URL findResource(String mn, String name) {
        return ClassLoader.getSystemClassLoader().getResource(name);
    }

    @Substitute
    private static InputStream findResourceAsStream(String mn, String name) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(name);
    }

    @Substitute
    private static URL findResource(String name) {
        return ClassLoader.getSystemClassLoader().getResource(name);
    }

    @Substitute
    private static Enumeration<URL> findResources(String name) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(name);
    }
}

