/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public class CompareAndSetVMThreadLocalNode
extends AbstractStateSplit
implements Lowerable {
    public static final NodeClass<CompareAndSetVMThreadLocalNode> TYPE = NodeClass.create(CompareAndSetVMThreadLocalNode.class);
    private final VMThreadLocalInfo threadLocalInfo;
    @Node.Input
    protected ValueNode holder;
    @Node.Input
    protected ValueNode expect;
    @Node.Input
    protected ValueNode update;

    public CompareAndSetVMThreadLocalNode(VMThreadLocalInfo threadLocalInfo, ValueNode holder, ValueNode expect, ValueNode update) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Boolean.getStackKind()));
        this.threadLocalInfo = threadLocalInfo;
        this.holder = holder;
        this.expect = expect;
        this.update = update;
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0);
        ConstantNode offset = ConstantNode.forLong((long)this.threadLocalInfo.offset, (StructuredGraph)this.holder.graph());
        UnsafeCompareAndSwapNode atomic = (UnsafeCompareAndSwapNode)this.graph().add((Node)new UnsafeCompareAndSwapNode(this.holder, (ValueNode)offset, this.expect, this.update, this.threadLocalInfo.storageKind, this.threadLocalInfo.locationIdentity, MemoryOrderMode.VOLATILE));
        atomic.setStateAfter(this.stateAfter());
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)atomic);
        tool.getLowerer().lower((Node)atomic, tool);
    }
}

