/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.nativeimage.ImageSingletons;

public class TypeCheckBuilder {
    private static final int SLOT_CAPACITY = 65536;
    private final HostedType objectType;
    private final HostedType cloneableType;
    private final HostedType serializableType;
    private final Collection<HostedType> allTypes;
    private final Set<HostedType> allIncludedTypes;
    private final List<HostedType> allIncludedRoots;
    private final List<HostedType> heightOrderedTypes;
    private int numTypeCheckSlots = -1;
    private final Map<HostedType, List<HostedType>> subtypeMap;

    public TypeCheckBuilder(Collection<HostedType> types, HostedType objectType, HostedType cloneableType, HostedType serializableType) {
        this.allTypes = types;
        this.objectType = objectType;
        this.cloneableType = cloneableType;
        this.serializableType = serializableType;
        this.allIncludedTypes = this.allTypes.stream().filter(TypeCheckBuilder::shouldIncludeType).collect(Collectors.toSet());
        this.subtypeMap = this.computeSubtypeInformation();
        HashSet hasParent = new HashSet();
        this.subtypeMap.forEach((type, subtypes) -> hasParent.addAll(subtypes));
        this.allIncludedRoots = this.allIncludedTypes.stream().filter(t -> !hasParent.contains(t)).collect(Collectors.toList());
        this.heightOrderedTypes = TypeCheckBuilder.generateHeightOrder(this.allIncludedRoots, this.subtypeMap);
    }

    public int getNumTypeCheckSlots() {
        assert (this.numTypeCheckSlots != -1);
        return this.numTypeCheckSlots;
    }

    private static boolean shouldIncludeType(HostedType type) {
        assert (type != null);
        return true;
    }

    private boolean isTypePresent(HostedType type) {
        return type != null && this.allIncludedTypes.contains(type);
    }

    private static boolean isInterface(HostedType type) {
        return type.isInterface() || type.isArray() && type.getBaseType().isInterface();
    }

    private static short getShortValue(int intValue) {
        assert (intValue < 65536);
        return (short)intValue;
    }

    private static List<HostedType> generateHeightOrder(List<HostedType> roots, Map<HostedType, List<HostedType>> subtypeMap) {
        Set<HostedType> allTypes = subtypeMap.keySet();
        HashMap<HostedType, Integer> heightMap = new HashMap<HostedType, Integer>();
        allTypes.forEach(t -> heightMap.put((HostedType)t, Integer.MIN_VALUE));
        for (HostedType root : roots) {
            TypeCheckBuilder.generateHeightOrderHelper(0, root, subtypeMap, heightMap, allTypes);
        }
        return allTypes.stream().sorted(Comparator.comparingInt(heightMap::get)).collect(Collectors.toList());
    }

    private static void generateHeightOrderHelper(int depth, HostedType type, Map<HostedType, List<HostedType>> subtypeMap, Map<HostedType, Integer> heightMap, Set<HostedType> allTypes) {
        assert (allTypes.contains(type));
        heightMap.compute(type, (k, currentHeight) -> Integer.max(depth, currentHeight));
        for (HostedType subtype : subtypeMap.get(type)) {
            TypeCheckBuilder.generateHeightOrderHelper(depth + 1, subtype, subtypeMap, heightMap, allTypes);
        }
    }

    private Map<HostedType, List<HostedType>> computeSubtypeInformation() {
        boolean typePresent;
        HashMap<HostedType, Set<HostedType>> subtypes = new HashMap<HostedType, Set<HostedType>>();
        List<HostedType> allElementTypes = this.allTypes.stream().filter(t -> !t.isArray()).collect(Collectors.toList());
        Map<HostedType, List<HostedType>> elementParentMap = this.computeElementParentMap(allElementTypes);
        HashSet hasSubtype = new HashSet();
        elementParentMap.forEach((child, parents) -> hasSubtype.addAll(parents));
        List<HostedType> elementParentMapRoots = allElementTypes.stream().filter(t -> !hasSubtype.contains(t)).collect(Collectors.toList());
        List<HostedType> heightOrderedElements = TypeCheckBuilder.generateHeightOrder(elementParentMapRoots, elementParentMap);
        int dimension = 0;
        do {
            typePresent = this.addDimensionSubtypeEntries(dimension, subtypes, elementParentMap, heightOrderedElements);
            ++dimension;
        } while (typePresent);
        HashMap<HostedType, List<HostedType>> result = new HashMap<HostedType, List<HostedType>>();
        subtypes.forEach((k, v) -> result.put((HostedType)k, v.stream().sorted().collect(Collectors.toList())));
        return result;
    }

    private Map<HostedType, List<HostedType>> computeElementParentMap(List<HostedType> allElementTypes) {
        HashMap<HostedType, List<HostedType>> result = new HashMap<HostedType, List<HostedType>>();
        for (HostedType type : allElementTypes) {
            ArrayList<HostedType> parents = new ArrayList<HostedType>();
            if (type.getSuperclass() != null) {
                parents.add(type.getSuperclass());
            }
            if (type.isInterface() && type.getInterfaces().length == 0) {
                parents.add(this.objectType);
            }
            for (HostedInterface interf : type.getInterfaces()) {
                parents.add(interf);
            }
            result.put(type, parents);
        }
        return result;
    }

    private boolean addDimensionSubtypeEntries(int dimension, Map<HostedType, Set<HostedType>> subtypes, Map<HostedType, List<HostedType>> elementParentMap, List<HostedType> heightOrderedElements) {
        boolean typePresent = false;
        HashMap<HostedType, Set> includedArraySubtypesMap = new HashMap<HostedType, Set>();
        heightOrderedElements.forEach(t -> {
            Set cfr_ignored_0 = includedArraySubtypesMap.put((HostedType)t, new HashSet());
        });
        for (HostedType type : heightOrderedElements) {
            Set<HostedType> includedArraySubtypes;
            HostedType arrayType = type.getArrayClass(dimension);
            if (this.isTypePresent(arrayType)) {
                includedArraySubtypes = new HashSet<HostedType>();
                includedArraySubtypes.add(arrayType);
                typePresent = true;
            } else {
                includedArraySubtypes = (Set)includedArraySubtypesMap.get(type);
            }
            for (HostedType parent : elementParentMap.get(type)) {
                ((Set)includedArraySubtypesMap.get(parent)).addAll(includedArraySubtypes);
            }
        }
        if (typePresent) {
            HashMap<HostedType, Set> filteredArraySubtypesMap = new HashMap<HostedType, Set>();
            includedArraySubtypesMap.forEach((k, v) -> {
                HostedType arrayType = k.getArrayClass(dimension);
                if (this.isTypePresent(arrayType)) {
                    filteredArraySubtypesMap.put(arrayType, (Set)v);
                }
            });
            if (dimension > 0) {
                HashSet typesWithSubtypes = new HashSet();
                filteredArraySubtypesMap.forEach((k, v) -> typesWithSubtypes.addAll(v));
                List roots = filteredArraySubtypesMap.keySet().stream().filter(t -> !typesWithSubtypes.contains(t)).collect(Collectors.toList());
                HostedType parentObjectType = this.getHighestDimArrayType(this.objectType, dimension - 1);
                HostedType parentCloneableType = this.getHighestDimArrayType(this.cloneableType, dimension - 1);
                HostedType parentSerializableType = this.getHighestDimArrayType(this.serializableType, dimension - 1);
                subtypes.get(parentObjectType).addAll(roots);
                subtypes.get(parentCloneableType).addAll(roots);
                subtypes.get(parentSerializableType).addAll(roots);
            }
            filteredArraySubtypesMap.forEach((k, v) -> {
                assert (this.isTypePresent((HostedType)k));
                subtypes.put((HostedType)k, (Set<HostedType>)v);
            });
        }
        return typePresent;
    }

    private HostedType getHighestDimArrayType(HostedType type, int dimMax) {
        HostedType result;
        assert (type != null);
        int dim = dimMax;
        do {
            result = type.getArrayClass(dim);
            --dim;
        } while (!this.isTypePresent(result));
        return result;
    }

    public void buildTypeInformation(HostedUniverse hUniverse) {
        HostedType type;
        int i;
        hUniverse.orderedTypes = this.heightOrderedTypes;
        ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).setMaxTypeId(this.heightOrderedTypes.size());
        for (i = 0; i < this.heightOrderedTypes.size(); ++i) {
            type = this.heightOrderedTypes.get(i);
            type.typeID = i;
            assert (this.subtypeMap.containsKey(type));
            type.subTypes = this.subtypeMap.get(type).toArray(new HostedType[0]);
        }
        for (i = this.heightOrderedTypes.size() - 1; i >= 0; --i) {
            type = this.heightOrderedTypes.get(i);
            Object subtypeStampType = null;
            for (HostedType child : this.subtypeMap.get(type)) {
                if (child.strengthenStampType == null) continue;
                if (subtypeStampType != null && !subtypeStampType.equals(child.strengthenStampType)) {
                    subtypeStampType = type;
                    break;
                }
                subtypeStampType = child.strengthenStampType;
            }
            boolean isInstantiated = type.getWrapped().isInstantiated();
            assert (!isInstantiated || type.isInstanceClass() && !Modifier.isAbstract(type.getModifiers()) || type.isArray());
            if (subtypeStampType == null) {
                if (isInstantiated) {
                    type.strengthenStampType = type;
                    type.uniqueConcreteImplementation = type.isWordType() ? null : type;
                    continue;
                }
                type.strengthenStampType = null;
                type.uniqueConcreteImplementation = null;
                continue;
            }
            if (subtypeStampType.equals(type)) {
                type.strengthenStampType = type;
                type.uniqueConcreteImplementation = null;
                continue;
            }
            if (isInstantiated) {
                type.strengthenStampType = type;
                type.uniqueConcreteImplementation = null;
                continue;
            }
            type.strengthenStampType = subtypeStampType;
            type.uniqueConcreteImplementation = ((HostedType)subtypeStampType).uniqueConcreteImplementation;
        }
    }

    public boolean calculateIDs() {
        ClassIDBuilder classBuilder = new ClassIDBuilder(this.objectType, this.allIncludedRoots, this.heightOrderedTypes, this.subtypeMap);
        classBuilder.computeSlots();
        InterfaceIDBuilder interfaceBuilder = new InterfaceIDBuilder(classBuilder.numClassSlots, this.heightOrderedTypes, this.subtypeMap);
        interfaceBuilder.computeSlots();
        this.generateTypeCheckSlots(classBuilder, interfaceBuilder);
        assert (TypeCheckValidator.compareTypeIDResults(this.heightOrderedTypes));
        return true;
    }

    private void generateTypeCheckSlots(ClassIDBuilder classBuilder, InterfaceIDBuilder interfaceBuilder) {
        int numClassSlots = classBuilder.numClassSlots;
        this.numTypeCheckSlots = numClassSlots + interfaceBuilder.numInterfaceSlots;
        int numSlots = this.getNumTypeCheckSlots();
        for (HostedType type : this.allIncludedTypes) {
            int i;
            short[] typeCheckSlots = new short[numSlots];
            int[] slots = classBuilder.classSlotIDMap.get(type);
            for (i = 0; i < slots.length; ++i) {
                typeCheckSlots[i] = TypeCheckBuilder.getShortValue(slots[i]);
                assert (typeCheckSlots[i] < 65536);
            }
            slots = interfaceBuilder.interfaceSlotIDMap.get(type);
            if (slots != null) {
                for (i = 0; i < slots.length; ++i) {
                    typeCheckSlots[numClassSlots + i] = TypeCheckBuilder.getShortValue(slots[i]);
                    assert (typeCheckSlots[numClassSlots + i] < 65536);
                }
            }
            type.setTypeCheckSlots(typeCheckSlots);
        }
    }

    private static final class TypeCheckValidator {
        private TypeCheckValidator() {
        }

        static boolean compareTypeIDResults(List<HostedType> types) {
            int numTypes = types.size();
            for (int i = 0; i < numTypes; ++i) {
                HostedType superType = types.get(i);
                for (int j = 0; j < numTypes; ++j) {
                    boolean runtimeCheck;
                    boolean checksMatch;
                    HostedType checkedType = types.get(j);
                    boolean hostedCheck = superType.isAssignableFrom(checkedType);
                    boolean bl = checksMatch = hostedCheck == (runtimeCheck = TypeCheckValidator.runtimeIsAssignableFrom(superType, checkedType));
                    if (checksMatch) continue;
                    StringBuilder message = new StringBuilder();
                    message.append("\n********Type checks do not match:********\n");
                    message.append(String.format("super type: %s\n", superType.toString()));
                    message.append(String.format("checked type: %s\n", checkedType.toString()));
                    message.append(String.format("hosted check: %b\n", hostedCheck));
                    message.append(String.format("runtime check: %b\n", runtimeCheck));
                    VMError.shouldNotReachHere(message.toString());
                }
            }
            return true;
        }

        static boolean runtimeIsAssignableFrom(HostedType superType, HostedType checkedType) {
            int typeCheckStart = Short.toUnsignedInt(superType.getTypeCheckStart());
            int typeCheckRange = Short.toUnsignedInt(superType.getTypeCheckRange());
            int typeCheckSlot = Short.toUnsignedInt(superType.getTypeCheckSlot());
            int checkedTypeID = Short.toUnsignedInt(checkedType.getTypeCheckSlots()[typeCheckSlot]);
            return UnsignedMath.belowThan((int)(checkedTypeID - typeCheckStart), (int)typeCheckRange);
        }
    }

    private static final class InterfaceIDBuilder {
        final List<HostedType> heightOrderedTypes;
        final Map<HostedType, List<HostedType>> subtypeMap;
        final int startingSlotNum;
        final Map<HostedType, int[]> interfaceSlotIDMap = new HashMap<HostedType, int[]>();
        int numInterfaceSlots = -1;

        InterfaceIDBuilder(int startingSlotNum, List<HostedType> heightOrderedTypes, Map<HostedType, List<HostedType>> subtypeMap) {
            this.startingSlotNum = startingSlotNum;
            this.heightOrderedTypes = heightOrderedTypes;
            this.subtypeMap = subtypeMap;
        }

        void computeSlots() {
            Graph interfaceGraph = Graph.buildInterfaceGraph(this.heightOrderedTypes, this.subtypeMap);
            interfaceGraph.mergeDuplicates();
            interfaceGraph.generateDescendantIndex();
            this.calculateInterfaceIDs(interfaceGraph);
        }

        void calculateInterfaceIDs(Graph graph) {
            assert (graph.interfaceNodes != null);
            ArrayList<InterfaceSlot> slots = new ArrayList<InterfaceSlot>();
            slots.add(new InterfaceSlot(slots.size()));
            for (Node node : graph.interfaceNodes) {
                boolean foundAssignment = false;
                boolean redoSort = false;
                for (InterfaceSlot slot2 : slots) {
                    InterfaceSlot.AddGroupingResult result = slot2.tryAddGrouping(node);
                    if (result == InterfaceSlot.AddGroupingResult.SUCCESS) {
                        foundAssignment = true;
                        node.type.setTypeCheckSlot(TypeCheckBuilder.getShortValue(slot2.id + this.startingSlotNum));
                        break;
                    }
                    if (result != InterfaceSlot.AddGroupingResult.CAPACITY_OVERFLOW) continue;
                    redoSort = true;
                }
                if (!foundAssignment) {
                    InterfaceSlot newSlot = new InterfaceSlot(slots.size());
                    InterfaceSlot.AddGroupingResult result = newSlot.tryAddGrouping(node);
                    assert (result == InterfaceSlot.AddGroupingResult.SUCCESS) : "must be able to add first node";
                    node.type.setTypeCheckSlot(TypeCheckBuilder.getShortValue(newSlot.id + this.startingSlotNum));
                    slots.add(newSlot);
                }
                if (!redoSort) continue;
                slots.sort(Comparator.comparingInt(slot -> slot.numReservedIDs));
            }
            int numSlots = slots.size();
            assert (this.numInterfaceSlots == -1);
            this.numInterfaceSlots = numSlots;
            for (Node node : graph.nodes) {
                assert (!this.interfaceSlotIDMap.containsKey(node.type));
                this.interfaceSlotIDMap.put(node.type, new int[numSlots]);
            }
            for (InterfaceSlot slot3 : slots) {
                List<BitSet> c1POrder = slot3.getC1POrder();
                int slotId = slot3.id;
                int id = 1;
                for (BitSet group : c1POrder) {
                    int nodeID = group.nextSetBit(0);
                    while (nodeID >= 0) {
                        HostedType type = graph.nodes[nodeID].type;
                        this.interfaceSlotIDMap.get((Object)type)[slotId] = id;
                        if (nodeID == Integer.MAX_VALUE) break;
                        nodeID = group.nextSetBit(nodeID + 1);
                    }
                    ++id;
                }
            }
            for (Node interfaceNode : graph.interfaceNodes) {
                int minId = Integer.MAX_VALUE;
                int maxId = Integer.MIN_VALUE;
                HostedType type = interfaceNode.type;
                int slotId = Short.toUnsignedInt(type.getTypeCheckSlot()) - this.startingSlotNum;
                for (Node descendant : interfaceNode.sortedDescendants) {
                    int id = this.interfaceSlotIDMap.get(descendant.type)[slotId];
                    assert (id != 0);
                    minId = Integer.min(minId, id);
                    maxId = Integer.max(maxId, id);
                }
                type.setTypeCheckRange(TypeCheckBuilder.getShortValue(minId), TypeCheckBuilder.getShortValue(maxId - minId + 1));
            }
            for (Node node : graph.nodes) {
                if (node.duplicates == null) continue;
                for (HostedType duplicate : node.duplicates) {
                    assert (!this.interfaceSlotIDMap.containsKey(duplicate));
                    this.interfaceSlotIDMap.put(duplicate, this.interfaceSlotIDMap.get(node.type));
                }
            }
        }

        private static class PrimeMatrix {
            final ContiguousGroup initialGroup;
            List<ContiguousGroup> containedGroups;
            Map<ContiguousGroup, Set<ContiguousGroup>> edgeMap;
            List<BitSet> c1POrdering;
            BitSet containedNodes;

            PrimeMatrix(ContiguousGroup initialGroup) {
                this.initialGroup = initialGroup;
                this.containedGroups = new ArrayList<ContiguousGroup>();
                this.containedGroups.add(initialGroup);
                this.edgeMap = new HashMap<ContiguousGroup, Set<ContiguousGroup>>();
            }

            void initializeC1PInformation() {
                this.containedNodes = new BitSet();
                this.c1POrdering = new ArrayList<BitSet>();
            }

            void copyC1PInformation(PrimeMatrix src) {
                this.containedNodes = (BitSet)src.containedNodes.clone();
                this.c1POrdering = new ArrayList<BitSet>();
                for (BitSet entry : src.c1POrdering) {
                    this.c1POrdering.add((BitSet)entry.clone());
                }
            }

            boolean incorporateMatrices(Set<PrimeMatrix> matrices, List<ContiguousGroup> edges) {
                assert (this.containedGroups.size() == 1) : "Matrices can only be combined once";
                PrimeMatrix largestMatrix = null;
                int largestMatrixSize = Integer.MIN_VALUE;
                for (PrimeMatrix matrix : matrices) {
                    int matrixSize = matrix.containedGroups.size();
                    assert (matrixSize > 0);
                    if (matrixSize <= largestMatrixSize) continue;
                    largestMatrixSize = matrixSize;
                    largestMatrix = matrix;
                }
                if (largestMatrix != null) {
                    this.copyC1PInformation(largestMatrix);
                } else {
                    this.initializeC1PInformation();
                }
                PrimeMatrix finalLargestMatrix = largestMatrix;
                List<ContiguousGroup> spanningTree = this.computeSpanningTree(edges, largestMatrix);
                int expectedNumNodes = 1 + matrices.stream().filter(n -> n != finalLargestMatrix).mapToInt(n -> n.containedGroups.size()).sum();
                assert (spanningTree.size() == expectedNumNodes);
                for (ContiguousGroup grouping : spanningTree) {
                    if (this.addGroupAndCheckC1P(grouping)) continue;
                    return false;
                }
                for (PrimeMatrix matrix : matrices) {
                    List<ContiguousGroup> otherGroup = matrix.containedGroups;
                    assert (otherGroup.stream().noneMatch(this.containedGroups::contains)) : "the intersection between all prime matrices should be null";
                    this.containedGroups.addAll(otherGroup);
                    Map<ContiguousGroup, Set<ContiguousGroup>> otherEdgeMap = matrix.edgeMap;
                    for (Map.Entry<ContiguousGroup, Set<ContiguousGroup>> entry : otherEdgeMap.entrySet()) {
                        ContiguousGroup key = entry.getKey();
                        this.edgeMap.computeIfAbsent(key, k -> new HashSet()).addAll((Collection)entry.getValue());
                    }
                }
                this.edgeMap.put(this.initialGroup, new HashSet());
                for (ContiguousGroup edge : edges) {
                    this.edgeMap.get(this.initialGroup).add(edge);
                    this.edgeMap.computeIfAbsent(edge, k -> new HashSet()).add(this.initialGroup);
                }
                return true;
            }

            List<ContiguousGroup> computeSpanningTree(List<ContiguousGroup> edges, PrimeMatrix largestMatrix) {
                ArrayList<ContiguousGroup> list = new ArrayList<ContiguousGroup>();
                list.add(this.initialGroup);
                HashSet<PrimeMatrix> coveredMatrices = new HashSet<PrimeMatrix>();
                if (largestMatrix != null) {
                    coveredMatrices.add(largestMatrix);
                }
                for (ContiguousGroup edge : edges) {
                    PrimeMatrix matrix = edge.primeMatrix;
                    if (coveredMatrices.contains(matrix)) continue;
                    coveredMatrices.add(matrix);
                    list.addAll(matrix.getSpanningTree(edge));
                }
                return list;
            }

            List<ContiguousGroup> getSpanningTree(ContiguousGroup startingNode) {
                HashSet<ContiguousGroup> seenNodes = new HashSet<ContiguousGroup>();
                ArrayList<ContiguousGroup> list = new ArrayList<ContiguousGroup>();
                this.getSpanningTreeHelper(startingNode, list, seenNodes);
                return list;
            }

            void getSpanningTreeHelper(ContiguousGroup node, List<ContiguousGroup> list, Set<ContiguousGroup> seenNodes) {
                list.add(node);
                seenNodes.add(node);
                Set<ContiguousGroup> edges = this.edgeMap.get(node);
                if (edges != null) {
                    for (ContiguousGroup edge : edges) {
                        if (seenNodes.contains(edge)) continue;
                        this.getSpanningTreeHelper(edge, list, seenNodes);
                    }
                }
            }

            boolean addGroupAndCheckC1P(ContiguousGroup grouping) {
                BitSet newGroup = new BitSet();
                Arrays.stream(grouping.sortedGroupIds).forEach(i -> newGroup.set(i));
                BitSet uncoveredNodes = (BitSet)newGroup.clone();
                uncoveredNodes.andNot(this.containedNodes);
                int numSets = this.c1POrdering.size();
                if (numSets == 0) {
                    assert (uncoveredNodes.equals(newGroup));
                    this.c1POrdering.add(uncoveredNodes);
                } else if (numSets == 1) {
                    this.c1POrdering.get(0).andNot(newGroup);
                    newGroup.and(this.containedNodes);
                    this.c1POrdering.add(newGroup);
                    this.c1POrdering.add(uncoveredNodes);
                } else {
                    int i2;
                    SetColor[] setColors = new SetColor[this.c1POrdering.size()];
                    int leftIntersect = Integer.MIN_VALUE;
                    int rightIntersect = Integer.MIN_VALUE;
                    for (i2 = 0; i2 < this.c1POrdering.size(); ++i2) {
                        SetColor color;
                        setColors[i2] = color = SetColor.getSetColor(this.c1POrdering.get(i2), newGroup);
                        if (color == SetColor.EMPTY) continue;
                        if (leftIntersect == Integer.MIN_VALUE) {
                            leftIntersect = i2;
                        }
                        rightIntersect = i2;
                    }
                    assert (leftIntersect != Integer.MIN_VALUE && rightIntersect != Integer.MIN_VALUE);
                    for (i2 = leftIntersect + 1; i2 < rightIntersect; ++i2) {
                        if (setColors[i2] == SetColor.FULL) continue;
                        return false;
                    }
                    SetColor rightColor = setColors[rightIntersect];
                    SetColor leftColor = setColors[leftIntersect];
                    if (uncoveredNodes.isEmpty()) {
                        this.splitColoredNodes(rightColor, newGroup, rightIntersect, rightIntersect);
                        if (leftIntersect != rightIntersect) {
                            this.splitColoredNodes(leftColor, newGroup, leftIntersect, leftIntersect + 1);
                        }
                    } else if (leftIntersect == 0 && leftColor == SetColor.FULL) {
                        this.splitColoredNodes(rightColor, newGroup, rightIntersect, rightIntersect);
                        this.c1POrdering.add(0, uncoveredNodes);
                    } else if (rightIntersect == numSets - 1 && rightColor == SetColor.FULL) {
                        this.splitColoredNodes(leftColor, newGroup, leftIntersect, leftIntersect + 1);
                        this.c1POrdering.add(uncoveredNodes);
                    } else {
                        return false;
                    }
                }
                this.containedNodes.or(uncoveredNodes);
                return true;
            }

            void splitColoredNodes(SetColor color, BitSet coloredSet, int srcIndex, int dstIndex) {
                assert (color != SetColor.EMPTY);
                if (color != SetColor.FULL) {
                    BitSet newSet = SetColor.splitOffColored(this.c1POrdering.get(srcIndex), coloredSet);
                    this.c1POrdering.add(dstIndex, newSet);
                }
            }

            static final class SetColor
            extends Enum<SetColor> {
                public static final /* enum */ SetColor EMPTY = new SetColor();
                public static final /* enum */ SetColor PARTIAL = new SetColor();
                public static final /* enum */ SetColor FULL = new SetColor();
                private static final /* synthetic */ SetColor[] $VALUES;

                public static SetColor[] values() {
                    return (SetColor[])$VALUES.clone();
                }

                public static SetColor valueOf(String name) {
                    return Enum.valueOf(SetColor.class, name);
                }

                private static SetColor getSetColor(BitSet set, BitSet coloredSet) {
                    if (!set.intersects(coloredSet)) {
                        return EMPTY;
                    }
                    BitSet intersection = (BitSet)set.clone();
                    intersection.and(coloredSet);
                    if (intersection.equals(set)) {
                        return FULL;
                    }
                    return PARTIAL;
                }

                private static BitSet splitOffColored(BitSet set, BitSet coloredSet) {
                    BitSet coloredNodes = (BitSet)set.clone();
                    coloredNodes.and(coloredSet);
                    set.andNot(coloredNodes);
                    assert (!coloredNodes.isEmpty() && !set.isEmpty());
                    return coloredNodes;
                }

                static {
                    $VALUES = new SetColor[]{EMPTY, PARTIAL, FULL};
                }
            }
        }

        private static final class InterfaceSlot {
            final int id;
            int currentTimeStamp;
            int numReservedIDs;
            Set<PrimeMatrix> matrices = new HashSet<PrimeMatrix>();
            Map<Integer, Set<ContiguousGroup>> columnToGroupingMap = new HashMap<Integer, Set<ContiguousGroup>>();

            InterfaceSlot(int id) {
                this.id = id;
                this.currentTimeStamp = 0;
                this.numReservedIDs = 1;
            }

            AddGroupingResult tryAddGrouping(Node interfaceNode) {
                PrimeMatrix newPrimeMatrix;
                int[] sortedGroupIds = Arrays.stream(interfaceNode.sortedDescendants).mapToInt(n -> n.id).toArray();
                ContiguousGroup newGrouping = new ContiguousGroup(sortedGroupIds);
                int timestamp = ++this.currentTimeStamp;
                ArrayList<ContiguousGroup> edges = new ArrayList<ContiguousGroup>();
                HashSet<PrimeMatrix> linkedPrimeMatrices = new HashSet<PrimeMatrix>();
                for (int column : sortedGroupIds) {
                    Set<ContiguousGroup> groupings = this.columnToGroupingMap.get(column);
                    if (groupings == null) continue;
                    for (ContiguousGroup existingGrouping : groupings) {
                        if (existingGrouping.lastTimeStamp == timestamp) continue;
                        existingGrouping.lastTimeStamp = timestamp;
                        boolean strictlyOverlap = InterfaceSlot.strictlyOverlaps(newGrouping, existingGrouping);
                        if (!strictlyOverlap) continue;
                        edges.add(existingGrouping);
                        linkedPrimeMatrices.add(existingGrouping.primeMatrix);
                    }
                }
                newGrouping.primeMatrix = newPrimeMatrix = new PrimeMatrix(newGrouping);
                boolean satisfiesC1P = newPrimeMatrix.incorporateMatrices(linkedPrimeMatrices, edges);
                if (!satisfiesC1P) {
                    return AddGroupingResult.INVALID_C1P;
                }
                int numIDsDelta = newPrimeMatrix.c1POrdering.size() - linkedPrimeMatrices.stream().mapToInt(n -> n.c1POrdering.size()).sum();
                assert (numIDsDelta >= 0);
                int newNumReservedIDs = this.numReservedIDs + numIDsDelta;
                if (newNumReservedIDs > 65536) {
                    return AddGroupingResult.CAPACITY_OVERFLOW;
                }
                this.numReservedIDs = newNumReservedIDs;
                this.matrices.add(newPrimeMatrix);
                for (PrimeMatrix removedMatrix : linkedPrimeMatrices) {
                    this.matrices.remove(removedMatrix);
                    for (ContiguousGroup grouping : removedMatrix.containedGroups) {
                        grouping.primeMatrix = newPrimeMatrix;
                    }
                }
                for (Object connection : (Object)sortedGroupIds) {
                    this.columnToGroupingMap.computeIfAbsent((int)connection, k -> new HashSet()).add(newGrouping);
                }
                return AddGroupingResult.SUCCESS;
            }

            static boolean strictlyOverlaps(ContiguousGroup a, ContiguousGroup b) {
                int[] aArray = a.sortedGroupIds;
                int[] bArray = b.sortedGroupIds;
                int aLength = aArray.length;
                int bLength = bArray.length;
                int aIdx = 0;
                int bIdx = 0;
                int numMatches = 0;
                while (aIdx < aLength && bIdx < bLength) {
                    int aValue = aArray[aIdx];
                    int bValue = bArray[bIdx];
                    if (aValue == bValue) {
                        ++numMatches;
                        ++aIdx;
                        ++bIdx;
                        continue;
                    }
                    if (aValue < bValue) {
                        ++aIdx;
                        continue;
                    }
                    ++bIdx;
                }
                int minLength = Math.min(aLength, bLength);
                assert (numMatches != 0 && numMatches <= minLength);
                assert (aLength != bLength || numMatches != aLength);
                return numMatches != minLength;
            }

            List<BitSet> getC1POrder() {
                List sizeOrderedMatrices = this.matrices.stream().sorted(Comparator.comparingInt(n -> -n.containedNodes.cardinality())).collect(Collectors.toList());
                ArrayList<BitSet> c1POrdering = new ArrayList<BitSet>();
                BitSet coveredNodes = new BitSet();
                block0: for (PrimeMatrix matrix : sizeOrderedMatrices) {
                    List<BitSet> newOrderingConstraints = matrix.c1POrdering;
                    assert (!matrix.containedNodes.isEmpty());
                    int matrixRepresentativeIndex = matrix.containedNodes.nextSetBit(0);
                    boolean hasOverlap = coveredNodes.get(matrixRepresentativeIndex);
                    if (!hasOverlap) {
                        assert (!coveredNodes.intersects(matrix.containedNodes));
                        c1POrdering.addAll(newOrderingConstraints);
                        coveredNodes.or(matrix.containedNodes);
                        continue;
                    }
                    BitSet testBitSet = (BitSet)coveredNodes.clone();
                    testBitSet.and(matrix.containedNodes);
                    boolean result = testBitSet.equals(matrix.containedNodes);
                    assert (result);
                    assert (InterfaceSlot.verifyC1POrderingProperty(c1POrdering, matrix));
                    for (int i = 0; i < c1POrdering.size(); ++i) {
                        BitSet item = (BitSet)c1POrdering.get(i);
                        hasOverlap = item.get(matrixRepresentativeIndex);
                        if (!hasOverlap) continue;
                        item.andNot(matrix.containedNodes);
                        c1POrdering.addAll(i + 1, newOrderingConstraints);
                        if (!item.isEmpty()) continue block0;
                        c1POrdering.remove(i);
                        continue block0;
                    }
                }
                return c1POrdering;
            }

            static boolean verifyC1POrderingProperty(List<BitSet> c1POrdering, PrimeMatrix matrix) {
                ArrayList<Integer> overlappingSets = new ArrayList<Integer>();
                for (int i = 0; i < c1POrdering.size(); ++i) {
                    BitSet item = c1POrdering.get(i);
                    boolean hasOverlap = item.intersects(matrix.containedNodes);
                    if (!hasOverlap) continue;
                    overlappingSets.add(i);
                }
                return overlappingSets.size() == 1;
            }

            static enum AddGroupingResult {
                CAPACITY_OVERFLOW,
                INVALID_C1P,
                SUCCESS;

            }
        }

        private static final class ContiguousGroup {
            final int[] sortedGroupIds;
            PrimeMatrix primeMatrix;
            int lastTimeStamp = -1;

            ContiguousGroup(int[] sortedGroupIds) {
                this.sortedGroupIds = sortedGroupIds;
            }
        }

        private static class Graph {
            Node[] nodes;
            Node[] interfaceNodes;

            Graph(Node[] nodes) {
                this.nodes = nodes;
            }

            void mergeDuplicates() {
                HashMap<Integer, ArrayList> interfaceHashMap = new HashMap<Integer, ArrayList>();
                HashMap classHashMap = new HashMap();
                HashMap<Node, Set<HostedType>> duplicateMap = new HashMap<Node, Set<HostedType>>();
                for (Node node : this.nodes) {
                    Node[] ancestors = node.sortedAncestors;
                    int length = ancestors.length;
                    assert (length != 0);
                    boolean isNodeInterface = node.isInterface;
                    if (length == 1) {
                        if (isNodeInterface) continue;
                        Node ancestor = ancestors[0];
                        Graph.recordDuplicateRelation(duplicateMap, ancestor, node);
                        this.nodes[node.id] = null;
                        continue;
                    }
                    int hash = Graph.getDuplicateHash(ancestors);
                    HashMap<Integer, ArrayList> destinationMap = isNodeInterface ? interfaceHashMap : classHashMap;
                    destinationMap.computeIfAbsent(hash, k -> new ArrayList()).add(node);
                }
                for (Map.Entry entry : interfaceHashMap.entrySet()) {
                    ArrayList interfaces = (ArrayList)entry.getValue();
                    ArrayList classes = (ArrayList)classHashMap.get(entry.getKey());
                    if (classes == null) continue;
                    for (Node interfaceNode : interfaces) {
                        for (int i = 0; i < classes.size(); ++i) {
                            Node classNode = (Node)classes.get(i);
                            if (classNode == null || !this.tryMergeNodes(duplicateMap, interfaceNode, classNode)) continue;
                            classes.set(i, null);
                        }
                    }
                }
                for (Map.Entry entry : classHashMap.entrySet()) {
                    ArrayList classes = (ArrayList)entry.getValue();
                    int numClasses = classes.size();
                    for (int i = 0; i < numClasses - 1; ++i) {
                        Node classNode = (Node)classes.get(i);
                        if (classNode == null) continue;
                        for (int j = i + 1; j < numClasses; ++j) {
                            Node duplicateCandidate = (Node)classes.get(j);
                            if (duplicateCandidate == null || !this.tryMergeNodes(duplicateMap, classNode, duplicateCandidate)) continue;
                            classes.set(j, null);
                        }
                    }
                }
                for (Map.Entry entry : duplicateMap.entrySet()) {
                    ((Node)entry.getKey()).duplicates = (Set)entry.getValue();
                }
                ArrayList<Node> compactedNodeArray = new ArrayList<Node>();
                for (Node node : this.nodes) {
                    if (node == null) continue;
                    node.id = compactedNodeArray.size();
                    compactedNodeArray.add(node);
                }
                this.nodes = compactedNodeArray.toArray(new Node[0]);
            }

            static int getDuplicateHash(Node[] ancestors) {
                int length = ancestors.length;
                return (length << 16) + Arrays.stream(ancestors).mapToInt(n -> n.id * n.id).sum();
            }

            boolean tryMergeNodes(Map<Node, Set<HostedType>> duplicateMap, Node node, Node duplicateCandidate) {
                if (Graph.areDuplicates(node, duplicateCandidate)) {
                    Graph.recordDuplicateRelation(duplicateMap, node, duplicateCandidate);
                    int duplicateIdx = duplicateCandidate.id;
                    assert (!this.nodes[duplicateIdx].isInterface);
                    this.nodes[duplicateIdx] = null;
                    return true;
                }
                return false;
            }

            static boolean areDuplicates(Node a, Node b) {
                Node[] aAncestors = a.sortedAncestors;
                Node[] bAncestors = b.sortedAncestors;
                if (aAncestors.length != bAncestors.length) {
                    return false;
                }
                for (int i = 0; i < aAncestors.length; ++i) {
                    if (aAncestors[i] == bAncestors[i]) continue;
                    return false;
                }
                return true;
            }

            static void recordDuplicateRelation(Map<Node, Set<HostedType>> duplicateMap, Node node, Node duplicate) {
                assert (!duplicateMap.containsKey(duplicate)) : "By removing this node, duplicate records are being lost.";
                duplicateMap.computeIfAbsent(node, k -> new HashSet()).add(duplicate.type);
            }

            void generateDescendantIndex() {
                HashMap<Node, Set> descendantMap = new HashMap<Node, Set>();
                Node[] emptyDescendant = new Node[]{};
                ArrayList<Node> interfaceList = new ArrayList<Node>();
                for (int i = this.nodes.length - 1; i >= 0; --i) {
                    Node node = this.nodes[i];
                    if (node.isInterface) {
                        Set descendants = descendantMap.computeIfAbsent(node, k -> new HashSet());
                        descendants.add(node);
                        Node[] descendantArray = descendants.toArray(new Node[0]);
                        Arrays.sort(descendantArray, Comparator.comparingInt(n -> n.id));
                        node.sortedDescendants = descendantArray;
                        interfaceList.add(node);
                    } else {
                        node.sortedDescendants = emptyDescendant;
                    }
                    for (Node ancestor : node.sortedAncestors) {
                        descendantMap.computeIfAbsent(ancestor, k -> new HashSet()).add(node);
                    }
                }
                this.interfaceNodes = interfaceList.toArray(new Node[0]);
            }

            static Graph buildInterfaceGraph(List<HostedType> heightOrderedTypes, Map<HostedType, List<HostedType>> subtypeMap) {
                HashMap<HostedType, Set> interfaceAncestors = new HashMap<HostedType, Set>();
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (HostedType type : heightOrderedTypes) {
                    boolean isTypeInterface;
                    Set ancestors = interfaceAncestors.computeIfAbsent(type, arg_0 -> Graph.lambda$buildInterfaceGraph$6(isTypeInterface = TypeCheckBuilder.isInterface(type), arg_0));
                    if (ancestors == null) continue;
                    int id = nodes.size();
                    Node newNode = new Node(id, type, isTypeInterface);
                    nodes.add(newNode);
                    if (isTypeInterface) {
                        ancestors.add(newNode);
                    }
                    Node[] sortedAncestors = ancestors.toArray(new Node[0]);
                    Arrays.sort(sortedAncestors, Comparator.comparingInt(n -> n.id));
                    newNode.sortedAncestors = sortedAncestors;
                    for (HostedType child : subtypeMap.get(type)) {
                        interfaceAncestors.computeIfAbsent(child, k -> new HashSet()).addAll(ancestors);
                    }
                }
                Node[] nodeArray = nodes.toArray(new Node[0]);
                int maxAncestors = -1;
                for (Node node : nodeArray) {
                    maxAncestors = Math.max(maxAncestors, node.sortedAncestors.length);
                }
                return new Graph(nodeArray);
            }

            private static /* synthetic */ Set lambda$buildInterfaceGraph$6(boolean isTypeInterface, HostedType k) {
                return isTypeInterface ? new HashSet() : null;
            }
        }

        private static final class Node {
            Node[] sortedAncestors;
            Node[] sortedDescendants;
            int id;
            final HostedType type;
            final boolean isInterface;
            Set<HostedType> duplicates;

            Node(int id, HostedType type, boolean isInterface) {
                this.id = id;
                this.type = type;
                this.isInterface = isInterface;
            }
        }
    }

    private static final class ClassIDBuilder {
        final HostedType objectType;
        final List<HostedType> allIncludedRoots;
        final List<HostedType> heightOrderedTypes;
        final Map<HostedType, List<HostedType>> subtypeMap;
        final Map<HostedType, int[]> classSlotIDMap = new HashMap<HostedType, int[]>();
        int numClassSlots = -1;

        ClassIDBuilder(HostedType objectType, List<HostedType> allIncludedRoots, List<HostedType> heightOrderedTypes, Map<HostedType, List<HostedType>> subtypeMap) {
            this.objectType = objectType;
            this.heightOrderedTypes = heightOrderedTypes;
            this.allIncludedRoots = allIncludedRoots;
            this.subtypeMap = subtypeMap;
        }

        void computeSlots() {
            Map<HostedType, Integer> numClassDescendantsMap = this.computeNumClassDescendants();
            this.calculateIDs(numClassDescendantsMap);
        }

        Map<HostedType, Integer> computeNumClassDescendants() {
            HashMap<HostedType, Integer> numClassDescendantsMap = new HashMap<HostedType, Integer>();
            for (int i = this.heightOrderedTypes.size() - 1; i >= 0; --i) {
                HostedType type = this.heightOrderedTypes.get(i);
                if (TypeCheckBuilder.isInterface(type)) continue;
                int numDescendants = 0;
                for (HostedType child : this.subtypeMap.get(type)) {
                    if (TypeCheckBuilder.isInterface(child)) continue;
                    numDescendants += 1 + (Integer)numClassDescendantsMap.get(child);
                }
                numClassDescendantsMap.put(type, numDescendants);
            }
            return numClassDescendantsMap;
        }

        void calculateIDs(Map<HostedType, Integer> numClassDescendantsMap) {
            ArrayList<Integer> currentIDs = new ArrayList<Integer>();
            ArrayList<Integer> numReservedIDs = new ArrayList<Integer>();
            currentIDs.add(0);
            numReservedIDs.add(0);
            for (HostedType root : this.allIncludedRoots) {
                this.assignID(root, numClassDescendantsMap, currentIDs, numReservedIDs);
            }
            assert (this.numClassSlots == -1);
            this.numClassSlots = currentIDs.size();
            for (HostedType type : this.heightOrderedTypes) {
                if (!TypeCheckBuilder.isInterface(type)) continue;
                int dim = type.getArrayDimension();
                assert (!this.classSlotIDMap.containsKey(type));
                this.classSlotIDMap.put(type, this.classSlotIDMap.get(this.objectType.getArrayClass(dim)));
            }
        }

        void assignID(HostedType type, Map<HostedType, Integer> numClassDescendantsMap, ArrayList<Integer> currentIDs, ArrayList<Integer> numReservedIDs) {
            assert (!TypeCheckBuilder.isInterface(type));
            int numClassDescendants = numClassDescendantsMap.get(type);
            TypeState state = ClassIDBuilder.generateTypeState(numClassDescendants, currentIDs, numReservedIDs);
            int reservedID = state.reservedID;
            int slotNum = state.slotNum;
            int assignedID = state.assignedID;
            int maxSubtypeID = state.maxSubtypeID;
            assert (!this.classSlotIDMap.containsKey(type));
            this.classSlotIDMap.put(type, currentIDs.stream().mapToInt(n -> n).toArray());
            for (HostedType subtype : this.subtypeMap.get(type)) {
                if (TypeCheckBuilder.isInterface(subtype)) continue;
                this.assignID(subtype, numClassDescendantsMap, currentIDs, numReservedIDs);
                assert (currentIDs.get(slotNum) >= assignedID);
            }
            assert (currentIDs.get(slotNum) == maxSubtypeID);
            type.setTypeCheckSlot(TypeCheckBuilder.getShortValue(slotNum));
            type.setTypeCheckRange(TypeCheckBuilder.getShortValue(assignedID), TypeCheckBuilder.getShortValue(maxSubtypeID - assignedID + 1));
            if (reservedID != 0) {
                assert (numReservedIDs.get(slotNum) == reservedID);
                int newNumReservedIDs = reservedID - 1;
                numReservedIDs.set(slotNum, newNumReservedIDs);
                currentIDs.set(slotNum, newNumReservedIDs == 0 ? 0 : 65536 - newNumReservedIDs);
            }
        }

        static TypeState generateTypeState(int numClassDescendants, ArrayList<Integer> currentIDs, ArrayList<Integer> numReservedIDs) {
            int maxSubtypeID;
            int reservedID = 0;
            int slotNum = currentIDs.size() - 1;
            int assignedID = currentIDs.get(slotNum) + 1;
            int currentNumReservedIDs = numReservedIDs.get(slotNum);
            int currentCapacity = 65536 - currentNumReservedIDs;
            assert (assignedID <= currentCapacity);
            if (assignedID == currentCapacity) {
                currentIDs.set(slotNum, currentNumReservedIDs == 0 ? 0 : 65536 - currentNumReservedIDs);
                ++slotNum;
                currentIDs.add(0);
                currentNumReservedIDs = 0;
                currentCapacity = 65536;
                numReservedIDs.add(currentNumReservedIDs);
                assignedID = 1;
            }
            if ((maxSubtypeID = assignedID + numClassDescendants) >= currentCapacity) {
                if (assignedID + 1 == currentCapacity) {
                    currentIDs.set(slotNum, currentNumReservedIDs == 0 ? 0 : 65536 - currentNumReservedIDs);
                    ++slotNum;
                    currentIDs.add(0);
                    currentNumReservedIDs = 0;
                    currentCapacity = 65536;
                    numReservedIDs.add(currentNumReservedIDs);
                    assignedID = 1;
                    maxSubtypeID = assignedID + numClassDescendants;
                }
                if (maxSubtypeID >= currentCapacity) {
                    reservedID = ++currentNumReservedIDs;
                    maxSubtypeID = 65536 - reservedID;
                    numReservedIDs.set(slotNum, currentNumReservedIDs);
                }
            }
            currentIDs.set(slotNum, assignedID);
            return new TypeState(reservedID, slotNum, assignedID, maxSubtypeID);
        }

        private static final class TypeState {
            final int reservedID;
            final int slotNum;
            final int assignedID;
            final int maxSubtypeID;

            private TypeState(int reservedID, int slotNum, int assignedID, int maxSubtypeID) {
                this.reservedID = reservedID;
                this.slotNum = slotNum;
                this.assignedID = assignedID;
                this.maxSubtypeID = maxSubtypeID;
            }
        }
    }
}

