/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import java.awt.Composite;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.io.FilenameFilter;
import java.util.function.BooleanSupplier;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.java2d.SurfaceData;
import sun.java2d.pipe.Region;

@Platforms(value={Platform.LINUX.class})
public final class JavaAWTSubstitutions {

    static class IsHeadless
    implements BooleanSupplier {
        IsHeadless() {
        }

        @Override
        public boolean getAsBoolean() {
            return GraphicsEnvironment.isHeadless() && JavaVersionUtil.JAVA_SPEC >= 11;
        }
    }

    @TargetClass(className="sun.awt.X11.XRobotPeer", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11_XRobotPeer {
        Target_sun_awt_X11_XRobotPeer() {
        }

        @Substitute
        private static void loadNativeLibraries() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11.GtkFileDialogPeer", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11_GtkFileDialogPeer {
        Target_sun_awt_X11_GtkFileDialogPeer() {
        }

        @Substitute
        private static void initIDs() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private void quit() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private void run(String title, int mode, String dir, String file, FilenameFilter filter, boolean isMultipleMode, int x, int y) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void setBounds(int x, int y, int width, int height, int op) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void toFront() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11.XDesktopPeer", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11_XDesktopPeer {
        Target_sun_awt_X11_XDesktopPeer() {
        }

        @Substitute
        private static void initWithLock() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11.XTaskbarPeer", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11_XTaskbarPeer {
        Target_sun_awt_X11_XTaskbarPeer() {
        }

        @Substitute
        private static void initWithLock() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.java2d.opengl.OGLRenderQueue", onlyWith={IsHeadless.class})
    static final class Target_sun_java2d_opengl_OGLRenderQueue {
        Target_sun_java2d_opengl_OGLRenderQueue() {
        }

        @Substitute
        private void flushBuffer(long buf, int limit) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.java2d.opengl.OGLSurfaceData", onlyWith={IsHeadless.class})
    static final class Target_sun_java2d_opengl_OGLSurfaceData {
        Target_sun_java2d_opengl_OGLSurfaceData() {
        }

        @Substitute
        protected boolean initFlipBackbuffer(long pData) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="java.awt.AWTEvent", onlyWith={IsHeadless.class})
    static final class Target_java_awt_AWTEvent {
        Target_java_awt_AWTEvent() {
        }

        @Substitute
        private void nativeSetSource(ComponentPeer peer) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11GraphicsConfig", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11GraphicsConfig {
        Target_sun_awt_X11GraphicsConfig() {
        }

        @Substitute
        static void initIDs() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.UNIXToolkit", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_UNIXToolkit {
        Target_sun_awt_UNIXToolkit() {
        }

        @Substitute
        private static boolean load_gtk(int version, boolean verbose) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void sync() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public BufferedImage getStockIcon(int widgetType, String stockId, int iconSize, int direction, String detail) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public boolean isNativeGTKAvailable() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private boolean gtkCheckVersionImpl(int major, int minor, int micro) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11InputMethodBase", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11InputMethodBase {
        Target_sun_awt_X11InputMethodBase() {
        }

        @Substitute
        static void initIDs() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void turnoffStatusWindow() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        boolean setCompositionEnabledNative(boolean enable) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        boolean isCompositionEnabledNative() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        String resetXIC() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void disposeXIC() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.java2d.xr.XRBackendNative", onlyWith={IsHeadless.class})
    static final class Target_sun_java2d_xr_XRBackendNative {
        Target_sun_java2d_xr_XRBackendNative() {
        }

        @Substitute
        static void initIDs() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static void XRAddGlyphsNative(int glyphSet, long[] glyphInfoPtrs, int glyphCnt, byte[] pixelData, int pixelDataLength) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static int XRCreateLinearGradientPaintNative(float[] fractionsArray, short[] pixelsArray, int x1, int y1, int x2, int y2, int numStops, int repeat) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static void XRSetClipNative(long dst, int x1, int y1, int x2, int y2, Region clip, boolean isGC) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static void XRenderCompositeTextNative(int op, int src, int dst, int srcX, int srcY, long maskFormat, int[] eltArray, int[] glyphIDs, int eltCnt, int glyphCnt) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static void GCRectanglesNative(int drawable, long gc, int[] rectArray, int rectCnt) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static void XRFreeGlyphsNative(int glyphSet, int[] gids, int idCnt) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static void XRenderRectanglesNative(int dst, byte op, short red, short green, short blue, short alpha, int[] rects, int rectCnt) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private static int XRCreateRadialGradientPaintNative(float[] fractionsArray, short[] pixelsArray, int numStops, int centerX, int centerY, int innerRadius, int outerRadius, int repeat) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void renderComposite(byte op, int src, int mask, int dst, int srcX, int srcY, int maskX, int maskY, int dstX, int dstY, int width, int height) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void setGCMode(long gc, boolean copy) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void freePicture(int picture) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void setPictureRepeat(int picture, int repeat) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void setGCForeground(long gc, int pixel) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void setFilter(int picture, int filter) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private void renderRectangle(int dst, byte op, short red, short green, short blue, short alpha, int x, int y, int width, int height) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        private void XRSetTransformNative(int pic, int m00, int m01, int m02, int m10, int m11, int m12) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void setGCExposures(long gc, boolean exposure) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void copyArea(int src, int dst, long gc, int srcx, int srcy, int width, int height, int dstx, int dsty) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11.XlibWrapper", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11_XlibWrapper {
        Target_sun_awt_X11_XlibWrapper() {
        }

        @Substitute
        static long DisplayWidth(long display, long screen) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static long DefaultScreen(long display) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static long DisplayWidthMM(long display, long screen) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static long InternAtom(long display, String string, int only_if_exists) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static void XSync(long display, int discard) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static long XAllocSizeHints() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static String[] XTextPropertyToStringList(byte[] bytes, long encoding_atom) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static String XGetAtomName(long display, long atom) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static byte[] getStringBytes(long str_ptr) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static long XAllocWMHints() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static void XFree(long ptr) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static void memcpy(long dest_ptr, long src_ptr, long length) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static long SetToolkitErrorHandler() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11.XBaseWindow", onlyWith={IsHeadless.class})
    @Delete
    static final class Target_sun_awt_X11_XBaseWindow {
        Target_sun_awt_X11_XBaseWindow() {
        }
    }

    @TargetClass(className="sun.awt.X11.XWindow", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11_XWindow {
        Target_sun_awt_X11_XWindow() {
        }

        @Substitute
        private static void initIDs() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="java.awt.Window", onlyWith={IsHeadless.class})
    static final class Target_java_awt_Window {
        Target_java_awt_Window() {
        }

        @Substitute
        void dispose() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void doDispose() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void closeSplashScreen() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.X11.XToolkit", onlyWith={IsHeadless.class})
    static final class Target_sun_awt_X11_XToolkit {
        Target_sun_awt_X11_XToolkit() {
        }

        @Substitute
        static String getEnv(String key) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        static void wakeup_poll() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void run() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        int getNumberOfButtons() {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.font.FcFontConfiguration", onlyWith={JDK11OrLater.class})
    static final class Target_sun_font_FcFontConfiguration {
        @Alias
        private Target_sun_font_FontConfigManager_FcCompFont[] fcCompFonts;
        @Alias
        protected Target_sun_font_SunFontManager fontManager;

        Target_sun_font_FcFontConfiguration() {
        }

        @Alias
        private native void readFcInfo();

        @Alias
        private native void writeFcInfo();

        @Alias
        private static native void warning(String var0);

        @Substitute
        public synchronized boolean init() {
            if (this.fcCompFonts != null) {
                return true;
            }
            SubstrateUtil.cast(this, Target_sun_awt_FontConfiguration.class).setFontConfiguration();
            this.readFcInfo();
            Target_sun_awt_FcFontManager fm = SubstrateUtil.cast(this.fontManager, Target_sun_awt_FcFontManager.class);
            Target_sun_font_FontConfigManager fcm = fm.getFontConfigManager();
            if (this.fcCompFonts == null) {
                this.fcCompFonts = fcm.loadFontConfig();
                if (this.fcCompFonts != null) {
                    try {
                        this.writeFcInfo();
                    }
                    catch (Exception e) {
                        if (Target_sun_font_FontUtilities.debugFonts()) {
                            Target_sun_font_FcFontConfiguration.warning("Exception writing fcInfo " + e);
                        }
                    }
                } else if (Target_sun_font_FontUtilities.debugFonts()) {
                    Target_sun_font_FcFontConfiguration.warning("Failed to get info from libfontconfig");
                }
            } else {
                fcm.populateFontConfig(this.fcCompFonts);
            }
            return this.fcCompFonts != null;
        }
    }

    @TargetClass(className="sun.font.FontUtilities", onlyWith={JDK11OrLater.class})
    static final class Target_sun_font_FontUtilities {
        Target_sun_font_FontUtilities() {
        }

        @Alias
        public static native boolean debugFonts();
    }

    @TargetClass(className="sun.font.FontConfigManager", onlyWith={JDK11OrLater.class})
    static final class Target_sun_font_FontConfigManager {
        Target_sun_font_FontConfigManager() {
        }

        @Alias
        native Target_sun_font_FontConfigManager_FcCompFont[] loadFontConfig();

        @Alias
        native void populateFontConfig(Target_sun_font_FontConfigManager_FcCompFont[] var1);
    }

    @TargetClass(className="sun.awt.FcFontManager", onlyWith={JDK11OrLater.class})
    static final class Target_sun_awt_FcFontManager {
        Target_sun_awt_FcFontManager() {
        }

        @Alias
        public synchronized native Target_sun_font_FontConfigManager getFontConfigManager();
    }

    @TargetClass(className="sun.font.SunFontManager", onlyWith={JDK11OrLater.class})
    static final class Target_sun_font_SunFontManager {
        Target_sun_font_SunFontManager() {
        }
    }

    @TargetClass(className="sun.font.FontConfigManager", innerClass={"FcCompFont"}, onlyWith={JDK11OrLater.class})
    static final class Target_sun_font_FontConfigManager_FcCompFont {
        Target_sun_font_FontConfigManager_FcCompFont() {
        }
    }

    @TargetClass(className="sun.awt.FontConfiguration", onlyWith={JDK11OrLater.class})
    static final class Target_sun_awt_FontConfiguration {
        Target_sun_awt_FontConfiguration() {
        }

        @Substitute
        public boolean foundOsSpecificFile() {
            return false;
        }

        @Substitute
        private void findFontConfigFile() {
        }

        @Alias
        protected native void setFontConfiguration();
    }

    @TargetClass(className="sun.font.FileFontStrike", onlyWith={JDK11OrLater.class})
    static final class Target_sun_font_FileFontStrike {
        Target_sun_font_FileFontStrike() {
        }

        @Substitute
        static boolean initNative() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        long _getGlyphImageFromWindows(String family, int style, int size, int glyphCode, boolean fracMetrics, int fontDataSize) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.java2d.loops.TransformBlit", onlyWith={JDK11OrLater.class})
    static final class Target_sun_java2d_loops_TransformBlit {
        Target_sun_java2d_loops_TransformBlit() {
        }

        @Substitute
        void Transform(SurfaceData src, SurfaceData dst, Composite comp, Region clip, AffineTransform at, int hint, int srcx, int srcy, int dstx, int dsty, int width, int height) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.DebugSettings", onlyWith={JDK11OrLater.class})
    static final class Target_sun_awt_DebugSettings {
        Target_sun_awt_DebugSettings() {
        }

        @Substitute
        void setCTracingOn(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void setCTracingOn(boolean enabled, String file) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void setCTracingOn(boolean enabled, String file, int line) {
            throw new UnsupportedOperationException();
        }
    }
}

