/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class LayoutEncoding {
    private static final int NEUTRAL_VALUE = 0;
    private static final int PRIMITIVE_VALUE = 1;
    private static final int INTERFACE_VALUE = 2;
    private static final int ABSTRACT_VALUE = 3;
    private static final int LAST_SPECIAL_VALUE = 3;
    private static final int ARRAY_INDEX_SHIFT_SHIFT = 0;
    private static final int ARRAY_INDEX_SHIFT_MASK = 255;
    private static final int ARRAY_BASE_SHIFT = 8;
    private static final int ARRAY_BASE_MASK = 4095;
    private static final int ARRAY_TAG_BITS = 2;
    private static final int ARRAY_TAG_SHIFT = 30;
    private static final int ARRAY_TAG_PRIMITIVE_VALUE = -1;
    private static final int ARRAY_TAG_OBJECT_VALUE = -2;

    public static int forPrimitive() {
        return 1;
    }

    public static int forInterface() {
        return 2;
    }

    public static int forAbstract() {
        return 3;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void guaranteeEncoding(ResolvedJavaType type, boolean condition, String description) {
        VMError.guarantee(condition, description + ". This error is caused by an incorrect compact encoding of a type (a class, array or a primitive). The error occurred with the following type, but also could be caused by characteristics of the overall type hierarchy: " + type + ". Please report this problem and the conditions in which it occurs and include any noteworthy characteristics of the type hierarchy and architecture of the application and the libraries and frameworks it uses.");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forInstance(ResolvedJavaType type, int size) {
        LayoutEncoding.guaranteeEncoding(type, size > 3, "Instance type size must be above special values for encoding: " + size);
        int encoding = size;
        LayoutEncoding.guaranteeEncoding(type, LayoutEncoding.isInstance(encoding), "Instance type encoding must denote an instance");
        LayoutEncoding.guaranteeEncoding(type, !LayoutEncoding.isArray(encoding), "Instance type encoding must not denote an array");
        LayoutEncoding.guaranteeEncoding(type, !LayoutEncoding.isObjectArray(encoding), "Instance type encoding must not denote an object array");
        LayoutEncoding.guaranteeEncoding(type, !LayoutEncoding.isPrimitiveArray(encoding), "Instance type encoding must not denote a primitive array");
        LayoutEncoding.guaranteeEncoding(type, LayoutEncoding.getInstanceSize(encoding).equal(WordFactory.unsigned((int)size)), "Instance type encoding size must match type size");
        return encoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int forArray(ResolvedJavaType type, boolean isObject, int arrayBaseOffset, int arrayIndexShift) {
        int tag = isObject ? -2 : -1;
        int encoding = tag << 30 | arrayBaseOffset << 8 | arrayIndexShift << 0;
        LayoutEncoding.guaranteeEncoding(type, LayoutEncoding.isArray(encoding), "Array encoding must denote an array");
        LayoutEncoding.guaranteeEncoding(type, !LayoutEncoding.isInstance(encoding), "Array encoding must not denote an instance type");
        LayoutEncoding.guaranteeEncoding(type, LayoutEncoding.isObjectArray(encoding) == isObject, "Expected isObjectArray(encoding) == " + isObject);
        LayoutEncoding.guaranteeEncoding(type, LayoutEncoding.isPrimitiveArray(encoding) != isObject, "Expected isPrimitiveArray(encoding) != " + isObject);
        LayoutEncoding.guaranteeEncoding(type, LayoutEncoding.getArrayBaseOffset(encoding).equal(WordFactory.unsigned((int)arrayBaseOffset)), "Expected array base offset of " + arrayBaseOffset + ", but encoding gives " + LayoutEncoding.getArrayBaseOffset(encoding));
        LayoutEncoding.guaranteeEncoding(type, LayoutEncoding.getArrayIndexShift(encoding) == arrayIndexShift, "Expected array index shift of " + arrayIndexShift + ", but encoding gives " + LayoutEncoding.getArrayIndexShift(encoding));
        return encoding;
    }

    public static boolean isPrimitive(int encoding) {
        return encoding == 1;
    }

    public static boolean isInterface(int encoding) {
        return encoding == 2;
    }

    public static boolean isAbstract(int encoding) {
        return encoding == 3;
    }

    public static boolean isInstance(int encoding) {
        return encoding > 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getInstanceSize(int encoding) {
        return WordFactory.unsigned((int)encoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isArray(int encoding) {
        return encoding < 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isPrimitiveArray(int encoding) {
        return UnsignedMath.aboveOrEqual((int)encoding, (int)-1073741824);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isObjectArray(int encoding) {
        return encoding < -1073741824;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayBaseOffset(int encoding) {
        return WordFactory.unsigned((int)(encoding >> 8 & 0xFFF));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getArrayIndexShift(int encoding) {
        return encoding >> 0 & 0xFF;
    }

    public static int getArrayIndexScale(int encoding) {
        return 1 << LayoutEncoding.getArrayIndexShift(encoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArrayElementOffset(int encoding, int index) {
        return LayoutEncoding.getArrayBaseOffset(encoding).add(WordFactory.unsigned((int)index).shiftLeft(LayoutEncoding.getArrayIndexShift(encoding)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getArraySize(int encoding, int length) {
        int alignmentMask = LayoutEncoding.getAlignmentMask();
        return LayoutEncoding.getArrayElementOffset(encoding, length).add(alignmentMask).and(~alignmentMask);
    }

    public static UnsignedWord getSizeFromObject(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        if (LayoutEncoding.isArray(encoding)) {
            return LayoutEncoding.getArraySize(encoding, ArrayLengthNode.arrayLength((Object)obj));
        }
        return LayoutEncoding.getInstanceSize(encoding);
    }

    public static Pointer getObjectEnd(Object obj) {
        Word objStart = Word.objectToUntrackedPointer((Object)obj);
        UnsignedWord objSize = LayoutEncoding.getSizeFromObject(obj);
        return objStart.add(objSize);
    }

    public static boolean isArray(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isArray(encoding);
    }

    public static boolean isInstance(Object obj) {
        int encoding = KnownIntrinsics.readHub(obj).getLayoutEncoding();
        return LayoutEncoding.isInstance(encoding);
    }

    @Fold
    protected static int getAlignmentMask() {
        return ((ObjectLayout)ImageSingletons.lookup(ObjectLayout.class)).getAlignment() - 1;
    }
}

