// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: HeapOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class HeapOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "HeapVerificationFailureIsFatal": {
            return OptionDescriptor.create(
                /*name*/ "HeapVerificationFailureIsFatal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Failed verification of the heap (if enabled) causes termination.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "HeapVerificationFailureIsFatal",
                /*option*/ HeapOptions.HeapVerificationFailureIsFatal,
                /*deprecated*/ false);
        }
        case "ImageHeapCardMarking": {
            return OptionDescriptor.create(
                /*name*/ "ImageHeapCardMarking",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "ImageHeapCardMarking",
                /*option*/ HeapOptions.ImageHeapCardMarking,
                /*deprecated*/ false);
        }
        case "PrintGCSummary": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCSummary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after application main method returns.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintGCSummary",
                /*option*/ HeapOptions.PrintGCSummary,
                /*deprecated*/ false);
        }
        case "PrintGCTimeStamps": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimeStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print a time stamp at each collection, if +PrintGC or +VerboseGC.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintGCTimeStamps",
                /*option*/ HeapOptions.PrintGCTimeStamps,
                /*deprecated*/ false);
        }
        case "PrintGCTimes": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the time for each of the phases of each collection, if +VerboseGC.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintGCTimes",
                /*option*/ HeapOptions.PrintGCTimes,
                /*deprecated*/ false);
        }
        case "PrintHeapShape": {
            return OptionDescriptor.create(
                /*name*/ "PrintHeapShape",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the shape of the heap before and after each collection, if +VerboseGC.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintHeapShape",
                /*option*/ HeapOptions.PrintHeapShape,
                /*deprecated*/ false);
        }
        case "SoftRefLRUPolicyMSPerMB": {
            return OptionDescriptor.create(
                /*name*/ "SoftRefLRUPolicyMSPerMB",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Soft references: this number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "SoftRefLRUPolicyMSPerMB",
                /*option*/ HeapOptions.SoftRefLRUPolicyMSPerMB,
                /*deprecated*/ false);
        }
        case "TraceHeapVerification": {
            return OptionDescriptor.create(
                /*name*/ "TraceHeapVerification",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace heap verification.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "TraceHeapVerification",
                /*option*/ HeapOptions.TraceHeapVerification,
                /*deprecated*/ false);
        }
        case "TraceObjectPromotion": {
            return OptionDescriptor.create(
                /*name*/ "TraceObjectPromotion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace each object promotion (generates significant amounts of output).",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "TraceObjectPromotion",
                /*option*/ HeapOptions.TraceObjectPromotion,
                /*deprecated*/ false);
        }
        case "TraceStackVerification": {
            return OptionDescriptor.create(
                /*name*/ "TraceStackVerification",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace stack verification.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "TraceStackVerification",
                /*option*/ HeapOptions.TraceStackVerification,
                /*deprecated*/ false);
        }
        case "VerifyDirtyCardsAfterCollection": {
            return OptionDescriptor.create(
                /*name*/ "VerifyDirtyCardsAfterCollection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify dirty cards after each collection.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyDirtyCardsAfterCollection",
                /*option*/ HeapOptions.VerifyDirtyCardsAfterCollection,
                /*deprecated*/ false);
        }
        case "VerifyDirtyCardsBeforeCollection": {
            return OptionDescriptor.create(
                /*name*/ "VerifyDirtyCardsBeforeCollection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify dirty cards before each collection.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyDirtyCardsBeforeCollection",
                /*option*/ HeapOptions.VerifyDirtyCardsBeforeCollection,
                /*deprecated*/ false);
        }
        case "VerifyHeapAfterCollection": {
            return OptionDescriptor.create(
                /*name*/ "VerifyHeapAfterCollection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap after each collection.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyHeapAfterCollection",
                /*option*/ HeapOptions.VerifyHeapAfterCollection,
                /*deprecated*/ false);
        }
        case "VerifyHeapBeforeCollection": {
            return OptionDescriptor.create(
                /*name*/ "VerifyHeapBeforeCollection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap before each collection.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyHeapBeforeCollection",
                /*option*/ HeapOptions.VerifyHeapBeforeCollection,
                /*deprecated*/ false);
        }
        case "VerifyStackAfterCollection": {
            return OptionDescriptor.create(
                /*name*/ "VerifyStackAfterCollection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify stacks after each collection.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyStackAfterCollection",
                /*option*/ HeapOptions.VerifyStackAfterCollection,
                /*deprecated*/ false);
        }
        case "VerifyStackBeforeCollection": {
            return OptionDescriptor.create(
                /*name*/ "VerifyStackBeforeCollection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify stacks before each collection.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyStackBeforeCollection",
                /*option*/ HeapOptions.VerifyStackBeforeCollection,
                /*deprecated*/ false);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 16;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("HeapVerificationFailureIsFatal");
                    case 1: return get("ImageHeapCardMarking");
                    case 2: return get("PrintGCSummary");
                    case 3: return get("PrintGCTimeStamps");
                    case 4: return get("PrintGCTimes");
                    case 5: return get("PrintHeapShape");
                    case 6: return get("SoftRefLRUPolicyMSPerMB");
                    case 7: return get("TraceHeapVerification");
                    case 8: return get("TraceObjectPromotion");
                    case 9: return get("TraceStackVerification");
                    case 10: return get("VerifyDirtyCardsAfterCollection");
                    case 11: return get("VerifyDirtyCardsBeforeCollection");
                    case 12: return get("VerifyHeapAfterCollection");
                    case 13: return get("VerifyHeapBeforeCollection");
                    case 14: return get("VerifyStackAfterCollection");
                    case 15: return get("VerifyStackBeforeCollection");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
