/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.FirstObjectTable;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class HostedImageHeapChunkWriter
implements ImageHeapChunkWriter {
    private final ByteBuffer buffer;
    private final int layoutToBufferAddend;
    private final int headerSize;
    private final int topOffsetAt;
    private final int endOffsetAt;
    private final int spaceOffsetAt;
    private final int offsetToPreviousChunkAt;
    private final int offsetToNextChunkAt;
    private final int alignedChunkCardTableOffset;
    private final UnsignedWord alignedChunkCardTableSize;
    private final int alignedChunkFirstObjectTableOffset;
    private final UnsignedWord alignedChunkFirstObjectTableSize;
    private final UnsignedWord alignedChunkObjectsStartOffset;
    private final int unalignedChunkCardTableOffset;
    private final UnsignedWord unalignedChunkCardTableSize;

    HostedImageHeapChunkWriter(ByteBuffer heapBuffer, long layoutToBufferOffsetAddend) {
        this.buffer = heapBuffer;
        this.layoutToBufferAddend = NumUtil.safeToInt((long)layoutToBufferOffsetAddend);
        this.headerSize = SizeOf.get(HeapChunk.Header.class);
        this.topOffsetAt = OffsetOf.get(HeapChunk.Header.class, "TopOffset");
        this.endOffsetAt = OffsetOf.get(HeapChunk.Header.class, "EndOffset");
        this.spaceOffsetAt = OffsetOf.get(HeapChunk.Header.class, "Space");
        this.offsetToPreviousChunkAt = OffsetOf.get(HeapChunk.Header.class, "OffsetToPreviousChunk");
        this.offsetToNextChunkAt = OffsetOf.get(HeapChunk.Header.class, "OffsetToNextChunk");
        this.alignedChunkCardTableOffset = UnsignedUtils.safeToInt(AlignedHeapChunk.getCardTableStartOffset());
        this.alignedChunkCardTableSize = AlignedHeapChunk.getCardTableSize();
        this.alignedChunkFirstObjectTableOffset = UnsignedUtils.safeToInt(AlignedHeapChunk.getFirstObjectTableStartOffset());
        this.alignedChunkFirstObjectTableSize = AlignedHeapChunk.getFirstObjectTableSize();
        this.alignedChunkObjectsStartOffset = AlignedHeapChunk.getObjectsStartOffset();
        this.unalignedChunkCardTableOffset = UnsignedUtils.safeToInt(UnalignedHeapChunk.getCardTableStartOffset());
        this.unalignedChunkCardTableSize = UnalignedHeapChunk.getCardTableSize();
    }

    private int getChunkOffsetInBuffer(int chunkPosition) {
        return chunkPosition + this.layoutToBufferAddend;
    }

    @Override
    public void initializeAlignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        int chunkOffset = this.getChunkOffsetInBuffer(chunkPosition);
        this.writeHeader(chunkOffset, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
        CardTable.cleanTableInBuffer(this.buffer, chunkOffset + this.alignedChunkCardTableOffset, this.alignedChunkCardTableSize);
        FirstObjectTable.initializeTableInBuffer(this.buffer, chunkOffset + this.alignedChunkFirstObjectTableOffset, this.alignedChunkFirstObjectTableSize);
    }

    @Override
    public void initializeUnalignedChunk(int chunkPosition, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        int chunkOffset = this.getChunkOffsetInBuffer(chunkPosition);
        this.writeHeader(chunkOffset, topOffset, endOffset, offsetToPreviousChunk, offsetToNextChunk);
        CardTable.cleanTableInBuffer(this.buffer, chunkOffset + this.unalignedChunkCardTableOffset, this.unalignedChunkCardTableSize);
    }

    private void writeHeader(int chunkOffset, long topOffset, long endOffset, long offsetToPreviousChunk, long offsetToNextChunk) {
        for (int i = 0; i < this.headerSize; ++i) {
            assert (this.buffer.get(chunkOffset + i) == 0) : "Header area must be zeroed out";
        }
        this.buffer.putLong(chunkOffset + this.topOffsetAt, topOffset);
        this.buffer.putLong(chunkOffset + this.endOffsetAt, endOffset);
        HostedImageHeapChunkWriter.putObjectReference(this.buffer, chunkOffset + this.spaceOffsetAt, 0L);
        this.buffer.putLong(chunkOffset + this.offsetToPreviousChunkAt, offsetToPreviousChunk);
        this.buffer.putLong(chunkOffset + this.offsetToNextChunkAt, offsetToNextChunk);
    }

    @Override
    public void insertIntoAlignedChunkFirstObjectTable(int chunkPosition, long objectOffsetInChunk, long objectEndOffsetInChunk) {
        int chunkOffset = this.getChunkOffsetInBuffer(chunkPosition);
        assert (chunkOffset >= 0 && objectOffsetInChunk >= 0L && objectEndOffsetInChunk > objectOffsetInChunk);
        int bufferTableOffset = chunkOffset + this.alignedChunkFirstObjectTableOffset;
        UnsignedWord offsetInObjects = WordFactory.unsigned((long)objectOffsetInChunk).subtract(this.alignedChunkObjectsStartOffset);
        UnsignedWord endOffsetInObjects = WordFactory.unsigned((long)objectEndOffsetInChunk).subtract(this.alignedChunkObjectsStartOffset);
        FirstObjectTable.setTableInBufferForObject(this.buffer, bufferTableOffset, offsetInObjects, endOffsetInObjects);
    }

    static void putObjectReference(ByteBuffer buffer, int offset, long value) {
        switch (ConfigurationValues.getObjectLayout().getReferenceSize()) {
            case 4: {
                buffer.putInt(offset, NumUtil.safeToInt((long)value));
                break;
            }
            case 8: {
                buffer.putLong(offset, value);
                break;
            }
            default: {
                VMError.shouldNotReachHere("Unsupported reference size");
            }
        }
    }
}

