/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CInterfaceReadNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.VaListNextArgNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.jni.JNIJavaCallWrappers;
import com.oracle.svm.jni.access.JNINativeLinkage;
import com.oracle.svm.jni.hosted.JNIGeneratedMethod;
import com.oracle.svm.jni.hosted.JNIGraphKit;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIValue;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

public final class JNIJavaCallWrapperMethod
extends JNIGeneratedMethod {
    private static final ClassCastException cachedArgumentClassCastException = new ClassCastException("Object argument to JNI call does not match type in Java signature");
    private final NativeLibraries nativeLibs;
    private final ResolvedJavaType declaringClass;
    private final ConstantPool constantPool;
    private final Executable reflectMethod;
    private final CallVariant callVariant;
    private final boolean nonVirtual;
    private final ResolvedJavaMethod targetMethod;
    private final Signature signature;

    public JNIJavaCallWrapperMethod(Executable reflectMethod, CallVariant callVariant, boolean nonVirtual, MetaAccessProvider metaAccess, NativeLibraries nativeLibs) {
        assert (!nonVirtual || !Modifier.isStatic(reflectMethod.getModifiers()));
        this.declaringClass = metaAccess.lookupJavaType(JNIJavaCallWrappers.class);
        this.constantPool = JNIJavaCallWrappers.getConstantPool(metaAccess);
        this.reflectMethod = reflectMethod;
        this.nativeLibs = nativeLibs;
        this.callVariant = callVariant;
        this.nonVirtual = nonVirtual;
        this.targetMethod = metaAccess.lookupJavaMethod(reflectMethod);
        this.signature = this.createSignature(metaAccess);
    }

    private SimpleSignature createSignature(MetaAccessProvider metaAccess) {
        ResolvedJavaType objectHandle = metaAccess.lookupJavaType(JNIObjectHandle.class);
        ArrayList<JavaType> args = new ArrayList<JavaType>();
        args.add((JavaType)metaAccess.lookupJavaType(JNIEnvironment.class));
        args.add((JavaType)objectHandle);
        if (this.nonVirtual) {
            args.add((JavaType)objectHandle);
        }
        args.add((JavaType)metaAccess.lookupJavaType(JNIMethodId.class));
        Signature targetSignature = this.targetMethod.getSignature();
        if (this.callVariant == CallVariant.VARARGS) {
            for (JavaType targetArg : targetSignature.toParameterTypes(null)) {
                JavaKind kind = targetArg.getJavaKind();
                if (kind.isObject()) {
                    args.add((JavaType)objectHandle);
                    continue;
                }
                if (kind == JavaKind.Float) {
                    args.add((JavaType)metaAccess.lookupJavaType(JavaKind.Double.toJavaClass()));
                    continue;
                }
                args.add((JavaType)metaAccess.lookupJavaType(kind.getStackKind().toJavaClass()));
            }
        } else if (this.callVariant == CallVariant.ARRAY) {
            args.add((JavaType)metaAccess.lookupJavaType(JNIValue.class));
        } else if (this.callVariant == CallVariant.VA_LIST) {
            args.add((JavaType)metaAccess.lookupJavaType(WordBase.class));
        } else {
            throw VMError.shouldNotReachHere();
        }
        JavaType returnType = targetSignature.getReturnType(null);
        if (returnType.getJavaKind().isObject() || this.targetMethod.isConstructor()) {
            returnType = objectHandle;
        }
        return new SimpleSignature(args, returnType);
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method);
        StructuredGraph graph = kit.getGraph();
        FrameStateBuilder state = new FrameStateBuilder(null, method, graph);
        state.initializeForMethodStart(null, true, providers.getGraphBuilderPlugins());
        JavaKind vmThreadKind = metaAccess.lookupJavaType(JNIEnvironment.class).getJavaKind();
        ValueNode vmThread = kit.loadLocal(0, vmThreadKind);
        kit.append((ValueNode)CEntryPointEnterNode.enter(vmThread));
        ResolvedJavaMethod invokeMethod = providers.getMetaAccess().lookupJavaMethod(this.reflectMethod);
        Signature invokeSignature = invokeMethod.getSignature();
        List<Pair<ValueNode, ResolvedJavaType>> argsWithTypes = this.loadAndUnboxArguments(kit, providers, invokeMethod, invokeSignature);
        JavaKind returnKind = invokeSignature.getReturnKind();
        if (invokeMethod.isConstructor()) {
            assert (returnKind == JavaKind.Void);
            returnKind = JavaKind.Object;
        }
        IfNode ifNode = kit.startIf(null, 0.99);
        kit.thenPart();
        LogicConstantNode typeChecks = LogicConstantNode.tautology((Graph)kit.getGraph());
        ValueNode[] args = new ValueNode[argsWithTypes.size()];
        for (int i = 0; i < argsWithTypes.size(); ++i) {
            ValueNode value = (ValueNode)argsWithTypes.get(i).getLeft();
            ResolvedJavaType type = (ResolvedJavaType)argsWithTypes.get(i).getRight();
            if (!type.isPrimitive() && !type.isJavaLangObject()) {
                TypeReference typeRef = TypeReference.createTrusted((Assumptions)kit.getAssumptions(), (ResolvedJavaType)type);
                LogicNode instanceOf = (LogicNode)kit.unique((FloatingNode)InstanceOfNode.createAllowNull((TypeReference)typeRef, (ValueNode)value, null, null));
                typeChecks = LogicNode.and((LogicNode)typeChecks, (LogicNode)instanceOf, (double)0.99);
                FixedGuardNode guard = (FixedGuardNode)kit.append((ValueNode)new FixedGuardNode(instanceOf, DeoptimizationReason.ClassCastException, DeoptimizationAction.None, false));
                value = kit.append(PiNode.create((ValueNode)value, (Stamp)StampFactory.object((TypeReference)typeRef), (ValueNode)guard));
            }
            args[i] = value;
        }
        ifNode.setCondition((LogicNode)typeChecks);
        CallTargetNode.InvokeKind kind = invokeMethod.isStatic() ? CallTargetNode.InvokeKind.Static : (this.nonVirtual || invokeMethod.isConstructor() ? CallTargetNode.InvokeKind.Special : CallTargetNode.InvokeKind.Virtual);
        ValueNode invokeResult = JNIJavaCallWrapperMethod.createInvoke(kit, invokeMethod, kind, state, kit.bci(), args);
        if (invokeMethod.isConstructor()) {
            invokeResult = args[0];
        }
        kit.elsePart();
        ConstantNode exceptionObject = kit.createObject(cachedArgumentClassCastException);
        kit.setPendingException((ValueNode)exceptionObject);
        FloatingNode typeMismatchResult = null;
        if (returnKind != JavaKind.Void) {
            typeMismatchResult = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)returnKind.getStackKind()));
        }
        AbstractMergeNode merge = kit.endIf();
        InvokeWithExceptionNode returnValue = null;
        if (returnKind != JavaKind.Void) {
            ValueNode[] inputs = new ValueNode[]{invokeResult, typeMismatchResult};
            returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(invokeResult.stamp(NodeView.DEFAULT), merge, inputs));
            state.push(returnKind, (ValueNode)returnValue);
        }
        merge.setStateAfter(state.create(kit.bci(), (StateSplit)merge));
        if (returnKind != JavaKind.Void) {
            state.pop(returnKind);
            if (returnKind.isObject()) {
                returnValue = kit.boxObjectInLocalHandle((ValueNode)returnValue);
            }
        }
        kit.appendStateSplitProxy(state);
        CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave);
        kit.append((ValueNode)leave);
        kit.createReturn((ValueNode)returnValue, returnKind);
        return kit.finalizeGraph();
    }

    private static ValueNode createInvoke(JNIGraphKit kit, ResolvedJavaMethod invokeMethod, CallTargetNode.InvokeKind kind, FrameStateBuilder state, int bci, ValueNode ... args) {
        InvokeWithExceptionNode formerPendingException = kit.getAndClearPendingException();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(invokeMethod, kind, state, bci, args);
        kit.noExceptionPart();
        kit.setPendingException((ValueNode)formerPendingException);
        kit.exceptionPart();
        ExceptionObjectNode exceptionObject = kit.exceptionObject();
        kit.setPendingException((ValueNode)exceptionObject);
        FloatingNode exceptionValue = null;
        if (invoke.getStackKind() != JavaKind.Void) {
            exceptionValue = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)invoke.getStackKind()));
        }
        AbstractMergeNode merge = kit.endInvokeWithException();
        ValueNode returnValue = null;
        JavaKind returnKind = invokeMethod.getSignature().getReturnKind();
        if (invoke.getStackKind() != JavaKind.Void) {
            ValueNode[] inputs = new ValueNode[]{invoke, exceptionValue};
            returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(invoke.stamp(NodeView.DEFAULT), merge, inputs));
            state.push(returnKind, returnValue);
        }
        merge.setStateAfter(state.create(bci, (StateSplit)merge));
        if (invoke.getStackKind() != JavaKind.Void) {
            state.pop(returnKind);
        }
        return returnValue;
    }

    private List<Pair<ValueNode, ResolvedJavaType>> loadAndUnboxArguments(JNIGraphKit kit, HostedProviders providers, ResolvedJavaMethod invokeMethod, Signature invokeSignature) {
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        ArrayList<Pair<ValueNode, ResolvedJavaType>> args = new ArrayList<Pair<ValueNode, ResolvedJavaType>>();
        int javaIndex = 0;
        javaIndex += metaAccess.lookupJavaType(JNIEnvironment.class).getJavaKind().getSlotCount();
        if (!invokeMethod.isStatic()) {
            InvokeWithExceptionNode receiver;
            JavaKind kind = metaAccess.lookupJavaType(JNIObjectHandle.class).getJavaKind();
            ValueNode handle = kit.loadLocal(javaIndex, kind);
            InvokeWithExceptionNode unboxed = kit.unboxHandle(handle);
            ResolvedJavaType receiverClass = invokeMethod.getDeclaringClass();
            if (invokeMethod.isConstructor()) {
                Constant hub = providers.getConstantReflection().asObjectHub(receiverClass);
                ConstantNode hubNode = kit.createConstant(hub, JavaKind.Object);
                kit.startIf((LogicNode)kit.unique((FloatingNode)new ObjectEqualsNode((ValueNode)unboxed, (ValueNode)hubNode)), 0.99);
                kit.thenPart();
                ValueNode created = kit.append((ValueNode)new NewInstanceNode(receiverClass, true));
                AbstractMergeNode merge = kit.endIf();
                receiver = kit.unique((FloatingNode)new ValuePhiNode(StampFactory.object(), merge, new ValueNode[]{created, unboxed}));
                merge.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)merge));
            } else {
                receiver = unboxed;
            }
            args.add(Pair.create((Object)receiver, (Object)receiverClass));
        }
        javaIndex += metaAccess.lookupJavaType(JNIObjectHandle.class).getJavaKind().getSlotCount();
        if (this.nonVirtual) {
            javaIndex += metaAccess.lookupJavaType(JNIObjectHandle.class).getJavaKind().getSlotCount();
        }
        javaIndex += metaAccess.lookupJavaType(JNIMethodId.class).getJavaKind().getSlotCount();
        int count = invokeSignature.getParameterCount(false);
        if (OS.getCurrent() == OS.DARWIN && Platform.includedIn(Platform.AARCH64.class) && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST) || OS.getCurrent() == OS.WINDOWS && this.callVariant == CallVariant.VA_LIST || this.callVariant == CallVariant.ARRAY) {
            ResolvedJavaType elementType = metaAccess.lookupJavaType(JNIValue.class);
            int elementSize = SizeOf.get(JNIValue.class);
            ValueNode array = this.callVariant == CallVariant.VARARGS ? kit.append((ValueNode)new ReadCallerStackPointerNode()) : kit.loadLocal(javaIndex, elementType.getJavaKind());
            for (int i = 0; i < count; ++i) {
                JavaKind readKind;
                ResolvedJavaType type = (ResolvedJavaType)invokeSignature.getParameterType(i, null);
                JavaKind kind = type.getJavaKind();
                JavaKind javaKind = readKind = this.callVariant == CallVariant.ARRAY ? kind : kind.getStackKind();
                if (readKind == JavaKind.Float && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST)) {
                    readKind = JavaKind.Double;
                }
                StructFieldInfo fieldInfo = this.getJNIValueOffsetOf(elementType, readKind);
                int offset = i * elementSize + fieldInfo.getOffsetInfo().getProperty();
                ConstantNode offsetConstant = kit.createConstant((Constant)JavaConstant.forInt((int)offset), providers.getWordTypes().getWordKind());
                OffsetAddressNode address = (OffsetAddressNode)kit.unique((FloatingNode)new OffsetAddressNode(array, (ValueNode)offsetConstant));
                LocationIdentity locationIdentity = fieldInfo.getLocationIdentity();
                if (locationIdentity == null) {
                    locationIdentity = LocationIdentity.any();
                }
                Stamp readStamp = JNIJavaCallWrapperMethod.getNarrowStamp(providers, readKind);
                ValueNode value = kit.append((ValueNode)new CInterfaceReadNode((AddressNode)address, locationIdentity, readStamp, OnHeapMemoryAccess.BarrierType.NONE, "args[" + i + "]"));
                if (kind == JavaKind.Float && (this.callVariant == CallVariant.VARARGS || this.callVariant == CallVariant.VA_LIST)) {
                    value = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.D2F, value));
                } else if (kind.isObject()) {
                    value = kit.unboxHandle(value);
                } else if (kind == JavaKind.Boolean) {
                    value = JNIJavaCallWrapperMethod.convertToBoolean(kit, value);
                } else if (kind != kind.getStackKind() && this.callVariant == CallVariant.ARRAY) {
                    value = JNIJavaCallWrapperMethod.maskSubWordValue(kit, value, kind);
                }
                args.add((Pair<ValueNode, ResolvedJavaType>)Pair.create((Object)value, (Object)type));
            }
        } else if (this.callVariant == CallVariant.VARARGS) {
            for (int i = 0; i < count; ++i) {
                ResolvedJavaType type = (ResolvedJavaType)invokeSignature.getParameterType(i, null);
                JavaKind kind = type.getJavaKind();
                JavaKind loadKind = kind;
                if (loadKind == JavaKind.Float) {
                    loadKind = JavaKind.Double;
                }
                ValueNode value = kit.loadLocal(javaIndex, loadKind);
                if (kind == JavaKind.Float) {
                    value = kit.unique((FloatingNode)new FloatConvertNode(FloatConvert.D2F, value));
                } else if (kind.isObject()) {
                    value = kit.unboxHandle(value);
                } else if (kind == JavaKind.Boolean) {
                    value = JNIJavaCallWrapperMethod.convertToBoolean(kit, value);
                }
                args.add((Pair<ValueNode, ResolvedJavaType>)Pair.create((Object)value, (Object)type));
                javaIndex += loadKind.getSlotCount();
            }
        } else if (this.callVariant == CallVariant.VA_LIST) {
            ValueNode valist = kit.loadLocal(javaIndex, metaAccess.lookupJavaType(WordBase.class).getJavaKind());
            for (int i = 0; i < count; ++i) {
                ResolvedJavaType type = (ResolvedJavaType)invokeSignature.getParameterType(i, null);
                JavaKind kind = type.getJavaKind();
                JavaKind loadKind = kind.getStackKind();
                if (loadKind.isObject()) {
                    loadKind = providers.getWordTypes().getWordKind();
                }
                ValueNode value = kit.append((ValueNode)new VaListNextArgNode(loadKind, valist));
                if (kind.isObject()) {
                    value = kit.unboxHandle(value);
                } else if (kind == JavaKind.Boolean) {
                    value = JNIJavaCallWrapperMethod.convertToBoolean(kit, value);
                }
                args.add((Pair<ValueNode, ResolvedJavaType>)Pair.create((Object)value, (Object)type));
            }
        } else {
            throw VMError.unsupportedFeature("Call variant: " + (Object)((Object)this.callVariant));
        }
        return args;
    }

    private static ValueNode convertToBoolean(JNIGraphKit kit, ValueNode value) {
        ValueNode maskedValue = JNIJavaCallWrapperMethod.maskSubWordValue(kit, value, JavaKind.Boolean);
        LogicNode isZero = IntegerEqualsNode.create((ValueNode)maskedValue, (ValueNode)ConstantNode.forInt((int)0), (NodeView)NodeView.DEFAULT);
        return kit.append(ConditionalNode.create((LogicNode)isZero, (ValueNode)ConstantNode.forBoolean((boolean)false), (ValueNode)ConstantNode.forBoolean((boolean)true), (NodeView)NodeView.DEFAULT));
    }

    private static ValueNode maskSubWordValue(JNIGraphKit kit, ValueNode value, JavaKind kind) {
        assert (kind != kind.getStackKind());
        ValueNode narrow = kit.append(NarrowNode.create((ValueNode)value, (int)(kind.getByteCount() * 8), (NodeView)NodeView.DEFAULT));
        if (kind.isUnsigned()) {
            return kit.append(ZeroExtendNode.create((ValueNode)narrow, (int)32, (NodeView)NodeView.DEFAULT));
        }
        return kit.append(SignExtendNode.create((ValueNode)narrow, (int)32, (NodeView)NodeView.DEFAULT));
    }

    private static Stamp getNarrowStamp(HostedProviders providers, JavaKind kind) {
        if (kind != kind.getStackKind()) {
            return StampFactory.forInteger((int)(kind.getByteCount() * 8));
        }
        if (kind.isObject()) {
            ResolvedJavaType objectHandle = providers.getMetaAccess().lookupJavaType(JNIObjectHandle.class);
            return providers.getWordTypes().getWordStamp(objectHandle);
        }
        return StampFactory.forKind((JavaKind)kind);
    }

    private StructFieldInfo getJNIValueOffsetOf(ResolvedJavaType jniValueType, JavaKind kind) {
        String name = String.valueOf(kind.isObject() ? (char)'l' : Character.toLowerCase(kind.getTypeChar()));
        StructInfo structInfo = (StructInfo)this.nativeLibs.findElementInfo((AnnotatedElement)jniValueType);
        for (ElementInfo elementInfo : structInfo.getChildren()) {
            StructFieldInfo fieldInfo;
            if (!(elementInfo instanceof StructFieldInfo) || !name.equals((fieldInfo = (StructFieldInfo)elementInfo).getName())) continue;
            return fieldInfo;
        }
        throw VMError.shouldNotReachHere();
    }

    public Signature getSignature() {
        return this.signature;
    }

    public String getName() {
        String full = this.targetMethod.getDeclaringClass().getName() + "." + this.targetMethod.getName() + this.targetMethod.getSignature().toMethodDescriptor();
        return "jniInvoke_" + this.callVariant.name() + (this.nonVirtual ? "_Nonvirtual" : "") + ":" + JNINativeLinkage.mangle(full);
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.declaringClass;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    static {
        cachedArgumentClassCastException.setStackTrace(new StackTraceElement[0]);
    }

    public static enum CallVariant {
        VARARGS,
        ARRAY,
        VA_LIST;

    }
}

