/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.EmptyMemoryAcessProvider;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantReflectionProvider
extends SharedConstantReflectionProvider {
    private final AnalysisUniverse universe;
    private final ConstantReflectionProvider originalConstantReflection;
    private final ClassInitializationSupport classInitializationSupport;

    public AnalysisConstantReflectionProvider(AnalysisUniverse universe, ConstantReflectionProvider originalConstantReflection, ClassInitializationSupport classInitializationSupport) {
        this.universe = universe;
        this.originalConstantReflection = originalConstantReflection;
        this.classInitializationSupport = classInitializationSupport;
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return EmptyMemoryAcessProvider.SINGLETON;
    }

    @Override
    public final JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        if (field instanceof AnalysisField) {
            return this.readValue((AnalysisField)field, receiver);
        }
        return super.readFieldValue(field, receiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JavaConstant readValue(AnalysisField field, JavaConstant receiver) {
        JavaConstant value;
        if (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)field.getDeclaringClass())) {
            if (!field.isStatic()) throw VMError.shouldNotReachHere("Cannot read instance field of a class that is initialized at run time: " + field.format("%H.%n"));
            value = AnalysisConstantReflectionProvider.readUninitializedStaticValue(field);
            return this.interceptValue(field, value);
        } else {
            value = this.universe.lookup(ReadableJavaField.readFieldValue(this.originalConstantReflection, field.wrapped, this.universe.toHosted(receiver)));
        }
        return this.interceptValue(field, value);
    }

    private static JavaConstant readUninitializedStaticValue(AnalysisField field) {
        boolean canHaveConstantValueAttribute;
        JavaKind kind = field.getJavaKind();
        boolean bl = canHaveConstantValueAttribute = kind.isPrimitive() || field.getType().toJavaName(true).equals("java.lang.String");
        if (!canHaveConstantValueAttribute || !field.isFinal()) {
            return JavaConstant.defaultForKind((JavaKind)kind);
        }
        assert (Modifier.isStatic(field.getModifiers()));
        Class base = field.getDeclaringClass().getJavaClass();
        long offset = field.wrapped.getOffset();
        Field reflectionField = field.getJavaField();
        if (reflectionField != null) {
            assert (kind == JavaKind.fromJavaClass(reflectionField.getType()));
            Object reflectionFieldBase = GraalUnsafeAccess.getUnsafe().staticFieldBase(reflectionField);
            long reflectionFieldOffset = GraalUnsafeAccess.getUnsafe().staticFieldOffset(reflectionField);
            AnalysisError.guarantee((reflectionFieldBase == base && reflectionFieldOffset == offset ? 1 : 0) != 0);
        }
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((boolean)GraalUnsafeAccess.getUnsafe().getBoolean(base, offset));
            }
            case Byte: {
                return JavaConstant.forByte((byte)GraalUnsafeAccess.getUnsafe().getByte(base, offset));
            }
            case Char: {
                return JavaConstant.forChar((char)GraalUnsafeAccess.getUnsafe().getChar(base, offset));
            }
            case Short: {
                return JavaConstant.forShort((short)GraalUnsafeAccess.getUnsafe().getShort(base, offset));
            }
            case Int: {
                return JavaConstant.forInt((int)GraalUnsafeAccess.getUnsafe().getInt(base, offset));
            }
            case Long: {
                return JavaConstant.forLong((long)GraalUnsafeAccess.getUnsafe().getLong(base, offset));
            }
            case Float: {
                return JavaConstant.forFloat((float)GraalUnsafeAccess.getUnsafe().getFloat(base, offset));
            }
            case Double: {
                return JavaConstant.forDouble((double)GraalUnsafeAccess.getUnsafe().getDouble(base, offset));
            }
            case Object: {
                Object value = GraalUnsafeAccess.getUnsafe().getObject(base, offset);
                assert (value == null || value instanceof String) : "String is currently the only specified object type for the ConstantValue class file attribute";
                return SubstrateObjectConstant.forObject(value);
            }
        }
        throw VMError.shouldNotReachHere();
    }

    public JavaConstant interceptValue(AnalysisField field, JavaConstant value) {
        JavaConstant result = value;
        if (result != null) {
            result = AnalysisConstantReflectionProvider.filterInjectedAccessor(field, result);
            result = this.replaceObject(result);
            result = AnalysisConstantReflectionProvider.interceptAssertionStatus(field, result);
            result = this.interceptWordType(field, result);
        }
        return result;
    }

    private static JavaConstant filterInjectedAccessor(AnalysisField field, JavaConstant value) {
        if (field.getAnnotation(InjectAccessors.class) != null) {
            assert (!field.isAccessed());
            return JavaConstant.defaultForKind((JavaKind)value.getJavaKind());
        }
        return value;
    }

    private JavaConstant replaceObject(JavaConstant value) {
        Object oldObject;
        Object newObject;
        if (value == JavaConstant.NULL_POINTER) {
            return JavaConstant.NULL_POINTER;
        }
        if (value.getJavaKind() == JavaKind.Object && (newObject = this.universe.replaceObject(oldObject = this.universe.getSnippetReflection().asObject(Object.class, value))) != oldObject) {
            return this.universe.getSnippetReflection().forObject(newObject);
        }
        return value;
    }

    private static JavaConstant interceptAssertionStatus(AnalysisField field, JavaConstant value) {
        if (field.isStatic() && field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            Class clazz = field.getDeclaringClass().getJavaClass();
            boolean assertionsEnabled = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(clazz);
            return JavaConstant.forBoolean((!assertionsEnabled ? 1 : 0) != 0);
        }
        return value;
    }

    private JavaConstant interceptWordType(AnalysisField field, JavaConstant value) {
        if (value.getJavaKind() == JavaKind.Object) {
            Object originalObject = this.universe.getSnippetReflection().asObject(Object.class, value);
            if (this.universe.hostVM().isRelocatedPointer(originalObject)) {
                return value;
            }
            if (originalObject instanceof WordBase) {
                return JavaConstant.forIntegerKind((JavaKind)this.universe.getWordKind(), (long)((WordBase)originalObject).rawValue());
            }
            if (originalObject == null && field.getType().isWordType()) {
                return JavaConstant.forIntegerKind((JavaKind)this.universe.getWordKind(), (long)0L);
            }
        }
        return value;
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        if (constant instanceof SubstrateObjectConstant) {
            Object obj = SubstrateObjectConstant.asObject(constant);
            if (obj instanceof DynamicHub) {
                return this.getHostVM().lookupType((DynamicHub)obj);
            }
            if (obj instanceof Class) {
                throw VMError.shouldNotReachHere("Must not have java.lang.Class object: " + obj);
            }
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        DynamicHub dynamicHub = this.getHostVM().dynamicHub(type);
        AnalysisConstantReflectionProvider.registerAsReachable(this.getHostVM(), dynamicHub);
        assert (dynamicHub != null) : type.toClassName() + " has a null dynamicHub.";
        return SubstrateObjectConstant.forObject(dynamicHub);
    }

    protected static void registerAsReachable(SVMHost hostVM, DynamicHub dynamicHub) {
        assert (dynamicHub != null);
        AnalysisType valueType = hostVM.lookupType(dynamicHub);
        valueType.registerAsReachable();
    }

    private SVMHost getHostVM() {
        return (SVMHost)this.universe.hostVM();
    }
}

