/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public final class CGlobalDataInfo {
    public static final String CGLOBALDATA_BASE_SYMBOL_NAME = "__svm_cglobaldata_base";
    public static final CGlobalData<Pointer> CGLOBALDATA_RUNTIME_BASE_ADDRESS = CGlobalDataFactory.forSymbol("__svm_cglobaldata_base");
    private final CGlobalDataImpl<?> data;
    private final boolean isSymbolReference;
    private int offset = -1;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private byte[] bytes;

    public CGlobalDataInfo(CGlobalDataImpl<?> data) {
        assert (data != null);
        this.data = data;
        boolean bl = this.isSymbolReference = data.bytesSupplier == null && data.sizeSupplier == null;
        assert (!this.isSymbolReference || data.symbolName != null);
    }

    public CGlobalDataImpl<?> getData() {
        return this.data;
    }

    public void assign(int offset, byte[] bytes) {
        assert (this.offset == -1 && this.bytes == null) : "already initialized";
        assert (offset >= 0);
        this.offset = offset;
        this.bytes = bytes;
    }

    public int getOffset() {
        VMError.guarantee(this.offset >= 0, "Offset has not been initialized");
        return this.offset;
    }

    public void makeGlobalSymbol() {
        VMError.guarantee(!this.isSymbolReference && this.data.symbolName != null, "Cannot change the local/global status of a symbol reference");
    }

    public boolean isSymbolReference() {
        return this.isSymbolReference;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return this.data.toString();
    }
}

