/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import org.graalvm.nativeimage.c.function.CodePointer;

public class CodeInfoQueryResult {
    public static final int NO_EXCEPTION_OFFSET = 0;
    public static final int NO_REFERENCE_MAP = -1;
    public static final int EMPTY_REFERENCE_MAP = 0;
    protected static final FrameInfoQueryResult NO_FRAME_INFO = null;
    protected CodePointer ip;
    protected long encodedFrameSize;
    protected long exceptionOffset;
    protected long referenceMapIndex;
    protected FrameInfoQueryResult frameInfo;

    public CodePointer getIP() {
        return this.ip;
    }

    public long getEncodedFrameSize() {
        return this.encodedFrameSize;
    }

    public long getTotalFrameSize() {
        return CodeInfoQueryResult.getTotalFrameSize(this.encodedFrameSize);
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    public static long getTotalFrameSize(long encodedFrameSize) {
        return CodeInfoDecoder.decodeTotalFrameSize(encodedFrameSize);
    }

    public boolean isEntryPoint() {
        return CodeInfoQueryResult.isEntryPoint(this.encodedFrameSize);
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    public static boolean isEntryPoint(long encodedFrameSize) {
        return CodeInfoDecoder.decodeIsEntryPoint(encodedFrameSize);
    }

    public boolean hasCalleeSavedRegisters() {
        return CodeInfoQueryResult.hasCalleeSavedRegisters(this.encodedFrameSize);
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    public static boolean hasCalleeSavedRegisters(long encodedFrameSize) {
        return CodeInfoDecoder.decodeHasCalleeSavedRegisters(encodedFrameSize);
    }

    public long getExceptionOffset() {
        return this.exceptionOffset;
    }

    public long getReferenceMapIndex() {
        return this.referenceMapIndex;
    }

    public FrameInfoQueryResult getFrameInfo() {
        return this.frameInfo;
    }
}

