/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.log.Log;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.VMRuntime;
import sun.misc.Signal;
import sun.misc.SignalHandler;

class DumpHeapReport
implements SignalHandler {
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    DumpHeapReport() {
    }

    static void install() {
        Signal.handle(new Signal("USR1"), new DumpHeapReport());
    }

    @Override
    public void handle(Signal arg0) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateFormat.setTimeZone(UTC_TIMEZONE);
        String heapDumpFileName = "svm-heapdump-" + ProcessProperties.getProcessID() + "-" + dateFormat.format(new Date()) + ".hprof";
        try {
            VMRuntime.dumpHeap((String)heapDumpFileName, (boolean)true);
        }
        catch (IOException e) {
            Log.log().string("IOException during dumpHeap: ").string(e.getMessage()).newline();
        }
    }
}

