/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.image;

public class ImageHeapLayoutInfo {
    private final long writableOffset;
    private final long writableSize;
    private final long readOnlyRelocatableOffset;
    private final long readOnlyRelocatableSize;
    private final long imageHeapSize;

    public ImageHeapLayoutInfo(long writableOffset, long writableSize, long readOnlyRelocatableOffset, long readOnlyRelocatableSize, long imageHeapSize) {
        this.writableOffset = writableOffset;
        this.writableSize = writableSize;
        this.readOnlyRelocatableOffset = readOnlyRelocatableOffset;
        this.readOnlyRelocatableSize = readOnlyRelocatableSize;
        this.imageHeapSize = imageHeapSize;
    }

    public long getWritableOffset() {
        return this.writableOffset;
    }

    public long getWritableSize() {
        return this.writableSize;
    }

    public long getReadOnlyRelocatableOffset() {
        return this.readOnlyRelocatableOffset;
    }

    public long getReadOnlyRelocatableSize() {
        return this.readOnlyRelocatableSize;
    }

    public boolean isReadOnlyRelocatable(int offset) {
        return (long)offset >= this.readOnlyRelocatableOffset && (long)offset < this.readOnlyRelocatableOffset + this.readOnlyRelocatableSize;
    }

    public long getImageHeapSize() {
        return this.imageHeapSize;
    }
}

