/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class PosixVirtualMemoryProvider
implements VirtualMemoryProvider {
    protected static final int NO_FD = -1;
    protected static final int NO_FD_OFFSET = 0;
    private static final CGlobalData<WordPointer> CACHED_PAGE_SIZE = CGlobalDataFactory.createWord();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getPageSize() {
        Word value = (Word)CACHED_PAGE_SIZE.get().read();
        if (value.equal((Word)WordFactory.zero())) {
            long queried = Unistd.NoTransitions.sysconf(Unistd._SC_PAGE_SIZE());
            value = (Word)WordFactory.unsigned((long)queried);
            CACHED_PAGE_SIZE.get().write((WordBase)value);
        }
        return value;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    protected static int accessAsProt(int access) {
        int prot = 0;
        if ((access & 1) != 0) {
            prot |= Mman.PROT_READ();
        }
        if ((access & 2) != 0) {
            prot |= Mman.PROT_WRITE();
        }
        if ((access & 4) != 0) {
            prot |= Mman.PROT_EXEC();
        }
        return prot;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getGranularity() {
        return PosixVirtualMemoryProvider.getPageSize();
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer reserve(UnsignedWord nbytes, UnsignedWord alignment) {
        Pointer mappingEnd;
        Pointer clippedEnd;
        UnsignedWord granularity = this.getGranularity();
        boolean customAlignment = !UnsignedUtils.isAMultiple(granularity, alignment);
        UnsignedWord mappingSize = nbytes;
        if (customAlignment) {
            mappingSize = mappingSize.add(alignment);
        }
        mappingSize = UnsignedUtils.roundUp(mappingSize, granularity);
        Pointer mappingBegin = Mman.NoTransitions.mmap(WordFactory.nullPointer(), mappingSize, Mman.PROT_NONE(), Mman.MAP_ANON() | Mman.MAP_PRIVATE() | Mman.MAP_NORESERVE(), -1, 0L);
        if (mappingBegin.equal((ComparableWord)Mman.MAP_FAILED())) {
            return (Pointer)WordFactory.nullPointer();
        }
        if (!customAlignment) {
            return mappingBegin;
        }
        Pointer begin = PointerUtils.roundUp((PointerBase)mappingBegin, alignment);
        Pointer clippedBegin = begin.subtract((UnsignedWord)mappingBegin);
        if (clippedBegin.aboveOrEqual(granularity)) {
            Mman.NoTransitions.munmap((PointerBase)mappingBegin, UnsignedUtils.roundDown((UnsignedWord)clippedBegin, granularity));
        }
        if ((clippedEnd = (mappingEnd = mappingBegin.add(mappingSize)).subtract((UnsignedWord)begin.add(nbytes))).aboveOrEqual(granularity)) {
            UnsignedWord rounded = UnsignedUtils.roundDown((UnsignedWord)clippedEnd, granularity);
            Mman.NoTransitions.munmap((PointerBase)mappingEnd.subtract(rounded), rounded);
        }
        return begin;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer mapFile(PointerBase start, UnsignedWord nbytes, WordBase fileHandle, UnsignedWord offset, int access) {
        int flags = Mman.MAP_PRIVATE();
        if (start.isNonNull()) {
            flags |= Mman.MAP_FIXED();
        }
        int fd = (int)fileHandle.rawValue();
        Pointer result = Mman.NoTransitions.mmap(start, nbytes, PosixVirtualMemoryProvider.accessAsProt(access), flags, fd, offset.rawValue());
        return result.notEqual((ComparableWord)Mman.MAP_FAILED()) ? result : (Pointer)WordFactory.nullPointer();
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer commit(PointerBase start, UnsignedWord nbytes, int access) {
        Pointer result;
        int flags = Mman.MAP_ANON() | Mman.MAP_PRIVATE();
        if (start.isNonNull()) {
            flags |= Mman.MAP_FIXED();
        }
        return (result = Mman.NoTransitions.mmap(start, nbytes, PosixVirtualMemoryProvider.accessAsProt(access), flags, -1, 0L)).notEqual((ComparableWord)Mman.MAP_FAILED()) ? result : (Pointer)WordFactory.nullPointer();
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int protect(PointerBase start, UnsignedWord nbytes, int access) {
        return Mman.NoTransitions.mprotect(start, nbytes, PosixVirtualMemoryProvider.accessAsProt(access));
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int uncommit(PointerBase start, UnsignedWord nbytes) {
        Pointer result = Mman.NoTransitions.mmap(start, nbytes, Mman.PROT_NONE(), Mman.MAP_ANON() | Mman.MAP_PRIVATE() | Mman.MAP_NORESERVE(), -1, 0L);
        return result.notEqual((ComparableWord)Mman.MAP_FAILED()) ? 0 : -1;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int free(PointerBase start, UnsignedWord nbytes) {
        UnsignedWord granularity = this.getGranularity();
        Pointer mappingBegin = PointerUtils.roundDown(start, granularity);
        UnsignedWord mappingSize = UnsignedUtils.roundUp(nbytes, granularity);
        return Mman.NoTransitions.munmap((PointerBase)mappingBegin, mappingSize);
    }
}

