/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.ClassLoaderQuery;
import com.oracle.svm.core.RuntimeAssertionsOptionTransformer;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class RuntimeAssertionsSupport {
    public static final char ENABLE_PREFIX = '+';
    public static final char DISABLE_PREFIX = '-';
    public static final String PACKAGE_SUFFIX = "...";
    public static final String PREFIX_CHECK_MSG = "RuntimeAssertions value starts with `+` or `-`";
    public static final String EMPTY_OPTION_VALUE_MSG = "Empty RuntimeAssertions option value";
    private final Map<String, Boolean> packageAssertionStatus;
    private final Map<String, Boolean> classAssertionStatus;
    private final boolean defaultAssertionStatus;
    private final boolean systemAssertionStatus;

    @Fold
    public static RuntimeAssertionsSupport singleton() {
        return (RuntimeAssertionsSupport)ImageSingletons.lookup(RuntimeAssertionsSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected RuntimeAssertionsSupport() {
        String[] runtimeAssertionsOptions = Options.RuntimeAssertions.getValue();
        this.packageAssertionStatus = new HashMap<String, Boolean>();
        this.classAssertionStatus = new HashMap<String, Boolean>();
        boolean tmpDefaultAssertionStatus = false;
        for (String option : runtimeAssertionsOptions) {
            boolean enable;
            VMError.guarantee(!option.isEmpty(), EMPTY_OPTION_VALUE_MSG);
            char prefix = option.charAt(0);
            if (prefix == '+') {
                enable = true;
            } else if (prefix == '-') {
                enable = false;
            } else {
                throw VMError.shouldNotReachHere(PREFIX_CHECK_MSG);
            }
            String classOrPackage = option.substring(1);
            boolean isPackage = classOrPackage.endsWith(PACKAGE_SUFFIX);
            if (isPackage) {
                String packageStr = classOrPackage.substring(0, classOrPackage.length() - PACKAGE_SUFFIX.length());
                this.packageAssertionStatus.put(packageStr, enable);
                continue;
            }
            if (classOrPackage.isEmpty()) {
                tmpDefaultAssertionStatus = enable;
                continue;
            }
            this.classAssertionStatus.put(classOrPackage, enable);
        }
        this.defaultAssertionStatus = tmpDefaultAssertionStatus;
        this.systemAssertionStatus = Options.RuntimeSystemAssertions.getValue();
    }

    private boolean desiredAssertionStatusImpl(String name, boolean fallback) {
        String className = name;
        Boolean result = this.classAssertionStatus.get(className);
        if (result != null) {
            return result;
        }
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex < 0 && (result = this.packageAssertionStatus.get("")) != null) {
            return result;
        }
        while (dotIndex > 0) {
            result = this.packageAssertionStatus.get(className = className.substring(0, dotIndex));
            if (result != null) {
                return result;
            }
            dotIndex = className.lastIndexOf(46, dotIndex - 1);
        }
        return fallback;
    }

    private boolean desiredAssertionStatusImpl(String name, ClassLoader classLoader) {
        boolean isNativeImageClassLoader = ((ClassLoaderQuery)ImageSingletons.lookup(ClassLoaderQuery.class)).isNativeImageClassLoader(classLoader);
        return this.desiredAssertionStatusImpl(name, isNativeImageClassLoader ? this.defaultAssertionStatus : this.systemAssertionStatus);
    }

    public boolean desiredAssertionStatus(Class<?> clazz) {
        return this.desiredAssertionStatusImpl(clazz.getName(), clazz.getClassLoader());
    }

    public static class Options {
        private static final char VALUE_SEPARATOR = ':';
        @APIOption.List(value={@APIOption(name={"-ea", "-enableassertions"}, valueSeparator=58, valueTransformer={RuntimeAssertionsOptionTransformer.Enable.class}, defaultValue={""}, customHelp="also -ea[:[packagename]...|:classname] or -enableassertions[:[packagename]...|:classname]. Enable assertions with specified granularity."), @APIOption(name={"-da", "-disableassertions"}, valueSeparator=58, valueTransformer={RuntimeAssertionsOptionTransformer.Disable.class}, defaultValue={""}, customHelp="also -da[:[packagename]...|:classname] or -disableassertions[:[packagename]...|:classname]. Disable assertions with specified granularity.")})
        @Option(help={"Enable or disable Java assert statements at run time"})
        public static final HostedOptionKey<String[]> RuntimeAssertions = new HostedOptionKey<String[]>(new String[0]);
        @APIOption.List(value={@APIOption(name={"-esa", "-enablesystemassertions"}, customHelp="also -enablesystemassertions. Enables assertions in all system classes."), @APIOption(name={"-dsa", "-disablesystemassertions"}, kind=APIOption.APIOptionKind.Negated, customHelp="also -disablesystemassertions. Disables assertions in all system classes.")})
        @Option(help={"Enable or disable Java system assertions at run time"})
        public static final HostedOptionKey<Boolean> RuntimeSystemAssertions = new HostedOptionKey<Boolean>(false);
    }
}

