/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CCallStubMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.c.function.CFunction;

public final class CFunctionCallStubMethod
extends CCallStubMethod {
    private final CGlobalDataInfo linkage;

    CFunctionCallStubMethod(ResolvedJavaMethod original, CGlobalDataInfo linkage, int newThreadStatus) {
        super(original, newThreadStatus);
        this.linkage = linkage;
    }

    @Override
    protected String getCorrespondingAnnotationName() {
        return this.getAnnotationClass().getSimpleName();
    }

    private Class<?> getAnnotationClass() {
        if (this.original.getAnnotation(CFunction.class) != null) {
            return CFunction.class;
        }
        throw VMError.shouldNotReachHere("Method is not annotated with @" + CFunction.class.getSimpleName());
    }

    @Override
    public boolean allowRuntimeCompilation() {
        boolean needsTransition = VMThreads.StatusSupport.isValidStatus(this.newThreadStatus);
        return !needsTransition;
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        assert (purpose != GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION || this.allowRuntimeCompilation());
        return super.buildGraph(debug, method, providers, purpose);
    }

    @Override
    protected ValueNode createTargetAddressNode(HostedGraphKit kit, HostedProviders providers, List<ValueNode> arguments) {
        return kit.unique(new CGlobalDataLoadAddressNode(this.linkage));
    }

    @Override
    protected JavaType[] getParameterTypesForLoad(ResolvedJavaMethod method) {
        return method.toParameterTypes();
    }

    @Override
    protected Signature adaptSignatureAndConvertArguments(HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, ResolvedJavaMethod method, JavaType returnType, JavaType[] paramTypes, List<ValueNode> arguments) {
        JavaType[] adaptedParamTypes = paramTypes;
        if (method.hasReceiver()) {
            arguments.remove(0);
            adaptedParamTypes = Arrays.copyOfRange(adaptedParamTypes, 1, adaptedParamTypes.length);
        }
        return super.adaptSignatureAndConvertArguments(providers, nativeLibraries, kit, method, returnType, adaptedParamTypes, arguments);
    }
}

