/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ReadOnlyHugeMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyPrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyReferenceMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyRelocatableMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.WritableHugeMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritablePrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritableReferenceMemoryWalkerAccess;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ImageHeapWalker {
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_PRIMITIVE_WALKER = new ReadOnlyPrimitiveMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_REFERENCE_WALKER = new ReadOnlyReferenceMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_RELOCATABLE_WALKER = new ReadOnlyRelocatableMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_PRIMITIVE_WALKER = new WritablePrimitiveMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_REFERENCE_WALKER = new WritableReferenceMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_HUGE_WALKER = new WritableHugeMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_HUGE_WALKER = new ReadOnlyHugeMemoryWalkerAccess();

    private ImageHeapWalker() {
    }

    public static boolean walkRegions(ImageHeapInfo heapInfo, MemoryWalker.ImageHeapRegionVisitor visitor) {
        return visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_PRIMITIVE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_REFERENCE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_RELOCATABLE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_PRIMITIVE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_REFERENCE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_HUGE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_HUGE_WALKER);
    }

    public static boolean walkImageHeapObjects(ImageHeapInfo heapInfo, ObjectVisitor visitor) {
        return ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyPrimitiveObject, heapInfo.lastReadOnlyPrimitiveObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyReferenceObject, heapInfo.lastReadOnlyReferenceObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyRelocatableObject, heapInfo.lastReadOnlyRelocatableObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritablePrimitiveObject, heapInfo.lastWritablePrimitiveObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritableReferenceObject, heapInfo.lastWritableReferenceObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritableHugeObject, heapInfo.lastWritableHugeObject, visitor, false) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyHugeObject, heapInfo.lastReadOnlyHugeObject, visitor, false);
    }

    static boolean walkPartition(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks) {
        return ImageHeapWalker.walkPartitionInline(firstObject, lastObject, visitor, alignedChunks, false);
    }

    @AlwaysInline(value="GC performance")
    static boolean walkPartitionInline(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks) {
        return ImageHeapWalker.walkPartitionInline(firstObject, lastObject, visitor, alignedChunks, true);
    }

    @AlwaysInline(value="GC performance")
    private static boolean walkPartitionInline(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks, boolean inlineObjectVisit) {
        if (firstObject == null || lastObject == null) {
            assert (firstObject == null && lastObject == null);
            return true;
        }
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        HeapChunk.Header currentChunk = (HeapChunk.Header)WordFactory.nullPointer();
        if (HeapImpl.usesImageHeapChunks()) {
            Pointer base = (Pointer)WordFactory.zero();
            if (!CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment()) {
                base = (Pointer)Isolates.getHeapBase(CurrentIsolate.getIsolate());
            }
            Pointer offset = current.subtract((UnsignedWord)base);
            UnsignedWord chunkOffset = alignedChunks ? UnsignedUtils.roundDown((UnsignedWord)offset, HeapPolicy.getAlignedHeapChunkAlignment()) : offset.subtract(UnalignedHeapChunk.getObjectStartOffset());
            currentChunk = (HeapChunk.Header)chunkOffset.add((UnsignedWord)base);
        }
        do {
            Pointer chunkTop;
            Word limit = lastPointer;
            if (HeapImpl.usesImageHeapChunks() && lastPointer.aboveThan((UnsignedWord)(chunkTop = HeapChunk.getTopPointer(currentChunk)))) {
                limit = chunkTop.subtract(1);
            }
            while (current.belowOrEqual((UnsignedWord)limit)) {
                Object currentObject = KnownIntrinsics.convertUnknownValue(current.toObject(), Object.class);
                if (inlineObjectVisit ? !visitor.visitObjectInline(currentObject) : !visitor.visitObject(currentObject)) {
                    return false;
                }
                current = LayoutEncoding.getObjectEnd(current.toObject());
            }
            if (!HeapImpl.usesImageHeapChunks() || !current.belowThan((UnsignedWord)lastPointer)) continue;
            currentChunk = HeapChunk.getNext(currentChunk);
            Pointer pointer = current = alignedChunks ? AlignedHeapChunk.getObjectsStart((AlignedHeapChunk.AlignedHeader)currentChunk) : UnalignedHeapChunk.getObjectStart((UnalignedHeapChunk.UnalignedHeader)currentChunk);
        } while (current.belowOrEqual((UnsignedWord)lastPointer));
        return true;
    }

    static void logPartitionBoundaries(Log log, ImageHeapInfo imageHeapInfo) {
        log.string("ReadOnly Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstReadOnlyPrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastReadOnlyPrimitiveObject)).newline();
        log.string("ReadOnly References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstReadOnlyReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastReadOnlyReferenceObject)).newline();
        log.string("ReadOnly Relocatables: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstReadOnlyRelocatableObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastReadOnlyRelocatableObject)).newline();
        log.string("Writable Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstWritablePrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastWritablePrimitiveObject)).newline();
        log.string("Writable References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstWritableReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastWritableReferenceObject)).newline();
        log.string("Writable Huge: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstWritableHugeObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastWritableHugeObject)).newline();
        log.string("ReadOnly Huge: ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.firstReadOnlyHugeObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)imageHeapInfo.lastReadOnlyHugeObject));
    }
}

