/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class ProxyConfigurationParser
extends ConfigurationParser {
    private final Consumer<String[]> interfaceListConsumer;

    public ProxyConfigurationParser(Consumer<String[]> interfaceListConsumer, boolean strictConfiguration) {
        super(strictConfiguration);
        this.interfaceListConsumer = interfaceListConsumer;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        this.parseTopLevelArray(ProxyConfigurationParser.asList(json, "first level of document must be an array of interface lists"));
    }

    private void parseTopLevelArray(List<Object> proxyConfiguration) {
        boolean foundInterfaceLists = false;
        boolean foundProxyConfigurationObjects = false;
        for (Object proxyConfigurationObject : proxyConfiguration) {
            if (proxyConfigurationObject instanceof List) {
                foundInterfaceLists = true;
                this.parseInterfaceList(ProxyConfigurationParser.asList(proxyConfigurationObject, "<shouldn't reach here>"));
            } else if (proxyConfigurationObject instanceof Map) {
                foundProxyConfigurationObjects = true;
                this.parseInterfaceListPropertyFormat(ProxyConfigurationParser.asMap(proxyConfigurationObject, "<shouldn't reach here>"));
            } else {
                throw new JSONParserException("second level must be composed of either interface lists or proxy configuration objects");
            }
            if (!foundInterfaceLists || !foundProxyConfigurationObjects) continue;
            throw new JSONParserException("second level can only be populated of either interface lists or proxy configuration objects, but these cannot be mixed");
        }
    }

    private void parseInterfaceList(List<?> data) {
        String[] interfaces = new String[data.size()];
        int i = 0;
        for (Object value : data) {
            interfaces[i] = ProxyConfigurationParser.asString(value);
            ++i;
        }
        try {
            this.interfaceListConsumer.accept(interfaces);
        }
        catch (Exception e) {
            throw new JSONParserException(e.toString());
        }
    }

    private void parseInterfaceListPropertyFormat(Map<String, Object> proxyConfigObject) {
        this.checkAttributes(proxyConfigObject, "proxy descriptor object", Collections.singleton("interfaces"));
        this.parseInterfaceList(ProxyConfigurationParser.asList(proxyConfigObject.get("interfaces"), "\"interfaces\" must be an array of fully qualified interface names"));
    }
}

