/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.methodhandles.MethodHandleUtils;
import com.oracle.svm.methodhandles.MethodHandlesSupported;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MemberName;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MethodHandleNatives_CallSiteContext;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Field;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;

@TargetClass(className="java.lang.invoke.MethodHandleNatives", onlyWith={MethodHandlesSupported.class})
final class Target_java_lang_invoke_MethodHandleNatives {
    Target_java_lang_invoke_MethodHandleNatives() {
    }

    @Substitute
    private static void init(Target_java_lang_invoke_MemberName self, Object ref) {
        throw VMError.unsupportedFeature("MethodHandleNatives.init()");
    }

    @Substitute
    private static void expand(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.expand()");
    }

    @Delete
    private static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, Target_java_lang_invoke_MemberName[] var6);

    @Substitute
    private static long objectFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (!self.isField() || self.isStatic()) {
            throw new InternalError("non-static field required");
        }
        try {
            return GraalUnsafeAccess.getUnsafe().objectFieldOffset(self.getDeclaringClass().getDeclaredField(self.name));
        }
        catch (NoSuchFieldException e) {
            throw new InternalError(e);
        }
    }

    @Substitute
    private static long staticFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("static field required");
        }
        return 0L;
    }

    @Substitute
    private static Object staticFieldBase(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null) {
            throw new InternalError("unresolved field");
        }
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("static field required");
        }
        return SubstrateUtil.cast(self.reflectAccess, Target_java_lang_reflect_Field.class).acquireFieldAccessor(false);
    }

    @Substitute
    private static Object getMemberVMInfo(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.getMemberVMInfo()");
    }

    @Delete
    private static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    @Delete
    private static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    @Delete
    private static native void registerNatives();

    @Delete
    private static native int getNamedCon(int var0, Object[] var1);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName var0, Class<?> var1) throws LinkageError, ClassNotFoundException;

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native int getConstant(int var0);

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private static Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName self, Class<?> caller, boolean speculativeResolve) throws LinkageError, ClassNotFoundException {
        AccessibleObject member;
        block14: {
            if (self.reflectAccess != null) {
                return self;
            }
            Class<?> declaringClass = self.getDeclaringClass();
            if (declaringClass == null) {
                return null;
            }
            member = null;
            try {
                if (self.isMethod()) {
                    try {
                        member = declaringClass.getDeclaredMethod(self.name, ((MethodType)self.type).parameterArray());
                    }
                    catch (NoSuchMethodException e) {
                        if (MethodHandleUtils.isPolymorphicSignatureMethod(declaringClass, self.name)) {
                            try {
                                member = declaringClass.getDeclaredMethod(self.name, Object[].class);
                            }
                            catch (NoSuchMethodException ex) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                    self.flags |= SubstrateUtil.cast(member, Method.class).getModifiers();
                    break block14;
                }
                if (self.isConstructor()) {
                    member = declaringClass.getDeclaredConstructor(((MethodType)self.type).parameterArray());
                    self.flags |= SubstrateUtil.cast(member, Constructor.class).getModifiers();
                } else if (self.isField()) {
                    member = declaringClass.getDeclaredField(self.name);
                    self.flags |= SubstrateUtil.cast(member, Field.class).getModifiers();
                }
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                if (speculativeResolve) {
                    return null;
                }
                throw new InternalError(e);
            }
        }
        self.reflectAccess = member;
        return self;
    }

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native void copyOutBootstrapArguments(Class<?> var0, int[] var1, int var2, int var3, Object[] var4, int var5, boolean var6, Object var7);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native void clearCallSiteContext(Target_java_lang_invoke_MethodHandleNatives_CallSiteContext var0);

    @AnnotateOriginal
    static native boolean refKindIsMethod(byte var0);

    @AnnotateOriginal
    static native String refKindName(byte var0);
}

