/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import jdk.vm.ci.meta.JavaKind;

public class HostedArrayClass
extends HostedClass {
    private final HostedType componentType;
    private final HostedType baseType;
    private final int arrayDepth;

    public HostedArrayClass(HostedUniverse universe, AnalysisType wrapped, JavaKind kind, JavaKind storageKind, HostedClass superClass, HostedInterface[] interfaces, HostedType componentType) {
        super(universe, wrapped, kind, storageKind, superClass, interfaces, true);
        this.componentType = componentType;
        HostedType cur = this;
        int depth = 0;
        while (((HostedType)cur).getComponentType() != null) {
            cur = ((HostedType)cur).getComponentType();
            ++depth;
        }
        this.baseType = cur;
        this.arrayDepth = depth;
        assert (componentType.arrayType == null);
        componentType.arrayType = this;
    }

    public boolean isInstanceClass() {
        assert (!this.wrapped.isInstanceClass());
        return false;
    }

    public boolean isArray() {
        assert (this.wrapped.isArray());
        return true;
    }

    @Override
    public final HostedType getComponentType() {
        return this.componentType;
    }

    @Override
    public HostedType getBaseType() {
        return this.baseType;
    }

    @Override
    public int getArrayDimension() {
        return this.arrayDepth;
    }

    @Override
    public HostedField[] getInstanceFields(boolean includeSuperclasses) {
        return new HostedField[0];
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    @Override
    int compareToEqualClass(HostedType other) {
        assert (this.getClass().equals(other.getClass()));
        return this.getComponentType().compareTo(other.getComponentType());
    }
}

