/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK11To14;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.LocalizationFeature;
import com.oracle.svm.core.jdk.LocalizationSupport;
import com.oracle.svm.core.util.VMError;
import java.util.Locale;
import java.util.spi.LocaleServiceProvider;
import org.graalvm.nativeimage.ImageSingletons;
import sun.util.locale.provider.LocaleServiceProviderPool;

@Substitute
@TargetClass(value=LocaleServiceProviderPool.class)
final class Target_sun_util_locale_provider_LocaleServiceProviderPool {
    private final LocaleServiceProvider cachedProvider;

    Target_sun_util_locale_provider_LocaleServiceProviderPool(LocaleServiceProvider cachedProvider) {
        this.cachedProvider = cachedProvider;
    }

    @Substitute
    private static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> providerClass) {
        LocaleServiceProviderPool result = (LocaleServiceProviderPool)((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).providerPools.get(providerClass);
        if (result == null) {
            throw VMError.unsupportedFeature("LocaleServiceProviderPool.getPool " + providerClass.getName());
        }
        return result;
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private boolean hasProviders() {
        return false;
    }

    @KeepOriginal
    private native <P extends LocaleServiceProvider, S> S getLocalizedObject(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> var1, Locale var2, Object ... var3);

    @KeepOriginal
    private native <P extends LocaleServiceProvider, S> S getLocalizedObject(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> var1, Locale var2, String var3, Object ... var4);

    @Substitute
    private <P extends LocaleServiceProvider, S> S getLocalizedObjectImpl(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> getter, Locale locale, boolean isObjectProvider, String key, Object ... params) {
        if (locale == null) {
            throw new NullPointerException();
        }
        return getter.getObject(this.cachedProvider, locale, key, params);
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK11OrLater.class})
    public native <P extends LocaleServiceProvider, S> S getLocalizedObject(LocaleServiceProviderPool.LocalizedObjectGetter<P, S> var1, Locale var2, Boolean var3, String var4, Object ... var5);

    @KeepOriginal
    @TargetElement(onlyWith={JDK11To14.class})
    static native void config(Class<? extends Object> var0, String var1);

    @Substitute
    private static Locale[] getAllAvailableLocales() {
        return new Locale[]{((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).imageLocale};
    }

    @Substitute
    private Locale[] getAvailableLocales() {
        return new Locale[]{((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).imageLocale};
    }
}

