/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.meta.SharedMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class RuntimeConfiguration {
    private final Providers providers;
    private final SnippetReflectionProvider snippetReflection;
    private final EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend> backends;
    private final Iterable<DebugHandlersFactory> debugHandlersFactories;
    private final WordTypes wordTypes;
    private int vtableBaseOffset;
    private int vtableEntrySize;
    private int instanceOfBitsOrTypeIDSlotsOffset;
    private int componentHubOffset;
    private int javaFrameAnchorLastSPOffset;
    private int javaFrameAnchorLastIPOffset;
    private int vmThreadStatusOffset;
    private int imageCodeInfoCodeStartOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeConfiguration(Providers providers, SnippetReflectionProvider snippetReflection, EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend> backends, WordTypes wordTypes) {
        this.providers = providers;
        this.snippetReflection = snippetReflection;
        this.backends = backends;
        this.debugHandlersFactories = Collections.singletonList(new GraalDebugHandlersFactory(snippetReflection));
        this.wordTypes = wordTypes;
        for (SubstrateBackend backend : backends.values()) {
            backend.setRuntimeConfiguration(this);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setLazyState(int vtableBaseOffset, int vtableEntrySize, int instanceofBitsOrTypeIDSlotsOffset, int componentHubOffset, int javaFrameAnchorLastSPOffset, int javaFrameAnchorLastIPOffset, int vmThreadStatusOffset, int imageCodeInfoCodeStartOffset) {
        assert (!this.isFullyInitialized());
        this.vtableBaseOffset = vtableBaseOffset;
        this.vtableEntrySize = vtableEntrySize;
        this.instanceOfBitsOrTypeIDSlotsOffset = instanceofBitsOrTypeIDSlotsOffset;
        this.componentHubOffset = componentHubOffset;
        this.javaFrameAnchorLastSPOffset = javaFrameAnchorLastSPOffset;
        this.javaFrameAnchorLastIPOffset = javaFrameAnchorLastIPOffset;
        this.vmThreadStatusOffset = vmThreadStatusOffset;
        this.imageCodeInfoCodeStartOffset = imageCodeInfoCodeStartOffset;
        assert (this.isFullyInitialized());
    }

    public boolean isFullyInitialized() {
        return this.vtableEntrySize > 0;
    }

    public Iterable<DebugHandlersFactory> getDebugHandlersFactories() {
        return this.debugHandlersFactories;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public Collection<SubstrateBackend> getBackends() {
        return this.backends.values();
    }

    public SubstrateBackend lookupBackend(ResolvedJavaMethod method) {
        if (((SharedMethod)method).isEntryPoint()) {
            return this.backends.get((Object)SubstrateRegisterConfig.ConfigKind.NATIVE_TO_JAVA);
        }
        return this.backends.get((Object)SubstrateRegisterConfig.ConfigKind.NORMAL);
    }

    public SubstrateBackend getBackendForNormalMethod() {
        return this.backends.get((Object)SubstrateRegisterConfig.ConfigKind.NORMAL);
    }

    public int getVTableOffset(int vTableIndex) {
        assert (this.isFullyInitialized());
        return this.vtableBaseOffset + vTableIndex * this.vtableEntrySize;
    }

    public int getInstanceOfBitOffset(int bitIndex) {
        assert (this.isFullyInitialized());
        assert (SubstrateOptions.UseLegacyTypeCheck.getValue().booleanValue());
        return this.instanceOfBitsOrTypeIDSlotsOffset + bitIndex / 8;
    }

    public int getInstanceOfTypeIDSlotsOffset() {
        assert (this.isFullyInitialized());
        assert (!SubstrateOptions.UseLegacyTypeCheck.getValue().booleanValue());
        return this.instanceOfBitsOrTypeIDSlotsOffset;
    }

    public int getComponentHubOffset() {
        assert (this.isFullyInitialized());
        return this.componentHubOffset;
    }

    public int getJavaFrameAnchorLastSPOffset() {
        assert (this.isFullyInitialized());
        return this.javaFrameAnchorLastSPOffset;
    }

    public int getJavaFrameAnchorLastIPOffset() {
        assert (this.isFullyInitialized());
        return this.javaFrameAnchorLastIPOffset;
    }

    public int getVMThreadStatusOffset() {
        assert (SubstrateOptions.MultiThreaded.getValue().booleanValue() && this.vmThreadStatusOffset != -1);
        return this.vmThreadStatusOffset;
    }

    public int getImageCodeInfoCodeStartOffset() {
        assert (this.isFullyInitialized());
        return this.imageCodeInfoCodeStartOffset;
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.snippetReflection;
    }

    public WordTypes getWordTypes() {
        return this.wordTypes;
    }
}

