/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.FirstObjectTable;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import java.nio.ByteBuffer;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class CardTable {
    private static final int BYTES_COVERED_BY_ENTRY = 512;
    private static final int ENTRY_SIZE_BYTES = 1;
    private static final int DIRTY_ENTRY = 0;
    private static final int CLEAN_ENTRY = 1;
    public static final LocationIdentity CARD_REMEMBERED_SET_LOCATION = NamedLocationIdentity.mutable((String)"CardRememberedSet");

    private CardTable() {
    }

    static void dirtyEntryAtIndex(Pointer table, UnsignedWord index) {
        table.writeByte((WordBase)CardTable.indexToTableOffset(index), (byte)0, CARD_REMEMBERED_SET_LOCATION);
    }

    static boolean isDirtyEntryAtIndex(Pointer table, UnsignedWord index) {
        assert (VMOperation.isGCInProgress()) : "Should only be called from the collector.";
        return CardTable.isDirtyEntryAtIndexUnchecked(table, index);
    }

    static boolean isDirtyEntryAtIndexUnchecked(Pointer table, UnsignedWord index) {
        return CardTable.isDirtyEntry(CardTable.readEntryAtIndexUnchecked(table, index));
    }

    static boolean containsReferenceToYoungSpace(Object obj) {
        ReferenceToYoungObjectVisitor referenceToYoungObjectVisitor = CardTable.getReferenceToYoungObjectVisitor();
        return referenceToYoungObjectVisitor.containsReferenceToYoungObject(obj);
    }

    static Pointer cleanTableToPointer(Pointer tableStart, Pointer tableLimit) {
        Pointer tableOffset = tableLimit.subtract((UnsignedWord)tableStart);
        UnsignedWord indexLimit = CardTable.tableOffsetToIndex((UnsignedWord)tableOffset);
        return CardTable.cleanTableToIndex(tableStart, indexLimit);
    }

    static Pointer cleanTableToIndex(Pointer table, UnsignedWord indexLimit) {
        UnsignedWord index = WordFactory.unsigned((int)0);
        while (index.belowThan(indexLimit)) {
            CardTable.cleanEntryAtIndex(table, index);
            index = index.add(1);
        }
        return table;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static void cleanTableInBuffer(ByteBuffer buffer, int bufferTableOffset, UnsignedWord tableSize) {
        CardTable.cleanTableToIndex(new HostedByteBufferPointer(buffer, bufferTableOffset), tableSize);
    }

    static void cleanEntryAtIndex(Pointer table, UnsignedWord index) {
        table.writeByte((WordBase)CardTable.indexToTableOffset(index), (byte)1, CARD_REMEMBERED_SET_LOCATION);
    }

    static int getBytesCoveredByEntry() {
        return 512;
    }

    static UnsignedWord tableSizeForMemorySize(UnsignedWord memorySize) {
        UnsignedWord maxIndex = CardTable.indexLimitForMemorySize(memorySize);
        return maxIndex.multiply(1);
    }

    static UnsignedWord memoryOffsetToIndex(UnsignedWord offset) {
        return offset.unsignedDivide(512);
    }

    static Pointer indexToMemoryPointer(Pointer memoryStart, UnsignedWord index) {
        UnsignedWord offset = index.multiply(512);
        return memoryStart.add(offset);
    }

    static UnsignedWord indexLimitForMemorySize(UnsignedWord memorySize) {
        UnsignedWord roundedMemory = UnsignedUtils.roundUp(memorySize, WordFactory.unsigned((int)512));
        return CardTable.memoryOffsetToIndex(roundedMemory);
    }

    static boolean verify(Pointer ctStart, Pointer fotStart, Pointer objectsStart, Pointer objectsLimit) {
        Log trace = Log.noopLog().string("[CardTable.verify: ");
        trace.string("  ctStart: ").hex((WordBase)ctStart).string("  fotStart: ").hex((WordBase)fotStart).string("  objectsStart: ").hex((WordBase)objectsStart).string("  objectsLimit: ").hex((WordBase)objectsLimit).newline();
        if (!CardTable.verifyCleanCards(ctStart, fotStart, objectsStart, objectsLimit)) {
            Log verifyLog = Log.log().string("[CardTableTable.verify:");
            verifyLog.string("  fails verifyCleanCards").string("]").newline();
            return false;
        }
        if (!CardTable.verifyDirtyCards(ctStart, objectsStart, objectsLimit)) {
            Log verifyLog = Log.log().string("[CardTable.verify:");
            verifyLog.string("  fails verifyCleanCards").string("]").newline();
            return false;
        }
        trace.string("]").newline();
        return true;
    }

    private static int readEntryAtIndexUnchecked(Pointer table, UnsignedWord index) {
        return table.readByte((WordBase)CardTable.indexToTableOffset(index));
    }

    private static int readEntryAtIndex(Pointer table, UnsignedWord index) {
        int result = CardTable.readEntryAtIndexUnchecked(table, index);
        assert (result == 0 || result == 1) : "Table entry out of range.";
        return result;
    }

    private static boolean isDirtyEntry(int entry) {
        return entry == 0;
    }

    private static boolean isCleanEntry(int entry) {
        return entry == 1;
    }

    private static boolean isCleanEntryAtIndex(Pointer table, UnsignedWord index) {
        return CardTable.isCleanEntry(CardTable.readEntryAtIndex(table, index));
    }

    private static UnsignedWord tableOffsetToIndex(UnsignedWord offset) {
        return offset.unsignedDivide(1);
    }

    private static UnsignedWord indexToTableOffset(UnsignedWord index) {
        return index.multiply(1);
    }

    private static UnsignedWord memoryPointerToIndex(Pointer memoryStart, Pointer memoryLimit, Pointer memoryPointer) {
        assert (memoryStart.belowOrEqual((UnsignedWord)memoryLimit)) : "memoryStart.belowOrEqual(memoryLimit)";
        assert (memoryStart.belowOrEqual((UnsignedWord)memoryPointer)) : "memoryStart.belowOrEqual(memoryPointer)";
        assert (memoryPointer.belowOrEqual((UnsignedWord)memoryLimit)) : "memoryPointer.belowOrEqual(memoryLimit)";
        Pointer offset = memoryPointer.subtract((UnsignedWord)memoryStart);
        return CardTable.memoryOffsetToIndex((UnsignedWord)offset);
    }

    private static boolean visitCards(Pointer table, UnsignedWord indexLimit, Visitor visitor) {
        UnsignedWord index = WordFactory.unsigned((int)0);
        while (index.belowThan(indexLimit)) {
            int entry = CardTable.readEntryAtIndex(table, index);
            if (!visitor.visitEntry(table, index, entry)) {
                return false;
            }
            index = index.add(1);
        }
        return true;
    }

    private static ReferenceToYoungObjectVisitor getReferenceToYoungObjectVisitor() {
        return HeapImpl.getHeapImpl().getHeapVerifier().getReferenceToYoungObjectVisitor();
    }

    private static boolean verifyCleanCards(Pointer ctStart, Pointer fotStart, Pointer objectsStart, Pointer objectsLimit) {
        Log trace = Log.noopLog().string("[CardTable.verifyCleanCards:");
        trace.string("  ctStart: ").hex((WordBase)ctStart).string("  fotStart: ").hex((WordBase)fotStart).string("  objectsStart: ").hex((WordBase)objectsStart).string("  objectsLimit: ").hex((WordBase)objectsLimit);
        UnsignedWord indexLimit = FirstObjectTable.getTableSizeForMemoryRange(objectsStart, objectsLimit);
        UnsignedWord index = (UnsignedWord)WordFactory.zero();
        while (index.belowThan(indexLimit)) {
            trace.newline().string("  index: ").unsigned((WordBase)index);
            if (FirstObjectTable.isUninitializedIndex(fotStart, index)) {
                Log failure = Log.log().string("[CardTable.verifyCleanCards: ");
                failure.string("  reached uninitialized first object table entry").string("]").newline();
                return false;
            }
            boolean isClean = CardTable.isCleanEntryAtIndex(ctStart, index);
            if (isClean) {
                Pointer impreciseStart = FirstObjectTable.getImpreciseFirstObjectPointer(fotStart, objectsStart, objectsLimit, index);
                Pointer cardLimit = CardTable.indexToMemoryPointer(objectsStart, index.add(1));
                Pointer walkLimit = PointerUtils.min(cardLimit, objectsLimit);
                trace.string("  impreciseStart: ").hex((WordBase)impreciseStart).string("  cardLimit: ").hex((WordBase)cardLimit).string("  walkLimit: ").hex((WordBase)walkLimit);
                Pointer ptr = impreciseStart;
                while (ptr.belowThan((UnsignedWord)walkLimit)) {
                    boolean containsYoung;
                    trace.newline().string("  ").string("  ptr: ").hex((WordBase)ptr);
                    Object obj = ptr.toObject();
                    trace.string("  obj: ").object(obj);
                    if (LayoutEncoding.isArray(obj)) {
                        trace.string("  length: ").signed(ArrayLengthNode.arrayLength((Object)obj));
                    }
                    if (containsYoung = CardTable.getReferenceToYoungObjectVisitor().containsReferenceToYoungObject(obj)) {
                        boolean witnessForDebugging = true;
                        Log witness = Log.log();
                        witness.string("[CardTable.verifyCleanCards:").string("  objectsStart: ").hex((WordBase)objectsStart).string("  objectsLimit: ").hex((WordBase)objectsLimit).string("  indexLimit: ").unsigned((WordBase)indexLimit).newline();
                        witness.string("  index: ").unsigned((WordBase)index);
                        Pointer cardStart = CardTable.indexToMemoryPointer(objectsStart, index);
                        witness.string("  cardStart: ").hex((WordBase)cardStart).string("  cardLimit: ").hex((WordBase)cardLimit).string("  walkLimit: ").hex((WordBase)walkLimit).string("  fotEntry: ");
                        FirstObjectTable.TestingBackDoor.indexToLog(fotStart, witness, index);
                        witness.string("  isClean: ").bool(isClean).newline();
                        Pointer crossingOntoPointer = FirstObjectTable.getPreciseFirstObjectPointer(fotStart, objectsStart, objectsLimit, index);
                        Object crossingOntoObject = crossingOntoPointer.toObject();
                        witness.string("  crossingOntoObject: ").object(crossingOntoObject).string("  end: ").hex((WordBase)LayoutEncoding.getObjectEnd(crossingOntoObject));
                        if (LayoutEncoding.isArray(crossingOntoObject)) {
                            witness.string("  array length: ").signed(ArrayLengthNode.arrayLength((Object)crossingOntoObject));
                        }
                        witness.string("  impreciseStart: ").hex((WordBase)impreciseStart).newline();
                        witness.string("  obj: ").object(obj).string("  end: ").hex((WordBase)LayoutEncoding.getObjectEnd(obj));
                        if (LayoutEncoding.isArray(obj)) {
                            witness.string("  array length: ").signed(ArrayLengthNode.arrayLength((Object)obj));
                        }
                        witness.newline();
                        AlignedHeapChunk.AlignedHeader objChunk = AlignedHeapChunk.getEnclosingChunk(obj);
                        witness.string("  objChunk: ").hex((WordBase)objChunk).string("  objChunk space: ").string(HeapChunk.getSpace(objChunk).getName()).string("  contains young: ").bool(containsYoung).newline();
                        CardTable.getReferenceToYoungObjectVisitor().witnessReferenceToYoungObject(obj);
                        witness.string(" returns false for index: ").unsigned((WordBase)index).string("]").newline();
                        return false;
                    }
                    ptr = LayoutEncoding.getObjectEnd(obj);
                }
            }
            index = index.add(1);
        }
        trace.string("]").newline();
        return true;
    }

    private static boolean verifyDirtyCards(Pointer ctStart, Pointer objectsStart, Pointer objectsLimit) {
        Log trace = Log.noopLog().string("[CardTable.verifyDirtyCards:");
        trace.string("  ctStart: ").hex((WordBase)ctStart).string("  objectsStart: ").hex((WordBase)objectsStart).string("  objectsLimit: ").hex((WordBase)objectsLimit);
        Pointer ptr = objectsStart;
        while (ptr.belowThan((UnsignedWord)objectsLimit)) {
            UnsignedWord index;
            boolean isClean;
            Object obj = ptr.toObject();
            boolean containsYoung = CardTable.containsReferenceToYoungSpace(obj);
            if (containsYoung && (isClean = CardTable.isCleanEntryAtIndex(ctStart, index = CardTable.memoryPointerToIndex(objectsStart, objectsLimit, ptr)))) {
                boolean witnessForDebugging = true;
                Log witness = Log.log();
                witness.string("[CardTable.verifyDirtyCards:").string("  objectsStart: ").hex((WordBase)objectsStart).string("  objectsLimit: ").hex((WordBase)objectsLimit).newline();
                witness.string("  obj: ").object(obj).string("  contains young: ").bool(containsYoung).string("  but index: ").unsigned((WordBase)index).string(" is clean.").string(" returns false").string("]").newline();
                return false;
            }
            ptr = LayoutEncoding.getObjectEnd(obj);
        }
        trace.string("]").newline();
        return true;
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static void dirtyEntryAtIndex(Pointer table, UnsignedWord index) {
            CardTable.dirtyEntryAtIndex(table, index);
        }

        public static boolean visitCards(Pointer table, UnsignedWord indexLimit, Visitor visitor) {
            return CardTable.visitCards(table, indexLimit, visitor);
        }

        public static int readEntryAtIndex(Pointer table, UnsignedWord index) {
            return CardTable.readEntryAtIndex(table, index);
        }

        public static boolean isCleanEntryAtIndex(Pointer table, UnsignedWord index) {
            return CardTable.isCleanEntryAtIndex(table, index);
        }

        public static boolean isDirtyEntryAtIndex(Pointer table, UnsignedWord index) {
            return CardTable.isDirtyEntryAtIndexUnchecked(table, index);
        }

        public static UnsignedWord getTableSize(UnsignedWord memorySize) {
            return CardTable.tableSizeForMemorySize(memorySize);
        }

        public static Pointer cleanTableToIndex(Pointer table, UnsignedWord maxIndex) {
            return CardTable.cleanTableToIndex(table, maxIndex);
        }
    }

    public static interface Visitor {
        public boolean visitEntry(Pointer var1, UnsignedWord var2, int var3);
    }

    static class ReferenceToYoungObjectReferenceVisitor
    implements ObjectReferenceVisitor {
        private boolean found;
        private boolean witnessForDebugging;

        ReferenceToYoungObjectReferenceVisitor() {
        }

        public void reset() {
            this.found = false;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            Log paranoidLog;
            Log trace = Log.noopLog().string("[ReferenceToYoungObjectReferenceVisitor.visitObjectReference: ").string("  objRef: ").hex((WordBase)objRef).newline();
            Word p = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            trace.string("  p: ").hex((WordBase)p);
            if (p.isNull()) {
                trace.string("  null pointer returns true]").newline();
                return true;
            }
            boolean paranoid = true;
            UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer((Pointer)p);
            if (ObjectHeaderImpl.isProducedHeapChunkZapped(header) || ObjectHeaderImpl.isConsumedHeapChunkZapped(header)) {
                paranoidLog = Log.log().string("[CardTable.ReferenceToYoungObjectReferenceVisitor.visitObjectReference:");
                paranoidLog.string("  objRef: ").hex((WordBase)objRef).string("  p: ").hex((WordBase)p).string("  points to zapped header: ").hex((WordBase)header).string("]").newline();
            }
            if (ObjectHeaderImpl.isForwardedHeader(header)) {
                paranoidLog = Log.log().string("[CardTable.ReferenceToYoungObjectReferenceVisitor.visitObjectReference:");
                paranoidLog.string("  objRef: ").hex((WordBase)objRef).string("  p: ").hex((WordBase)p).string("  points to header: ").hex((WordBase)header).string("]").newline();
            }
            Object obj = p.toObject();
            trace.string("  obj: ").object(obj).string(" ").object(obj);
            if (HeapImpl.getHeapImpl().isInImageHeap(obj)) {
                trace.string("  non-heap allocated returns true]").newline();
                return true;
            }
            HeapChunk.Header<?> objChunk = HeapChunk.getEnclosingHeapChunk(obj);
            trace.string("  objChunk: ").hex((WordBase)objChunk);
            if (objChunk.isNull()) {
                Log failure = Log.log().string("[CardTable.ReferenceToYoungObjectReferenceVisitor.visitObjectReference:");
                failure.string("  objRef: ").hex((WordBase)objRef).string("  has no enclosing chunk").string("]").newline();
                return false;
            }
            Space chunkSpace = HeapChunk.getSpace(objChunk);
            trace.string("  chunkSpace: ").object(chunkSpace).string(" ").string(chunkSpace.getName());
            if (chunkSpace.isYoungSpace()) {
                this.found = true;
                if (this.witnessForDebugging) {
                    Log witness = Log.log().string("[ReferenceToYoungObjectReferenceVisitor.visitObjectReference:").string("  witness").newline();
                    witness.string("  objRef: ").hex((WordBase)objRef).string("  p: ").hex((WordBase)p).string("  obj: ").object(obj).newline();
                    witness.string("  chunk: ").hex((WordBase)objChunk).string("  chunk.getSpace(): ").string(HeapChunk.getSpace(objChunk).getName()).string("  found: true  returns false").string("]").newline();
                }
                return true;
            }
            trace.string("  returns true]").newline();
            return true;
        }

        private void setWitnessForDebugging(boolean value) {
            this.witnessForDebugging = value;
        }
    }

    static class ReferenceToYoungObjectVisitor
    implements ObjectVisitor {
        private final ReferenceToYoungObjectReferenceVisitor visitor;

        ReferenceToYoungObjectVisitor(ReferenceToYoungObjectReferenceVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public boolean visitObject(Object obj) {
            Log trace = HeapVerifier.getTraceLog().string("[ReferenceToYoungObjectVisitor.visitObject:").string("  obj: ").object(obj).newline();
            this.visitor.reset();
            trace.string("  calling walkObject").newline();
            if (!InteriorObjRefWalker.walkObject(obj, this.visitor)) {
                Log witness = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog();
                witness.string("[[ReferenceToYoungObjectVisitor.visitObject:").string("  obj: ").object(obj).string("  fails InteriorObjRefWalker.walkObject").string("]").newline();
                return false;
            }
            trace.string("  visitor.getFound(): ").bool(this.visitor.found).string("  returns true").string("]").newline();
            return true;
        }

        private boolean containsReferenceToYoungObject(Object obj) {
            if (!this.visitObject(obj)) {
                Log witness = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog();
                witness.string("[[ReferenceToYoungObjectVisitor.containsReferenceToYoungObject:").string("  obj: ").object(obj).string("  fails visitObject").string("]").newline();
            }
            return this.visitor.found;
        }

        private boolean witnessReferenceToYoungObject(Object obj) {
            this.visitor.setWitnessForDebugging(true);
            this.visitObject(obj);
            this.visitor.setWitnessForDebugging(false);
            return this.visitor.found;
        }
    }
}

