/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.hub.AnnotationTypeSupport;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class AnnotationTypeFeature
implements Feature {
    private EconomicSet<Object> repeatableAnnotationClasses = EconomicSet.create();
    private EconomicSet<AnnotatedElement> visitedElements = EconomicSet.create();

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(AnnotationTypeSupport.class, (Object)new AnnotationTypeSupport());
        ((FeatureImpl.AfterRegistrationAccessImpl)access).getImageClassLoader().allAnnotations().stream().map(a -> a.getAnnotation(Repeatable.class)).filter(Objects::nonNull).map(Repeatable::value).forEach(arg_0 -> this.repeatableAnnotationClasses.add(arg_0));
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        AnalysisUniverse universe = accessImpl.getUniverse();
        universe.getTypes().stream().filter(AnalysisType::isAnnotation).filter(AnalysisType::isReachable).map(type -> universe.lookup((JavaType)type.getWrapped()).getArrayClass()).filter(annotationArray -> !annotationArray.isInstantiated()).forEach(annotationArray -> {
            accessImpl.registerAsInHeap((AnalysisType)annotationArray);
            access.requireAnalysisIteration();
        });
        Stream allElements = Stream.concat(Stream.concat(universe.getFields().stream(), universe.getMethods().stream()), universe.getTypes().stream());
        Stream<AnnotatedElement> newElements = allElements.filter(arg_0 -> this.visitedElements.add(arg_0));
        newElements.forEach(this::reportAnnotation);
    }

    private void reportAnnotation(AnnotatedElement element) {
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            if (!this.repeatableAnnotationClasses.contains(annotation.annotationType())) continue;
            ((AnnotationTypeSupport)ImageSingletons.lookup(AnnotationTypeSupport.class)).createInstance(annotation.annotationType());
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.repeatableAnnotationClasses.clear();
        this.visitedElements.clear();
    }
}

