/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows.headers;

import com.oracle.svm.core.windows.headers.LibC;
import com.oracle.svm.core.windows.headers.WindowsDirectives;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.PointerBase;

@CContext(value=WindowsDirectives.class)
public class WinBase {
    public static final int MAX_PATH = 260;
    public static final int UNLEN = 256;

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetLastError();

    @CConstant
    public static native int ERROR_TIMEOUT();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void QueryPerformanceCounter(CLongPointer var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void QueryPerformanceFrequency(CLongPointer var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int CloseHandle(HANDLE var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int DuplicateHandle(HANDLE var0, HANDLE var1, HANDLE var2, LPHANDLE var3, int var4, boolean var5, int var6);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native HMODULE GetModuleHandleA(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetModuleFileNameA(HMODULE var0, CCharPointer var1, int var2);

    @CConstant
    public static native int GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS();

    @CConstant
    public static native int GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native boolean GetModuleHandleExA(int var0, PointerBase var1, HMODULEPointer var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native PointerBase GetProcAddress(HMODULE var0, PointerBase var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native HMODULE LoadLibraryA(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native HMODULE LoadLibraryExA(PointerBase var0, int var1, int var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void FreeLibrary(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native boolean SetDllDirectoryA(PointerBase var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetCurrentDirectoryW(int var0, LibC.WCharPointer var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetUserNameW(LibC.WCharPointer var0, CIntPointer var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int GetUserProfileDirectoryW(HANDLE var0, LibC.WCharPointer var1, CIntPointer var2);

    @CPointerTo(nameOfCType="HMODULE")
    public static interface HMODULEPointer
    extends PointerBase {
        public HMODULE read();

        public void write(HMODULE var1);
    }

    public static interface HMODULE
    extends PointerBase {
    }

    @CPointerTo(nameOfCType="HANDLE")
    public static interface LPHANDLE
    extends PointerBase {
        public HANDLE read();
    }

    public static interface HANDLE
    extends PointerBase {
    }
}

