/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedCompilationIdentifier
extends IsolatedObjectProxy<TruffleCompilationIdentifier>
implements TruffleCompilationIdentifier {
    private static final CompilationIdentifier.Verbosity[] VERBOSITIES = CompilationIdentifier.Verbosity.values();
    private final IsolatedCompilableTruffleAST compilable;
    private final String[] descriptions = new String[VERBOSITIES.length];

    IsolatedCompilationIdentifier(ClientHandle<TruffleCompilationIdentifier> handle, IsolatedCompilableTruffleAST compilable) {
        super(handle);
        this.compilable = compilable;
    }

    public CompilableTruffleAST getCompilable() {
        return this.compilable;
    }

    public void close() {
        IsolatedCompilationIdentifier.close0(IsolatedCompileContext.get().getClient(), this.handle);
    }

    public String toString(CompilationIdentifier.Verbosity verbosity) {
        int ordinal = verbosity.ordinal();
        if (this.descriptions[ordinal] == null) {
            CompilerHandle<String> h = IsolatedCompilationIdentifier.toString0(IsolatedCompileContext.get().getClient(), this.handle, ordinal);
            this.descriptions[ordinal] = IsolatedCompileContext.get().unhand(h);
        }
        return this.descriptions[ordinal];
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void close0(ClientIsolateThread client, ClientHandle<TruffleCompilationIdentifier> compilationHandle) {
        IsolatedCompileClient.get().unhand(compilationHandle).close();
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static CompilerHandle<String> toString0(ClientIsolateThread client, ClientHandle<TruffleCompilationIdentifier> idHandle, int verbosityOrdinal) {
        TruffleCompilationIdentifier id = IsolatedCompileClient.get().unhand(idHandle);
        String description = id.toString(VERBOSITIES[verbosityOrdinal]);
        return IsolatedCompileClient.get().createStringInCompiler(description);
    }
}

