/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.c.NativeLibraries;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
class JNIRegistrationSupport {
    private final ConcurrentMap<String, Boolean> registeredLibraries = new ConcurrentHashMap<String, Boolean>();
    private NativeLibraries nativeLibraries = null;

    JNIRegistrationSupport() {
    }

    public static JNIRegistrationSupport singleton() {
        return (JNIRegistrationSupport)ImageSingletons.lookup(JNIRegistrationSupport.class);
    }

    public void setNativeLibraries(NativeLibraries nativelibraries) {
        this.nativeLibraries = nativelibraries;
    }

    public void registerNativeLibrary(Providers providers, GraphBuilderConfiguration.Plugins plugins, Class clazz, String methodname) {
        InvocationPlugins.Registration systemRegistration = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)clazz);
        systemRegistration.register1(methodname, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode libnameNode) {
                String libname;
                if (libnameNode.isConstant() && (libname = (String)SubstrateObjectConstant.asObject(libnameNode.asConstant())) != null && NativeLibrarySupport.singleton().isPreregisteredBuiltinLibrary(libname) && JNIRegistrationSupport.this.registeredLibraries.putIfAbsent(libname, Boolean.TRUE) != Boolean.TRUE) {
                    JNIRegistrationSupport.this.nativeLibraries.addStaticJniLibrary(libname, new String[0]);
                }
                return false;
            }
        });
    }
}

