/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import java.util.function.Predicate;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.word.PointerBase;

public class JNIThreadLocalPinnedObjects {
    private static final FastThreadLocalObject<PinnedObjectListNode> pinnedObjectsListHead = FastThreadLocalFactory.createObject(PinnedObjectListNode.class);

    public static <T extends PointerBase> T pinArrayAndGetAddress(Object array) {
        PinnedObject pin = PinnedObject.create((Object)array);
        pinnedObjectsListHead.set(new PinnedObjectListNode(pin, pinnedObjectsListHead.get()));
        return (T)pin.addressOfArrayElement(0);
    }

    private static boolean unpinFirst(Predicate<PinnedObjectListNode> p) {
        PinnedObjectListNode previous = null;
        PinnedObjectListNode current = pinnedObjectsListHead.get();
        while (current != null) {
            if (p.test(current)) {
                if (previous != null) {
                    previous.next = current.next;
                } else {
                    pinnedObjectsListHead.set(current.next);
                }
                current.object.close();
                return true;
            }
            previous = current;
            current = current.next;
        }
        return false;
    }

    public static boolean unpinObject(Object object) {
        return JNIThreadLocalPinnedObjects.unpinFirst(n -> n.object.getObject() == object);
    }

    public static boolean unpinArrayByAddress(PointerBase address) {
        return JNIThreadLocalPinnedObjects.unpinFirst(n -> n.object.getObject().getClass().isArray() && n.object.addressOfArrayElement(0) == address);
    }

    static int pinnedObjectCount() {
        int count = 0;
        PinnedObjectListNode node = pinnedObjectsListHead.get();
        while (node != null) {
            ++count;
            node = node.next;
        }
        return count;
    }

    private static class PinnedObjectListNode {
        final PinnedObject object;
        PinnedObjectListNode next;

        PinnedObjectListNode(PinnedObject object, PinnedObjectListNode next) {
            this.object = object;
            this.next = next;
        }
    }
}

