/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.classinitialization.AbortOnDisallowedNode;
import com.oracle.svm.hosted.classinitialization.AbortOnRecursiveInliningPlugin;
import com.oracle.svm.hosted.classinitialization.AbortOnUnitializedClassPlugin;
import com.oracle.svm.hosted.classinitialization.ClassInitalizerHasSideEffectsException;
import com.oracle.svm.hosted.classinitialization.ClassInitializerGraphBuilderPhase;
import com.oracle.svm.hosted.phases.EarlyConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;

class EarlyClassInitializerAnalysis {
    private final Providers originalProviders = GraalAccess.getOriginalProviders();
    private final GraphBuilderConfiguration graphBuilderConfig;
    private final HighTierContext context;

    EarlyClassInitializerAnalysis() {
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        InvocationPlugins invocationPlugins = new InvocationPlugins();
        SubstrateGraphBuilderPlugins.registerClassDesiredAssertionStatusPlugin(invocationPlugins, originalSnippetReflection);
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)new AbortOnRecursiveInliningPlugin());
        plugins.setClassInitializationPlugin((ClassInitializationPlugin)new AbortOnUnitializedClassPlugin());
        plugins.appendNodePlugin((NodePlugin)new EarlyConstantFoldLoadFieldPlugin(this.originalProviders.getMetaAccess(), this.originalProviders.getSnippetReflection()));
        this.graphBuilderConfig = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)plugins).withEagerResolving(true);
        this.context = new HighTierContext(this.originalProviders, null, OptimisticOptimizations.NONE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean canInitializeWithoutSideEffects(Class<?> clazz) {
        ResolvedJavaType type = this.originalProviders.getMetaAccess().lookupJavaType(clazz);
        assert (type.getSuperclass() == null || type.getSuperclass().isInitialized()) : "This analysis assumes that the superclass was successfully analyzed and initialized beforehand: " + type.toJavaName(true);
        ResolvedJavaMethod clinit = type.getClassInitializer();
        if (clinit == null) {
            return true;
        }
        if (clinit.getCode() == null) {
            return false;
        }
        OptionValues options = HostedOptionValues.singleton();
        DebugContext debug = new DebugContext.Builder(options).build();
        try (DebugContext.Scope s = debug.scope((Object)"EarlyClassInitializerAnalysis", (Object)clinit);){
            boolean bl = this.canInitializeWithoutSideEffects(clinit, options, debug);
            return bl;
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canInitializeWithoutSideEffects(ResolvedJavaMethod clinit, OptionValues options, DebugContext debug) {
        StructuredGraph graph = new StructuredGraph.Builder(options, debug).method(clinit).build();
        graph.setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
        ClassInitializerGraphBuilderPhase builderPhase = new ClassInitializerGraphBuilderPhase((CoreProviders)this.context, this.graphBuilderConfig, this.context.getOptimisticOptimizations());
        try (Graph.NodeEventScope nes = graph.trackNodeEvents((Graph.NodeEventListener)new AbortOnDisallowedNode());){
            builderPhase.apply(graph, this.context);
            boolean bl = true;
            return bl;
        }
        catch (ClassInitalizerHasSideEffectsException ex) {
            return false;
        }
        catch (BytecodeParser.BytecodeParserError ex) {
            if (!(ex.getCause() instanceof ClassInitalizerHasSideEffectsException)) throw ex;
            return false;
        }
    }
}

