/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.util;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.libc.TemporaryBuildDirectoryProvider;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;

public class FileUtils {
    public static void drainInputStream(InputStream source, OutputStream sink) {
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = source.read(buffer)) != -1) {
                sink.write(buffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static List<String> readAllLines(InputStream source) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(source));
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static Process executeCommand(String ... args) throws IOException, InterruptedException {
        return FileUtils.executeCommand(Arrays.asList(args));
    }

    public static Process executeCommand(List<String> args) throws IOException, InterruptedException {
        ProcessBuilder command = FileUtils.prepareCommand(args, null).redirectErrorStream(true);
        FileUtils.traceCommand(command);
        Process process = command.start();
        try (InputStream inputStream = process.getInputStream();){
            FileUtils.traceCommandOutput(FileUtils.readAllLines(inputStream));
        }
        process.waitFor();
        return process;
    }

    public static ProcessBuilder prepareCommand(List<String> args, Path commandDir) throws IOException {
        Path tempDir;
        ProcessBuilder command = new ProcessBuilder(new String[0]).command(args);
        if (commandDir != null) {
            tempDir = commandDir;
        } else {
            Path temp = ((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory();
            tempDir = temp.resolve(Paths.get(args.get(0), new String[0]).getFileName());
        }
        Files.createDirectories(tempDir, new FileAttribute[0]);
        command.directory(tempDir.toFile());
        return command;
    }

    public static void traceCommand(ProcessBuilder command) {
        if (SubstrateOptions.TraceNativeToolUsage.getValue().booleanValue()) {
            String commandLine = SubstrateUtil.getShellCommandString(command.command(), false);
            System.out.printf(">> %s%n", commandLine);
        }
    }

    public static void traceCommandOutput(List<String> lines) {
        if (SubstrateOptions.TraceNativeToolUsage.getValue().booleanValue()) {
            for (String line : lines) {
                System.out.printf("># %s%n", line);
            }
        }
    }
}

