/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCodeInstallBridge;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import java.util.function.Consumer;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.ComparableWord;

public final class IsolatedTruffleRuntimeSupport {
    public static Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        ClientHandle<OptimizedAssumption> assumptionHandle = ((IsolatedObjectConstant)optimizedAssumptionConstant).getHandle();
        ClientHandle<Consumer<OptimizedAssumptionDependency>> consumerHandle = IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency0(IsolatedCompileContext.get().getClient(), assumptionHandle);
        if (consumerHandle.equal((ComparableWord)IsolatedHandles.nullHandle())) {
            return null;
        }
        return arg -> {
            ClientHandle<? extends OptimizedAssumptionDependency.Access> dependencyAccessHandle = (ClientHandle<? extends OptimizedAssumptionDependency.Access>)IsolatedHandles.nullHandle();
            if (arg != null) {
                IsolatedCodeInstallBridge accessor = (IsolatedCodeInstallBridge)((Object)arg);
                dependencyAccessHandle = accessor.getDependencyAccessHandle();
            }
            IsolatedTruffleRuntimeSupport.notifyAssumption0(IsolatedCompileContext.get().getClient(), consumerHandle, dependencyAccessHandle);
        };
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<Consumer<OptimizedAssumptionDependency>> registerOptimizedAssumptionDependency0(ClientIsolateThread client, ClientHandle<OptimizedAssumption> assumptionHandle) {
        OptimizedAssumption assumption = IsolatedCompileClient.get().unhand(assumptionHandle);
        Consumer observer = assumption.registerDependency();
        return IsolatedCompileClient.get().hand(observer);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void notifyAssumption0(ClientIsolateThread client, ClientHandle<Consumer<OptimizedAssumptionDependency>> consumerHandle, ClientHandle<? extends OptimizedAssumptionDependency.Access> dependencyAccessHandle) {
        OptimizedAssumptionDependency dependency = null;
        if (dependencyAccessHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
            dependency = IsolatedCompileClient.get().unhand(dependencyAccessHandle).getDependency();
        }
        IsolatedCompileClient.get().unhand(consumerHandle).accept(dependency);
    }

    public static JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        ClientHandle<OptimizedDirectCallNode> callNodeHandle = ((IsolatedObjectConstant)callNodeConstant).getHandle();
        return new IsolatedObjectConstant(IsolatedTruffleRuntimeSupport.getCallTargetForCallNode0(IsolatedCompileContext.get().getClient(), callNodeHandle), false);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<OptimizedCallTarget> getCallTargetForCallNode0(ClientIsolateThread client, ClientHandle<OptimizedDirectCallNode> callNode) {
        OptimizedDirectCallNode node = IsolatedCompileClient.get().unhand(callNode);
        OptimizedCallTarget callTarget = node.getCallTarget();
        return IsolatedCompileClient.get().hand(callTarget);
    }

    public static CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        ClientHandle<SubstrateCompilableTruffleAST> handle = ((IsolatedObjectConstant)constant).getHandle();
        return new IsolatedCompilableTruffleAST(handle);
    }

    public static boolean tryLog(String loggerId, CompilableTruffleAST compilable, String message) {
        if (compilable instanceof IsolatedCompilableTruffleAST) {
            ClientHandle<String> id = IsolatedCompileContext.get().createStringInClient(loggerId);
            ClientHandle<SubstrateCompilableTruffleAST> handle = ((IsolatedCompilableTruffleAST)compilable).getHandle();
            ClientHandle<String> msg = IsolatedCompileContext.get().createStringInClient(message);
            IsolatedTruffleRuntimeSupport.log0(IsolatedCompileContext.get().getClient(), id, handle, msg);
            return true;
        }
        return false;
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void log0(ClientIsolateThread client, ClientHandle<String> id, ClientHandle<SubstrateCompilableTruffleAST> ast, ClientHandle<String> msg) {
        SubstrateTruffleRuntime runtime = (SubstrateTruffleRuntime)SubstrateTruffleRuntime.getRuntime();
        String loggerId = IsolatedCompileClient.get().unhand(id);
        OptimizedCallTarget callTarget = (OptimizedCallTarget)IsolatedCompileClient.get().unhand(ast);
        String message = IsolatedCompileClient.get().unhand(msg);
        runtime.log(loggerId, (CompilableTruffleAST)callTarget, message);
    }

    private IsolatedTruffleRuntimeSupport() {
    }
}

