/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.graal.jdk.ArrayCopyWithExceptionNode;
import com.oracle.svm.core.graal.jdk.SubstrateArraycopyNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.ForeignCallWithExceptionNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ArraycopySnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAYCOPY = SnippetRuntime.findForeignCall(ArraycopySnippets.class, "doArraycopy", false, LocationIdentity.ANY_LOCATION);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ARRAYCOPY};

    public static void registerForeignCalls(Providers providers, SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(providers, FOREIGN_CALLS);
    }

    protected ArraycopySnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(SubstrateArraycopyNode.class, new ArraycopyLowering());
        lowerings.put(ArrayCopyWithExceptionNode.class, new ArrayCopyWithExceptionLowering());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void doArraycopy(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        if (fromArray == null || toArray == null) {
            throw new NullPointerException();
        }
        DynamicHub fromHub = KnownIntrinsics.readHub(fromArray);
        DynamicHub toHub = KnownIntrinsics.readHub(toArray);
        if (LayoutEncoding.isPrimitiveArray(fromHub.getLayoutEncoding())) {
            if (fromArray == toArray && fromIndex < toIndex) {
                ArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                ArraycopySnippets.primitiveCopyBackward(fromArray, fromIndex, fromArray, toIndex, length, fromHub.getLayoutEncoding());
                return;
            }
            if (fromHub == toHub) {
                ArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                ArraycopySnippets.primitiveCopyForward(fromArray, fromIndex, toArray, toIndex, length, fromHub.getLayoutEncoding());
                return;
            }
        } else if (LayoutEncoding.isObjectArray(fromHub.getLayoutEncoding())) {
            if (fromArray == toArray && fromIndex < toIndex) {
                ArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                ArraycopySnippets.objectCopyBackward(fromArray, fromIndex, fromArray, toIndex, length, fromHub.getLayoutEncoding());
                return;
            }
            if (fromHub == toHub || DynamicHub.toClass(toHub).isAssignableFrom(DynamicHub.toClass(fromHub))) {
                ArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                ArraycopySnippets.objectCopyForward(fromArray, fromIndex, toArray, toIndex, length, fromHub.getLayoutEncoding());
                return;
            }
            if (LayoutEncoding.isObjectArray(toHub.getLayoutEncoding())) {
                ArraycopySnippets.boundsCheck(fromArray, fromIndex, toArray, toIndex, length);
                ArraycopySnippets.objectStoreCheckCopyForward(fromArray, fromIndex, toArray, toIndex, length);
                return;
            }
        }
        throw new ArrayStoreException();
    }

    private static void boundsCheck(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        if (fromIndex < 0 || toIndex < 0 || length < 0 || fromIndex > KnownIntrinsics.readArrayLength(fromArray) - length || toIndex > KnownIntrinsics.readArrayLength(toArray) - length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void primitiveCopyForward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord elementSize = WordFactory.unsigned((int)LayoutEncoding.getArrayIndexScale(layoutEncoding));
        UnsignedWord size = elementSize.multiply(length);
        ArraycopySnippets.primitiveCopyForward(fromArray, fromOffset, toArray, toOffset, size);
    }

    public static void primitiveCopyForward(Object from, UnsignedWord fromOffset, Object to, UnsignedWord toOffset, UnsignedWord size) {
        UnsignedWord i = (UnsignedWord)WordFactory.zero();
        if (size.and(1).notEqual(0)) {
            ObjectAccess.writeByte((Object)to, (WordBase)toOffset.add(i), (byte)ObjectAccess.readByte((Object)from, (WordBase)fromOffset.add(i)));
            i = i.add(1);
        }
        if (size.and(2).notEqual(0)) {
            ObjectAccess.writeShort((Object)to, (WordBase)toOffset.add(i), (short)ObjectAccess.readShort((Object)from, (WordBase)fromOffset.add(i)));
            i = i.add(2);
        }
        if (size.and(4).notEqual(0)) {
            ObjectAccess.writeInt((Object)to, (WordBase)toOffset.add(i), (int)ObjectAccess.readInt((Object)from, (WordBase)fromOffset.add(i)));
            i = i.add(4);
        }
        while (i.belowThan(size)) {
            ObjectAccess.writeLong((Object)to, (WordBase)toOffset.add(i), (long)ObjectAccess.readLong((Object)from, (WordBase)fromOffset.add(i)));
            i = i.add(8);
        }
    }

    private static void primitiveCopyBackward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord elementSize = WordFactory.unsigned((int)LayoutEncoding.getArrayIndexScale(layoutEncoding));
        UnsignedWord size = elementSize.multiply(length);
        if (size.and(1).notEqual(0)) {
            size = size.subtract(1);
            ObjectAccess.writeByte((Object)toArray, (WordBase)toOffset.add(size), (byte)ObjectAccess.readByte((Object)fromArray, (WordBase)fromOffset.add(size)));
        }
        if (size.and(2).notEqual(0)) {
            size = size.subtract(2);
            ObjectAccess.writeShort((Object)toArray, (WordBase)toOffset.add(size), (short)ObjectAccess.readShort((Object)fromArray, (WordBase)fromOffset.add(size)));
        }
        if (size.and(4).notEqual(0)) {
            size = size.subtract(4);
            ObjectAccess.writeInt((Object)toArray, (WordBase)toOffset.add(size), (int)ObjectAccess.readInt((Object)fromArray, (WordBase)fromOffset.add(size)));
        }
        while (size.aboveThan(0)) {
            size = size.subtract(8);
            ObjectAccess.writeLong((Object)toArray, (WordBase)toOffset.add(size), (long)ObjectAccess.readLong((Object)fromArray, (WordBase)fromOffset.add(size)));
        }
    }

    public static void objectCopyForward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord elementSize = WordFactory.unsigned((int)LayoutEncoding.getArrayIndexScale(layoutEncoding));
        UnsignedWord size = elementSize.multiply(length);
        UnsignedWord copied = (UnsignedWord)WordFactory.zero();
        while (copied.belowThan(size)) {
            BarrieredAccess.writeObject((Object)toArray, (WordBase)toOffset.add(copied), (Object)BarrieredAccess.readObject((Object)fromArray, (WordBase)fromOffset.add(copied)));
            copied = copied.add(elementSize);
        }
    }

    private static void objectCopyBackward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length, int layoutEncoding) {
        UnsignedWord size;
        UnsignedWord fromOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, fromIndex);
        UnsignedWord toOffset = LayoutEncoding.getArrayElementOffset(layoutEncoding, toIndex);
        UnsignedWord elementSize = WordFactory.unsigned((int)LayoutEncoding.getArrayIndexScale(layoutEncoding));
        UnsignedWord remaining = size = elementSize.multiply(length);
        while (remaining.aboveThan(0)) {
            remaining = remaining.subtract(elementSize);
            BarrieredAccess.writeObject((Object)toArray, (WordBase)toOffset.add(remaining), (Object)BarrieredAccess.readObject((Object)fromArray, (WordBase)fromOffset.add(remaining)));
        }
    }

    public static void objectStoreCheckCopyForward(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        Object[] from = (Object[])fromArray;
        Object[] to = (Object[])toArray;
        for (int i = 0; i < length; ++i) {
            to[toIndex + i] = from[fromIndex + i];
        }
    }

    @Snippet
    private static void arraycopySnippet(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        ArraycopySnippets.callArraycopy(ARRAYCOPY, fromArray, fromIndex, toArray, toIndex, length);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callArraycopy(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, int var2, Object var3, int var4, int var5);

    final class ArrayCopyWithExceptionLowering
    implements NodeLoweringProvider<ArrayCopyWithExceptionNode> {
        ArrayCopyWithExceptionLowering() {
        }

        @Override
        public void lower(ArrayCopyWithExceptionNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)ARRAYCOPY, new ValueNode[]{node.getSource(), node.getSourcePosition(), node.getDestination(), node.getDestinationPosition(), node.getLength()}));
            call.setStateAfter(node.stateAfter());
            call.setBci(node.getBci());
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }

    final class ArraycopyLowering
    implements NodeLoweringProvider<SubstrateArraycopyNode> {
        private final SnippetTemplate.SnippetInfo arraycopyInfo;

        ArraycopyLowering() {
            this.arraycopyInfo = ArraycopySnippets.this.snippet(ArraycopySnippets.class, "arraycopySnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(SubstrateArraycopyNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.arraycopyInfo, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("fromArray", (Object)node.getSource());
            args.add("fromIndex", (Object)node.getSourcePosition());
            args.add("toArray", (Object)node.getDestination());
            args.add("toIndex", (Object)node.getDestinationPosition());
            args.add("length", (Object)node.getLength());
            ArraycopySnippets.this.template((ValueNode)node, args).instantiate(ArraycopySnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

