/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.truffle.nfi.LocalNativeScope;
import com.oracle.svm.truffle.nfi.NFIInitialization;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.NativeClosure;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFIType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.svm.truffle.nfi.libffi.LibFFI;
import com.oracle.svm.truffle.nfi.libffi.LibFFIHeaderDirectives;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class NativeSignature {
    NativeSignature() {
    }

    private static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    static class ExecuteHelper {
        ExecuteHelper() {
        }

        static int alignUp(int index, int alignment) {
            int ret = index;
            if (ret % alignment != 0) {
                ret += alignment - ret % alignment;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void execute(NativeAPI.NativeTruffleContext ctx, LibFFI.ffi_cif cif, PointerBase ret, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs, LocalNativeScope scope) {
            int nargs = cif.nargs();
            WordPointer argPtrs = (WordPointer)UnmanagedMemory.malloc((int)(nargs * SizeOf.get(WordPointer.class)));
            NativeAPI.NativeTruffleEnv env = (NativeAPI.NativeTruffleEnv)StackValue.get(NativeAPI.NativeTruffleEnv.class);
            NFIInitialization.initializeEnv(env, ctx);
            try (PinnedObject primBuffer = PinnedObject.create((Object)primArgs);){
                int i;
                Pointer prim = (Pointer)primBuffer.addressOfArrayElement(0);
                int primIdx = 0;
                for (i = 0; i < nargs; ++i) {
                    LibFFI.ffi_type type = cif.arg_types().read(i);
                    primIdx = ExecuteHelper.alignUp(primIdx, type.alignment());
                    argPtrs.write(i, (WordBase)prim.add(primIdx));
                    primIdx = (int)((long)primIdx + type.size().rawValue());
                }
                for (i = 0; i < patchCount; ++i) {
                    Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag tag = Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.getTag(patchOffsets[i]);
                    int offset = Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.getOffset(patchOffsets[i]);
                    Object obj = objArgs[i];
                    if (tag == Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.OBJECT) {
                        TruffleObjectHandle handle = scope.createLocalHandle(obj);
                        prim.writeWord(offset, (WordBase)handle);
                        continue;
                    }
                    if (tag == Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.STRING) {
                        PointerBase strPtr = scope.pinString((String)obj);
                        prim.writeWord(offset, (WordBase)strPtr);
                        continue;
                    }
                    if (tag == Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.CLOSURE) continue;
                    if (tag == Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.ENV) {
                        prim.writeWord(offset, (WordBase)env);
                        continue;
                    }
                    PointerBase arrPtr = scope.pinArray(obj);
                    prim.writeWord(offset, (WordBase)arrPtr);
                }
                try (TruffleNFISupport.NativeErrnoContext mirror = new TruffleNFISupport.NativeErrnoContext();){
                    LibFFI.ffi_call(cif, WordFactory.pointer((long)functionPointer), ret, argPtrs);
                }
                Throwable pending = NativeClosure.pendingException.get();
                if (pending != null) {
                    NativeClosure.pendingException.set(null);
                    throw NativeSignature.rethrow(pending);
                }
            }
            finally {
                UnmanagedMemory.free((PointerBase)argPtrs);
            }
        }
    }

    static class PrepareHelper {
        PrepareHelper() {
        }

        static CifData prepareArgs(Target_com_oracle_truffle_nfi_impl_LibFFIType ... args) {
            CifData data = (CifData)UnmanagedMemory.malloc((int)(SizeOf.get(CifData.class) + args.length * SizeOf.get(LibFFI.ffi_type_array.class)));
            for (int i = 0; i < args.length; ++i) {
                data.args().write(i, (LibFFI.ffi_type)WordFactory.pointer((long)args[i].type));
            }
            return data;
        }

        static long checkRet(CifData data, int ret) {
            if (ret == LibFFI.FFI_OK()) {
                return data.rawValue();
            }
            UnmanagedMemory.free((PointerBase)data);
            return 0L;
        }
    }

    @CContext(value=LibFFIHeaderDirectives.class)
    @CStruct(value="svm_cif_data")
    public static interface CifData
    extends PointerBase {
        @CFieldAddress
        public LibFFI.ffi_cif cif();

        @CFieldAddress
        public LibFFI.ffi_type_array args();
    }
}

