/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.core.graal.thread.LoadVMThreadLocalNode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;

public class SVMMethodTypeFlowBuilder
extends MethodTypeFlowBuilder {
    public SVMMethodTypeFlowBuilder(BigBang bb, MethodTypeFlow methodFlow) {
        super(bb, methodFlow);
    }

    public SVMMethodTypeFlowBuilder(BigBang bb, StructuredGraph graph) {
        super(bb, graph);
    }

    protected SVMHost getHostVM() {
        return (SVMHost)this.bb.getHostVM();
    }

    public void registerUsedElements(boolean registerEmbeddedRoots) {
        super.registerUsedElements(registerEmbeddedRoots);
        for (Node n : this.graph.getNodes()) {
            Object replaced;
            Object value;
            ConstantNode cn;
            if (!(n instanceof ConstantNode) || !(cn = (ConstantNode)n).hasUsages() || !cn.isJavaConstant() || cn.asJavaConstant().getJavaKind() != JavaKind.Object || !cn.asJavaConstant().isNonNull() || (value = SubstrateObjectConstant.asObject((Constant)cn.asJavaConstant())) == (replaced = this.bb.getUniverse().replaceObject(value))) continue;
            throw GraalError.shouldNotReachHere((String)("Missed object replacement during graph building: " + value + " (" + value.getClass() + ") != " + replaced + " (" + replaced.getClass() + ")"));
        }
    }

    protected void checkUnsafeOffset(ValueNode base, ValueNode offsetNode) {
        if (!NativeImageOptions.ThrowUnsafeOffsetErrors.getValue().booleanValue()) {
            return;
        }
        NodeSourcePosition pos = offsetNode.getNodeSourcePosition();
        if (offsetNode instanceof LoadFieldNode) {
            LoadFieldNode offsetLoadNode = (LoadFieldNode)offsetNode;
            AnalysisField field = (AnalysisField)offsetLoadNode.field();
            if (!(field.getDeclaringClass().unsafeFieldsRecomputed() || this.getHostVM().getClassInitializationSupport().shouldInitializeAtRuntime((ResolvedJavaType)field.getDeclaringClass()) || field.wrapped instanceof ComputedValueField || base.isConstant() && base.asConstant().isDefaultForKind())) {
                String message = String.format("Field %s is used as an offset in an unsafe operation, but no value recomputation found.%n Wrapped field: %s", field, field.wrapped);
                if (pos != null) {
                    message = message + String.format("%n Location: %s", pos);
                }
                UnsafeOffsetError.report(message);
            }
        } else if (NativeImageOptions.ReportUnsafeOffsetWarnings.getValue().booleanValue()) {
            String message = "Offset used in an unsafe operation. Cannot determine if the offset value is recomputed.";
            message = message + String.format("%nNode class: %s", offsetNode.getClass().getName());
            if (pos != null) {
                message = message + String.format("%n Location: %s", pos);
            }
            if (NativeImageOptions.UnsafeOffsetWarningsAreFatal.getValue().booleanValue()) {
                UnsafeOffsetError.report(message);
            } else {
                System.out.println(message);
            }
        }
    }

    protected void delegateNodeProcessing(FixedNode n, MethodTypeFlowBuilder.TypeFlowsOfNodes state) {
        LoadVMThreadLocalNode node;
        Stamp stamp;
        if (n instanceof LoadVMThreadLocalNode && (stamp = (node = (LoadVMThreadLocalNode)n).stamp(NodeView.DEFAULT)) instanceof ObjectStamp) {
            TypeFlowBuilder result;
            ObjectStamp objStamp = (ObjectStamp)stamp;
            VMError.guarantee(!objStamp.isEmpty());
            if (objStamp.isExactType()) {
                result = TypeFlowBuilder.create((BigBang)this.bb, (Object)((Object)node), SourceTypeFlow.class, () -> {
                    SourceTypeFlow src = new SourceTypeFlow((ValueNode)node, TypeState.forExactType((BigBang)this.bb, (AnalysisType)((AnalysisType)objStamp.type()), (!objStamp.nonNull() ? 1 : 0) != 0));
                    this.methodFlow.addSource(src);
                    return src;
                });
            } else {
                AnalysisType type = (AnalysisType)(objStamp.type() == null ? this.bb.getObjectType() : objStamp.type());
                result = TypeFlowBuilder.create((BigBang)this.bb, (Object)((Object)node), ProxyTypeFlow.class, () -> {
                    ProxyTypeFlow proxy = new ProxyTypeFlow((Node)node, (TypeFlow)type.getTypeFlow(this.bb, false));
                    this.methodFlow.addMiscEntry((TypeFlow)proxy);
                    return proxy;
                });
            }
            state.add((ValueNode)node, result);
        }
    }

    public static class UnsafeOffsetError
    extends UserError.UserException {
        UnsafeOffsetError(String message) {
            super(message);
        }

        static void report(String message) {
            throw new UnsafeOffsetError(message);
        }
    }
}

