/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK14OrEarlier;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.Target_java_lang_AssertionStatusDirectives;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

@TargetClass(value=ClassLoader.class)
final class Target_java_lang_ClassLoader {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private Vector<Class<?>> classes;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private ConcurrentHashMap<String, Object> parallelLockMap;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=HashMap.class)
    @TargetElement(name="packages", onlyWith={JDK8OrEarlier.class})
    private HashMap<String, Package> packagesJDK8;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ConcurrentHashMap.class)
    @TargetElement(name="packages", onlyWith={JDK11OrLater.class})
    private ConcurrentHashMap<String, Package> packagesJDK11;
    @Alias
    private static ClassLoader scl;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ConcurrentHashMap.class)
    @TargetElement(onlyWith={JDK11OrLater.class})
    ConcurrentHashMap<?, ?> classLoaderValueMap;

    Target_java_lang_ClassLoader() {
    }

    @Substitute
    public static ClassLoader getSystemClassLoader() {
        VMError.guarantee(scl != null);
        return scl;
    }

    @Delete
    private static native void initSystemClassLoader();

    @Substitute
    private URL getResource(String name) {
        return Target_java_lang_ClassLoader.getSystemResource(name);
    }

    @Substitute
    private InputStream getResourceAsStream(String name) {
        return Target_java_lang_ClassLoader.getSystemResourceAsStream(name);
    }

    @Substitute
    private Enumeration<URL> getResources(String name) {
        return Target_java_lang_ClassLoader.getSystemResources(name);
    }

    @Substitute
    private static URL getSystemResource(String name) {
        List<byte[]> arr = Resources.get(name);
        return arr == null ? null : Resources.createURL(name, arr.get(0));
    }

    @Substitute
    private static InputStream getSystemResourceAsStream(String name) {
        List<byte[]> arr = Resources.get(name);
        return arr == null ? null : new ByteArrayInputStream(arr.get(0));
    }

    @Substitute
    private static Enumeration<URL> getSystemResources(String name) {
        List<byte[]> arr = Resources.get(name);
        if (arr == null) {
            return Collections.emptyEnumeration();
        }
        ArrayList<URL> res = new ArrayList<URL>(arr.size());
        for (byte[] data : arr) {
            res.add(Resources.createURL(name, data));
        }
        return Collections.enumeration(res);
    }

    @Substitute
    @TargetElement(onlyWith={JDK14OrEarlier.class})
    static void loadLibrary(Class<?> fromClass, String name, boolean isAbsolute) {
        NativeLibrarySupport.singleton().loadLibrary(name, isAbsolute);
    }

    @Substitute
    private Class<?> loadClass(String name) throws ClassNotFoundException {
        return ClassForNameSupport.forName(name, false);
    }

    @Delete
    native Class<?> loadClass(String var1, boolean var2);

    @Delete
    native Class<?> findBootstrapClassOrNull(String var1);

    @Substitute
    static void checkClassLoaderPermission(ClassLoader cl, Class<?> caller) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    Class<?> loadClass(Target_java_lang_Module module, String name) {
        return ClassForNameSupport.forNameOrNull(name, false);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    private boolean trySetObjectField(String name, Object obj) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.trySetObjectField(String name, Object obj)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    protected URL findResource(String moduleName, String name) throws IOException {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.findResource(String, String)");
    }

    @Substitute
    Object getClassLoadingLock(String className) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.getClassLoadingLock(String)");
    }

    @Substitute
    private Class<?> findLoadedClass0(String name) {
        throw VMError.unsupportedFeature("Target_java_lang_ClassLoader.findLoadedClass0(String)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    protected Class<?> findClass(String moduleName, String name) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.findClass(String moduleName, String name)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public Package getDefinedPackage(String name) {
        throw VMError.unsupportedFeature("JDK11OrLater: Target_java_lang_ClassLoader.getDefinedPackage(String name)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public Target_java_lang_Module getUnnamedModule() {
        return DynamicHub.singleModuleReference.get();
    }

    @Substitute
    private void setDefaultAssertionStatus(boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setPackageAssertionStatus(String packageName, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void setClassAssertionStatus(String className, boolean enabled) {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Substitute
    private void clearAssertionStatus() {
        throw VMError.unsupportedFeature("The assertion status of classes is fixed at image build time.");
    }

    @Delete
    private static native void registerNatives();

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass1(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Class<?> defineClass2(String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native void resolveClass0(Class<?> var1);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native Class<?> defineClass1(ClassLoader var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    @TargetElement(onlyWith={JDK11OrLater.class})
    private static native Class<?> defineClass2(ClassLoader var0, String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    @Delete
    private native Class<?> findBootstrapClass(String var1);

    @Delete
    @TargetElement(onlyWith={JDK14OrEarlier.class})
    private static native String findBuiltinLib(String var0);

    @Delete
    private static native Target_java_lang_AssertionStatusDirectives retrieveDirectives();
}

