/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.image;

public class ImageHeapLayoutInfo {
    private final long writableOffsetInSection;
    private final long writableSize;
    private final long readOnlyRelocatableOffsetInSection;
    private final long readOnlyRelocatableSize;
    private final long imageHeapSize;

    public ImageHeapLayoutInfo(long writableOffsetInSection, long writableSize, long readOnlyRelocatableOffsetInSection, long readOnlyRelocatableSize, long imageHeapSize) {
        this.writableOffsetInSection = writableOffsetInSection;
        this.writableSize = writableSize;
        this.readOnlyRelocatableOffsetInSection = readOnlyRelocatableOffsetInSection;
        this.readOnlyRelocatableSize = readOnlyRelocatableSize;
        this.imageHeapSize = imageHeapSize;
    }

    public long getWritableOffset() {
        return this.writableOffsetInSection;
    }

    public long getWritableSize() {
        return this.writableSize;
    }

    public long getReadOnlyRelocatableOffset() {
        return this.readOnlyRelocatableOffsetInSection;
    }

    public long getReadOnlyRelocatableSize() {
        return this.readOnlyRelocatableSize;
    }

    public boolean isReadOnlyRelocatable(int offset) {
        return (long)offset >= this.readOnlyRelocatableOffsetInSection && (long)offset < this.readOnlyRelocatableOffsetInSection + this.readOnlyRelocatableSize;
    }

    public long getImageHeapSize() {
        return this.imageHeapSize;
    }
}

