/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public class CEntryPointLeaveNode
extends DeoptimizingFixedWithNextNode
implements Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<CEntryPointLeaveNode> TYPE = NodeClass.create(CEntryPointLeaveNode.class);
    protected final LeaveAction leaveAction;
    @Node.OptionalInput
    protected ValueNode exception;

    public CEntryPointLeaveNode(LeaveAction leaveAction) {
        this(leaveAction, null);
    }

    public CEntryPointLeaveNode(LeaveAction leaveAction, ValueNode exception) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Int));
        assert (leaveAction == LeaveAction.ExceptionAbort == (exception != null));
        this.leaveAction = leaveAction;
        this.exception = exception;
    }

    public LeaveAction getLeaveAction() {
        return this.leaveAction;
    }

    public ValueNode getException() {
        return this.exception;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public boolean canDeoptimize() {
        return true;
    }

    public boolean canUseAsStateDuring() {
        return true;
    }

    public static enum LeaveAction {
        Leave,
        DetachThread,
        TearDownIsolate,
        ExceptionAbort;

    }
}

