/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.LinearImageHeapAllocator;
import com.oracle.svm.core.image.AbstractImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;

public class LinearImageHeapPartition
extends AbstractImageHeapLayouter.AbstractImageHeapPartition {
    Object firstObject;
    Object lastObject;
    long startOffset = -1L;
    long endOffset = -1L;

    LinearImageHeapPartition(String name, boolean writable) {
        super(name, writable);
    }

    void allocateObjects(LinearImageHeapAllocator allocator) {
        allocator.align(this.getStartAlignment());
        this.startOffset = allocator.getPosition();
        for (ImageHeapObject info : this.getObjects()) {
            this.allocate(info, allocator);
        }
        allocator.align(this.getEndAlignment());
        this.endOffset = allocator.getPosition();
    }

    private void allocate(ImageHeapObject info, LinearImageHeapAllocator allocator) {
        assert (info.getPartition() == this);
        if (this.firstObject == null) {
            this.firstObject = info.getObject();
        }
        long offsetInPartition = allocator.allocate(info.getSize()) - this.startOffset;
        assert (ConfigurationValues.getObjectLayout().isAligned(offsetInPartition)) : "start: " + offsetInPartition + " must be aligned.";
        info.setOffsetInPartition(offsetInPartition);
        this.lastObject = info.getObject();
    }

    @Override
    public void assign(ImageHeapObject obj) {
        assert (this.startOffset == -1L && this.endOffset == -1L) : "Adding objects late is not supported";
        super.assign(obj);
    }

    @Override
    public long getStartOffset() {
        assert (this.startOffset >= 0L) : "Start offset not yet set";
        return this.startOffset;
    }

    public long getEndOffset() {
        assert (this.endOffset >= 0L) : "End offset not yet set";
        return this.endOffset;
    }

    @Override
    public long getSize() {
        return this.getEndOffset() - this.getStartOffset();
    }
}

