/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class GreyToBlackObjectVisitor
implements ObjectVisitor {
    private final DiagnosticReporter diagnosticReporter;
    private final GreyToBlackObjRefVisitor objRefVisitor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GreyToBlackObjectVisitor(GreyToBlackObjRefVisitor greyToBlackObjRefVisitor) {
        this.objRefVisitor = greyToBlackObjRefVisitor;
        if (DiagnosticReporter.getHistoryLength() > 0) {
            this.diagnosticReporter = new DiagnosticReporter();
            SubstrateUtil.DiagnosticThunkRegister.getSingleton().register(this.diagnosticReporter);
        } else {
            this.diagnosticReporter = null;
        }
    }

    public void reset() {
        if (this.diagnosticReporter != null) {
            this.diagnosticReporter.reset();
        }
    }

    @Override
    @NeverInline(value="Non-performance critical version")
    public boolean visitObject(Object o) {
        throw VMError.shouldNotReachHere("For performance reasons, this should not be called.");
    }

    @Override
    @AlwaysInline(value="GC performance")
    public boolean visitObjectInline(Object o) {
        if (this.diagnosticReporter != null) {
            this.diagnosticReporter.noteObject(o);
        }
        ReferenceObjectProcessing.discoverIfReference(o, this.objRefVisitor);
        InteriorObjRefWalker.walkObjectInline(o, this.objRefVisitor);
        return true;
    }

    static final class DiagnosticReporter
    implements SubstrateUtil.DiagnosticThunk {
        private long historyCount = 0L;
        private final Word[] objectHistory = new Word[DiagnosticReporter.getHistoryLength()];
        private final UnsignedWord[] headerHistory = new UnsignedWord[DiagnosticReporter.getHistoryLength()];

        @Platforms(value={Platform.HOSTED_ONLY.class})
        DiagnosticReporter() {
        }

        public void reset() {
            this.historyCount = 0L;
            for (int i = 0; i < DiagnosticReporter.getHistoryLength(); ++i) {
                this.objectHistory[i] = (Word)WordFactory.zero();
                this.headerHistory[i] = (UnsignedWord)WordFactory.zero();
            }
        }

        public void noteObject(Object o) {
            int index = DiagnosticReporter.countToIndex(this.historyCount);
            this.objectHistory[index] = Word.objectToUntrackedPointer((Object)o);
            this.headerHistory[index] = ObjectHeaderImpl.readHeaderFromObjectCarefully(o);
            ++this.historyCount;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
        public void invokeWithoutAllocation(Log log) {
            if (this.historyCount > 0L) {
                log.string("[GreyToBlackObjectVisitor.RealDiagnosticReporter.invoke:").string("  history / count:  ").signed(DiagnosticReporter.getHistoryLength()).string(" / ").signed(this.historyCount).indent(true);
                ImageHeapInfo imageHeapInfo = HeapImpl.getImageHeapInfo();
                for (int count = 0; count < DiagnosticReporter.getHistoryLength(); ++count) {
                    boolean headerInImageHeap;
                    int index = DiagnosticReporter.countToIndex(this.historyCount + (long)count);
                    log.string("  index: ").unsigned(index, 3, 2);
                    Word objectEntry = this.objectHistory[index];
                    log.string("  objectEntry: ").hex((WordBase)objectEntry);
                    UnsignedWord headerEntry = this.headerHistory[index];
                    Pointer headerHub = (Pointer)ObjectHeaderImpl.clearBits(headerEntry);
                    UnsignedWord headerHeaderBits = ObjectHeaderImpl.getHeaderBitsFromHeaderCarefully(headerEntry);
                    log.string("  headerEntry: ").hex((WordBase)headerEntry).string(" = ").hex((WordBase)headerHub).string(" | ").hex((WordBase)headerHeaderBits).string(" / ");
                    boolean bl = headerInImageHeap = imageHeapInfo.isInReadOnlyReferencePartition(headerHub) || imageHeapInfo.isInReadOnlyRelocatablePartition(headerHub);
                    if (headerInImageHeap) {
                        DynamicHub hub = (DynamicHub)KnownIntrinsics.convertUnknownValue(headerHub.toObject(), Object.class);
                        log.string("  class: ").string(hub.getName());
                        Object entryAsObject = KnownIntrinsics.convertUnknownValue(objectEntry.toObject(), Object.class);
                        if (LayoutEncoding.isArray(entryAsObject)) {
                            int length = KnownIntrinsics.readArrayLength(entryAsObject);
                            log.string("  length: ").signed(length);
                        }
                    } else {
                        log.string("  header not in image heap");
                    }
                    log.newline();
                }
                log.string("]").indent(false).flush();
            }
        }

        private static int getHistoryLength() {
            return Options.GreyToBlackObjectVisitorDiagnosticHistory.getValue();
        }

        private static int countToIndex(long value) {
            return (int)(value % (long)DiagnosticReporter.getHistoryLength());
        }

        static class Options {
            @Option(help={"Length of GreyToBlackObjectVisitor history for diagnostics. 0 implies no history is kept."})
            static final HostedOptionKey<Integer> GreyToBlackObjectVisitorDiagnosticHistory = new HostedOptionKey<Integer>(0);

            Options() {
            }
        }
    }
}

