// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: HeapPolicyOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class HeapPolicyOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AlignedHeapChunkSize": {
            return OptionDescriptor.create(
                /*name*/ "AlignedHeapChunkSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of an aligned chunk.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "AlignedHeapChunkSize",
                /*option*/ HeapPolicyOptions.AlignedHeapChunkSize,
                /*deprecated*/ false);
        }
        case "AllocationBeforePhysicalMemorySize": {
            return OptionDescriptor.create(
                /*name*/ "AllocationBeforePhysicalMemorySize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Bytes that can be allocated before (re-)querying the physical memory size",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "AllocationBeforePhysicalMemorySize",
                /*option*/ HeapPolicyOptions.AllocationBeforePhysicalMemorySize,
                /*deprecated*/ false);
        }
        case "LargeArrayThreshold": {
            return OptionDescriptor.create(
                /*name*/ "LargeArrayThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The size at or above which an array will be allocated in its own unaligned chunk.  0 implies (AlignedHeapChunkSize / 8).",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "LargeArrayThreshold",
                /*option*/ HeapPolicyOptions.LargeArrayThreshold,
                /*deprecated*/ false);
        }
        case "MaxSurvivorSpaces": {
            return OptionDescriptor.create(
                /*name*/ "MaxSurvivorSpaces",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of survivor spaces.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "MaxSurvivorSpaces",
                /*option*/ HeapPolicyOptions.MaxSurvivorSpaces,
                /*deprecated*/ false);
        }
        case "MaximumHeapSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumHeapSizePercent",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum heap size as percent of physical memory",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "MaximumHeapSizePercent",
                /*option*/ HeapPolicyOptions.MaximumHeapSizePercent,
                /*deprecated*/ false);
        }
        case "MaximumYoungGenerationSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumYoungGenerationSizePercent",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum size of the young generation as a percentage of the maximum heap size",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "MaximumYoungGenerationSizePercent",
                /*option*/ HeapPolicyOptions.MaximumYoungGenerationSizePercent,
                /*deprecated*/ false);
        }
        case "TraceHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "TraceHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "TraceHeapChunks",
                /*option*/ HeapPolicyOptions.TraceHeapChunks,
                /*deprecated*/ false);
        }
        case "UserRequestedGCPolicy": {
            return OptionDescriptor.create(
                /*name*/ "UserRequestedGCPolicy",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Policy used when user code requests garbage collection.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "UserRequestedGCPolicy",
                /*option*/ HeapPolicyOptions.UserRequestedGCPolicy,
                /*deprecated*/ false);
        }
        case "UserRequestedGCThreshold": {
            return OptionDescriptor.create(
                /*name*/ "UserRequestedGCThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "With the skeptical policy for user-requested collections, the threshold for the young generation size to cause a collection.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "UserRequestedGCThreshold",
                /*option*/ HeapPolicyOptions.UserRequestedGCThreshold,
                /*deprecated*/ false);
        }
        case "ZapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fill unused memory chunks with a sentinel value.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "ZapChunks",
                /*option*/ HeapPolicyOptions.ZapChunks,
                /*deprecated*/ false);
        }
        case "ZapConsumedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapConsumedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "After use, Fill memory chunks with a sentinel value.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "ZapConsumedHeapChunks",
                /*option*/ HeapPolicyOptions.ZapConsumedHeapChunks,
                /*deprecated*/ false);
        }
        case "ZapProducedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapProducedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Before use, fill memory chunks with a sentinel value.",
                /*declaringClass*/ HeapPolicyOptions.class,
                /*fieldName*/ "ZapProducedHeapChunks",
                /*option*/ HeapPolicyOptions.ZapProducedHeapChunks,
                /*deprecated*/ false);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 12;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlignedHeapChunkSize");
                    case 1: return get("AllocationBeforePhysicalMemorySize");
                    case 2: return get("LargeArrayThreshold");
                    case 3: return get("MaxSurvivorSpaces");
                    case 4: return get("MaximumHeapSizePercent");
                    case 5: return get("MaximumYoungGenerationSizePercent");
                    case 6: return get("TraceHeapChunks");
                    case 7: return get("UserRequestedGCPolicy");
                    case 8: return get("UserRequestedGCThreshold");
                    case 9: return get("ZapChunks");
                    case 10: return get("ZapConsumedHeapChunks");
                    case 11: return get("ZapProducedHeapChunks");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
