// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateOptions.java
package com.oracle.svm.core;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class SubstrateOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AOTInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform method inlining in the AOT compiled native image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTInline",
                /*option*/ SubstrateOptions.AOTInline,
                /*deprecated*/ false);
        }
        case "AOTTrivialInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTTrivialInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform trivial method inlining in the AOT compiled native image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTTrivialInline",
                /*option*/ SubstrateOptions.AOTTrivialInline,
                /*deprecated*/ false);
        }
        case "APIFunctionPrefix": {
            return OptionDescriptor.create(
                /*name*/ "APIFunctionPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of API functions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "APIFunctionPrefix",
                /*option*/ SubstrateOptions.APIFunctionPrefix,
                /*deprecated*/ false);
        }
        case "AllocateInstancePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocateInstancePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the object address using prefetch instructions generated in JIT compiled code.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocateInstancePrefetchLines",
                /*option*/ SubstrateOptions.AllocateInstancePrefetchLines,
                /*deprecated*/ false);
        }
        case "AllocatePrefetchDistance": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchDistance",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchDistance",
                /*option*/ SubstrateOptions.AllocatePrefetchDistance,
                /*deprecated*/ false);
        }
        case "AllocatePrefetchInstr": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchInstr",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchInstr",
                /*option*/ SubstrateOptions.AllocatePrefetchInstr,
                /*deprecated*/ false);
        }
        case "AllocatePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the array allocation using prefetch instructions generated in JIT compiled code.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchLines",
                /*option*/ SubstrateOptions.AllocatePrefetchLines,
                /*deprecated*/ false);
        }
        case "AllocatePrefetchStepSize": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStepSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the step size (in bytes) for sequential prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchStepSize",
                /*option*/ SubstrateOptions.AllocatePrefetchStepSize,
                /*deprecated*/ false);
        }
        case "AllocatePrefetchStyle": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStyle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchStyle",
                /*option*/ SubstrateOptions.AllocatePrefetchStyle,
                /*deprecated*/ false);
        }
        case "CCompilerOption": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerOption",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String[].class,
                /*help*/ "Provide custom C compiler option used for query code compilation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerOption",
                /*option*/ SubstrateOptions.CCompilerOption,
                /*deprecated*/ false);
        }
        case "CCompilerPath": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerPath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Provide custom path to C compiler used for query code compilation and linking.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerPath",
                /*option*/ SubstrateOptions.CCompilerPath,
                /*deprecated*/ false);
        }
        case "CLibraryPath": {
            return OptionDescriptor.create(
                /*name*/ "CLibraryPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Search path for C libraries passed to the linker (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CLibraryPath",
                /*option*/ SubstrateOptions.CLibraryPath,
                /*deprecated*/ false);
        }
        case "CheckToolchain": {
            return OptionDescriptor.create(
                /*name*/ "CheckToolchain",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Check if native-toolchain is known to work with native-image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CheckToolchain",
                /*option*/ SubstrateOptions.CheckToolchain,
                /*deprecated*/ false);
        }
        case "Class": {
            return OptionDescriptor.create(
                /*name*/ "Class",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Class containing the default entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Class",
                /*option*/ SubstrateOptions.Class,
                /*deprecated*/ false);
        }
        case "CompilerBackend": {
            return OptionDescriptor.create(
                /*name*/ "CompilerBackend",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Backend used by the compiler",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CompilerBackend",
                /*option*/ SubstrateOptions.CompilerBackend,
                /*deprecated*/ false);
        }
        case "DeadlockWatchdogExitOnTimeout": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogExitOnTimeout",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit the image builder VM after printing call stacks",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeadlockWatchdogExitOnTimeout",
                /*option*/ SubstrateOptions.DeadlockWatchdogExitOnTimeout,
                /*deprecated*/ false);
        }
        case "DeadlockWatchdogInterval": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogInterval",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "The interval in minutes between watchdog checks (0 disables the watchdog)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeadlockWatchdogInterval",
                /*option*/ SubstrateOptions.DeadlockWatchdogInterval,
                /*deprecated*/ false);
        }
        case "DebugInfoSourceCacheRoot": {
            return OptionDescriptor.create(
                /*name*/ "DebugInfoSourceCacheRoot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Directory under which to create source file cache for Application or GraalVM classes",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DebugInfoSourceCacheRoot",
                /*option*/ SubstrateOptions.DebugInfoSourceCacheRoot,
                /*deprecated*/ false);
        }
        case "DebugInfoSourceSearchPath": {
            return OptionDescriptor.create(
                /*name*/ "DebugInfoSourceSearchPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Search path for source files for Application or GraalVM classes (list of comma-separated directories or jar files)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DebugInfoSourceSearchPath",
                /*option*/ SubstrateOptions.DebugInfoSourceSearchPath,
                /*deprecated*/ false);
        }
        case "DeleteLocalSymbols": {
            return OptionDescriptor.create(
                /*name*/ "DeleteLocalSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to remove all local symbols from image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeleteLocalSymbols",
                /*option*/ SubstrateOptions.DeleteLocalSymbols,
                /*deprecated*/ false);
        }
        case "DetectUserDirectoriesInImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "DetectUserDirectoriesInImageHeap",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When set to true, the image generator verifies that the image heap does not contain a home directory as a substring",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DetectUserDirectoriesInImageHeap",
                /*option*/ SubstrateOptions.DetectUserDirectoriesInImageHeap,
                /*deprecated*/ false);
        }
        case "DumpTargetInfo": {
            return OptionDescriptor.create(
                /*name*/ "DumpTargetInfo",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show native-toolchain information and image-build settings",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DumpTargetInfo",
                /*option*/ SubstrateOptions.DumpTargetInfo,
                /*deprecated*/ false);
        }
        case "EmitStringEncodingSubstitutions": {
            return OptionDescriptor.create(
                /*name*/ "EmitStringEncodingSubstitutions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emit substitutions for UTF16 and latin1 compression",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EmitStringEncodingSubstitutions",
                /*option*/ SubstrateOptions.EmitStringEncodingSubstitutions,
                /*deprecated*/ false);
        }
        case "EnableAllSecurityServices": {
            return OptionDescriptor.create(
                /*name*/ "EnableAllSecurityServices",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Add all security service classes to the generated image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableAllSecurityServices",
                /*option*/ SubstrateOptions.EnableAllSecurityServices,
                /*deprecated*/ false);
        }
        case "EnableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "EnableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "List of comma separated URL protocols to enable.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableURLProtocols",
                /*option*/ SubstrateOptions.EnableURLProtocols,
                /*deprecated*/ false);
        }
        case "EntryPointNamePrefix": {
            return OptionDescriptor.create(
                /*name*/ "EntryPointNamePrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of entry point methods.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EntryPointNamePrefix",
                /*option*/ SubstrateOptions.EntryPointNamePrefix,
                /*deprecated*/ false);
        }
        case "FallbackThreshold": {
            return OptionDescriptor.create(
                /*name*/ "FallbackThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define when fallback-image generation should be used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FallbackThreshold",
                /*option*/ SubstrateOptions.FallbackThreshold,
                /*deprecated*/ false);
        }
        case "FoldSecurityManagerGetter": {
            return OptionDescriptor.create(
                /*name*/ "FoldSecurityManagerGetter",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fold SecurityManager getter.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FoldSecurityManagerGetter",
                /*option*/ SubstrateOptions.FoldSecurityManagerGetter,
                /*deprecated*/ false);
        }
        case "ForceNoROSectionRelocations": {
            return OptionDescriptor.create(
                /*name*/ "ForceNoROSectionRelocations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use only a writable native image heap (requires ld.gold linker)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ForceNoROSectionRelocations",
                /*option*/ SubstrateOptions.ForceNoROSectionRelocations,
                /*deprecated*/ false);
        }
        case "GenerateDebugInfo": {
            return OptionDescriptor.create(
                /*name*/ "GenerateDebugInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Insert debug info into the generated native image or library",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "GenerateDebugInfo",
                /*option*/ SubstrateOptions.GenerateDebugInfo,
                /*deprecated*/ false);
        }
        case "IncludeNodeSourcePositions": {
            return OptionDescriptor.create(
                /*name*/ "IncludeNodeSourcePositions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track NodeSourcePositions during runtime-compilation",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeNodeSourcePositions",
                /*option*/ SubstrateOptions.IncludeNodeSourcePositions,
                /*deprecated*/ false);
        }
        case "InstallExitHandlers": {
            return OptionDescriptor.create(
                /*name*/ "InstallExitHandlers",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Provide java.lang.Terminator exit handlers for executable images",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "InstallExitHandlers",
                /*option*/ SubstrateOptions.InstallExitHandlers,
                /*deprecated*/ false);
        }
        case "JNI": {
            return OptionDescriptor.create(
                /*name*/ "JNI",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Native Interface (JNI) support.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNI",
                /*option*/ SubstrateOptions.JNI,
                /*deprecated*/ false);
        }
        case "JNIExportSymbols": {
            return OptionDescriptor.create(
                /*name*/ "JNIExportSymbols",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Export Invocation API symbols.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIExportSymbols",
                /*option*/ SubstrateOptions.JNIExportSymbols,
                /*deprecated*/ false);
        }
        case "JNIVerboseLookupErrors": {
            return OptionDescriptor.create(
                /*name*/ "JNIVerboseLookupErrors",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report information about known JNI elements when lookup fails",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIVerboseLookupErrors",
                /*option*/ SubstrateOptions.JNIVerboseLookupErrors,
                /*deprecated*/ false);
        }
        case "LinkerRPath": {
            return OptionDescriptor.create(
                /*name*/ "LinkerRPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Path passed to the linker as the -rpath (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "LinkerRPath",
                /*option*/ SubstrateOptions.LinkerRPath,
                /*deprecated*/ false);
        }
        case "MaxDirectMemorySize": {
            return OptionDescriptor.create(
                /*name*/ "MaxDirectMemorySize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Maximum total size of NIO direct-buffer allocations",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxDirectMemorySize",
                /*option*/ SubstrateOptions.MaxDirectMemorySize,
                /*deprecated*/ false);
        }
        case "MaxHeapSize": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum heap size at run-time, in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxHeapSize",
                /*option*/ SubstrateOptions.MaxHeapSize,
                /*deprecated*/ false);
        }
        case "MaxInvokesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxInvokesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of invokes in a method so that it is considered trivial (for testing only).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxInvokesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxInvokesInTrivialMethod,
                /*deprecated*/ false);
        }
        case "MaxNewSize": {
            return OptionDescriptor.create(
                /*name*/ "MaxNewSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum size of the young generation at run-time, in bytes",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNewSize",
                /*option*/ SubstrateOptions.MaxNewSize,
                /*deprecated*/ false);
        }
        case "MaxNodesInTrivialLeafMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialLeafMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialLeafMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialLeafMethod,
                /*deprecated*/ false);
        }
        case "MaxNodesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialMethod,
                /*deprecated*/ false);
        }
        case "MaxUnrolledObjectZeroingStores": {
            return OptionDescriptor.create(
                /*name*/ "MaxUnrolledObjectZeroingStores",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define the maximum number of stores for which the loop that zeroes out objects is unrolled.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxUnrolledObjectZeroingStores",
                /*option*/ SubstrateOptions.MaxUnrolledObjectZeroingStores,
                /*deprecated*/ false);
        }
        case "Method": {
            return OptionDescriptor.create(
                /*name*/ "Method",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the main entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Method",
                /*option*/ SubstrateOptions.Method,
                /*deprecated*/ false);
        }
        case "MinHeapSize": {
            return OptionDescriptor.create(
                /*name*/ "MinHeapSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The minimum heap size at run-time, in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MinHeapSize",
                /*option*/ SubstrateOptions.MinHeapSize,
                /*deprecated*/ false);
        }
        case "MultiThreaded": {
            return OptionDescriptor.create(
                /*name*/ "MultiThreaded",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable support for threads and and thread-local variables (disable for single-threaded implementation)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MultiThreaded",
                /*option*/ SubstrateOptions.MultiThreaded,
                /*deprecated*/ false);
        }
        case "Name": {
            return OptionDescriptor.create(
                /*name*/ "Name",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the output file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Name",
                /*option*/ SubstrateOptions.Name,
                /*deprecated*/ false);
        }
        case "NeverInline": {
            return OptionDescriptor.create(
                /*name*/ "NeverInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Pattern for disabling inlining of methods during image generation.",
                /*extraHelp*/ new String[] {
                         "The syntax for a pattern is:",
                         "",
                         "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .",
                         "  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .",
                         "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .",
                         "  Class = { package \".\" } class .",
                         "",
                         "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.",
                         "",
                         "Examples of method filters:",
                         "---------",
                         "  visit(Argument;BlockScope)",
                         "",
                         "  Matches all methods named \"visit\", with the first parameter of",
                         "  type \"Argument\", and the second parameter of type \"BlockScope\".",
                         "  The packages of the parameter types are irrelevant.",
                         "---------",
                         "  arraycopy(Object;;;;)",
                         "",
                         "  Matches all methods named \"arraycopy\", with the first parameter",
                         "  of type \"Object\", and four more parameters of any type. The",
                         "  packages of the parameter types are irrelevant.",
                         "---------",
                         "  org.graalvm.compiler.core.graph.PostOrderNodeIterator.*",
                         "",
                         "  Matches all methods in the class \"org.graalvm.compiler.core.graph.PostOrderNodeIterator\".",
                         "---------",
                         "  *",
                         "",
                         "  Matches all methods in all classes",
                         "---------",
                         "  org.graalvm.compiler.core.graph.*.visit",
                         "",
                         "  Matches all methods named \"visit\" in classes in the package",
                         "  \"org.graalvm.compiler.core.graph\".",
                         "---------",
                         "  arraycopy,toString",
                         "",
                         "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "NeverInline",
                /*option*/ SubstrateOptions.NeverInline,
                /*deprecated*/ false);
        }
        case "Optimize": {
            return OptionDescriptor.create(
                /*name*/ "Optimize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Control native-image code optimizations: 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Optimize",
                /*option*/ SubstrateOptions.Optimize,
                /*deprecated*/ false);
        }
        case "ParseRuntimeOptions": {
            return OptionDescriptor.create(
                /*name*/ "ParseRuntimeOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Parse and consume standard options and system properties from the command line arguments when the VM is created.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ParseRuntimeOptions",
                /*option*/ SubstrateOptions.ParseRuntimeOptions,
                /*deprecated*/ false);
        }
        case "Path": {
            return OptionDescriptor.create(
                /*name*/ "Path",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Directory of the image file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Path",
                /*option*/ SubstrateOptions.Path,
                /*deprecated*/ false);
        }
        case "PreserveFramePointer": {
            return OptionDescriptor.create(
                /*name*/ "PreserveFramePointer",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Saves stack base pointer on the stack on method entry.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PreserveFramePointer",
                /*option*/ SubstrateOptions.PreserveFramePointer,
                /*deprecated*/ false);
        }
        case "PrintFlags": {
            return OptionDescriptor.create(
                /*name*/ "PrintFlags",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Show available options based on comma-separated option-types (allowed categories: User, Expert, Debug).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PrintFlags",
                /*option*/ SubstrateOptions.PrintFlags,
                /*deprecated*/ false);
        }
        case "PrintFlagsWithExtraHelp": {
            return OptionDescriptor.create(
                /*name*/ "PrintFlagsWithExtraHelp",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Print extra help, if available, based on comma-separated option names. Pass * to show all options that contain extra help.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PrintFlagsWithExtraHelp",
                /*option*/ SubstrateOptions.PrintFlagsWithExtraHelp,
                /*deprecated*/ false);
        }
        case "PrintGC": {
            return OptionDescriptor.create(
                /*name*/ "PrintGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after each collection",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PrintGC",
                /*option*/ SubstrateOptions.PrintGC,
                /*deprecated*/ false);
        }
        case "RemoveUnusedSymbols": {
            return OptionDescriptor.create(
                /*name*/ "RemoveUnusedSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to prevent unreferenced symbols in image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RemoveUnusedSymbols",
                /*option*/ SubstrateOptions.RemoveUnusedSymbols,
                /*deprecated*/ false);
        }
        case "ReportAnalysisForbiddenType": {
            return OptionDescriptor.create(
                /*name*/ "ReportAnalysisForbiddenType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, InTypeCheck).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ReportAnalysisForbiddenType",
                /*option*/ SubstrateOptions.ReportAnalysisForbiddenType,
                /*deprecated*/ false);
        }
        case "RuntimeAssertions": {
            return OptionDescriptor.create(
                /*name*/ "RuntimeAssertions",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable or disable Java assert statements at run time",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RuntimeAssertions",
                /*option*/ SubstrateOptions.RuntimeAssertions,
                /*deprecated*/ false);
        }
        case "RuntimeAssertionsFilter": {
            return OptionDescriptor.create(
                /*name*/ "RuntimeAssertionsFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String[].class,
                /*help*/ "Only use Java assert statements for classes that are matching the comma-separated list of package prefixes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RuntimeAssertionsFilter",
                /*option*/ SubstrateOptions.RuntimeAssertionsFilter,
                /*deprecated*/ false);
        }
        case "SharedLibrary": {
            return OptionDescriptor.create(
                /*name*/ "SharedLibrary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build shared library",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SharedLibrary",
                /*option*/ SubstrateOptions.SharedLibrary,
                /*deprecated*/ false);
        }
        case "SpawnIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SpawnIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support multiple isolates.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SpawnIsolates",
                /*option*/ SubstrateOptions.SpawnIsolates,
                /*deprecated*/ false);
        }
        case "StackSize": {
            return OptionDescriptor.create(
                /*name*/ "StackSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of each thread stack at run-time, in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StackSize",
                /*option*/ SubstrateOptions.StackSize,
                /*deprecated*/ false);
        }
        case "StackTrace": {
            return OptionDescriptor.create(
                /*name*/ "StackTrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Provide method names for stack traces.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StackTrace",
                /*option*/ SubstrateOptions.StackTrace,
                /*deprecated*/ false);
        }
        case "StaticExecutable": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build statically linked executable (requires static libc and zlib)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticExecutable",
                /*option*/ SubstrateOptions.StaticExecutable,
                /*deprecated*/ false);
        }
        case "StaticExecutableWithDynamicLibC": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutableWithDynamicLibC",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Builds a statically linked executable with libc dynamically linked",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticExecutableWithDynamicLibC",
                /*option*/ SubstrateOptions.StaticExecutableWithDynamicLibC,
                /*deprecated*/ false);
        }
        case "TearDownFailureNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownFailureNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownFailureNanos",
                /*option*/ SubstrateOptions.TearDownFailureNanos,
                /*deprecated*/ false);
        }
        case "TearDownWarningNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownWarningNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownWarningNanos",
                /*option*/ SubstrateOptions.TearDownWarningNanos,
                /*deprecated*/ false);
        }
        case "TraceClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "TraceClassInitialization",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument code to trace and report class initialization.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceClassInitialization",
                /*option*/ SubstrateOptions.TraceClassInitialization,
                /*deprecated*/ false);
        }
        case "TraceVMOperations": {
            return OptionDescriptor.create(
                /*name*/ "TraceVMOperations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace VMOperation execution.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceVMOperations",
                /*option*/ SubstrateOptions.TraceVMOperations,
                /*deprecated*/ false);
        }
        case "UseCalleeSavedRegisters": {
            return OptionDescriptor.create(
                /*name*/ "UseCalleeSavedRegisters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseCalleeSavedRegisters",
                /*option*/ SubstrateOptions.UseCalleeSavedRegisters,
                /*deprecated*/ false);
        }
        case "UseCardRememberedSetHeap": {
            return OptionDescriptor.create(
                /*name*/ "UseCardRememberedSetHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a card remembered set heap for GC",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseCardRememberedSetHeap",
                /*option*/ SubstrateOptions.UseCardRememberedSetHeap,
                /*deprecated*/ false);
        }
        case "UseDedicatedVMOperationThread": {
            return OptionDescriptor.create(
                /*name*/ "UseDedicatedVMOperationThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if VM operations should be executed in a dedicated thread.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseDedicatedVMOperationThread",
                /*option*/ SubstrateOptions.UseDedicatedVMOperationThread,
                /*deprecated*/ false);
        }
        case "UseReferenceHandlerThread": {
            return OptionDescriptor.create(
                /*name*/ "UseReferenceHandlerThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Populate reference queues in a separate thread rather than after a garbage collection.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseReferenceHandlerThread",
                /*option*/ SubstrateOptions.UseReferenceHandlerThread,
                /*deprecated*/ false);
        }
        case "VerboseGC": {
            return OptionDescriptor.create(
                /*name*/ "VerboseGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print more information about the heap before and after each collection",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerboseGC",
                /*option*/ SubstrateOptions.VerboseGC,
                /*deprecated*/ false);
        }
        case "VerifyHeap": {
            return OptionDescriptor.create(
                /*name*/ "VerifyHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap before and after each collection.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyHeap",
                /*option*/ SubstrateOptions.VerifyHeap,
                /*deprecated*/ false);
        }
        case "VerifyNamingConventions": {
            return OptionDescriptor.create(
                /*name*/ "VerifyNamingConventions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify naming conventions during image construction.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyNamingConventions",
                /*option*/ SubstrateOptions.VerifyNamingConventions,
                /*deprecated*/ false);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 76;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AOTInline");
                    case 1: return get("AOTTrivialInline");
                    case 2: return get("APIFunctionPrefix");
                    case 3: return get("AllocateInstancePrefetchLines");
                    case 4: return get("AllocatePrefetchDistance");
                    case 5: return get("AllocatePrefetchInstr");
                    case 6: return get("AllocatePrefetchLines");
                    case 7: return get("AllocatePrefetchStepSize");
                    case 8: return get("AllocatePrefetchStyle");
                    case 9: return get("CCompilerOption");
                    case 10: return get("CCompilerPath");
                    case 11: return get("CLibraryPath");
                    case 12: return get("CheckToolchain");
                    case 13: return get("Class");
                    case 14: return get("CompilerBackend");
                    case 15: return get("DeadlockWatchdogExitOnTimeout");
                    case 16: return get("DeadlockWatchdogInterval");
                    case 17: return get("DebugInfoSourceCacheRoot");
                    case 18: return get("DebugInfoSourceSearchPath");
                    case 19: return get("DeleteLocalSymbols");
                    case 20: return get("DetectUserDirectoriesInImageHeap");
                    case 21: return get("DumpTargetInfo");
                    case 22: return get("EmitStringEncodingSubstitutions");
                    case 23: return get("EnableAllSecurityServices");
                    case 24: return get("EnableURLProtocols");
                    case 25: return get("EntryPointNamePrefix");
                    case 26: return get("FallbackThreshold");
                    case 27: return get("FoldSecurityManagerGetter");
                    case 28: return get("ForceNoROSectionRelocations");
                    case 29: return get("GenerateDebugInfo");
                    case 30: return get("IncludeNodeSourcePositions");
                    case 31: return get("InstallExitHandlers");
                    case 32: return get("JNI");
                    case 33: return get("JNIExportSymbols");
                    case 34: return get("JNIVerboseLookupErrors");
                    case 35: return get("LinkerRPath");
                    case 36: return get("MaxDirectMemorySize");
                    case 37: return get("MaxHeapSize");
                    case 38: return get("MaxInvokesInTrivialMethod");
                    case 39: return get("MaxNewSize");
                    case 40: return get("MaxNodesInTrivialLeafMethod");
                    case 41: return get("MaxNodesInTrivialMethod");
                    case 42: return get("MaxUnrolledObjectZeroingStores");
                    case 43: return get("Method");
                    case 44: return get("MinHeapSize");
                    case 45: return get("MultiThreaded");
                    case 46: return get("Name");
                    case 47: return get("NeverInline");
                    case 48: return get("Optimize");
                    case 49: return get("ParseRuntimeOptions");
                    case 50: return get("Path");
                    case 51: return get("PreserveFramePointer");
                    case 52: return get("PrintFlags");
                    case 53: return get("PrintFlagsWithExtraHelp");
                    case 54: return get("PrintGC");
                    case 55: return get("RemoveUnusedSymbols");
                    case 56: return get("ReportAnalysisForbiddenType");
                    case 57: return get("RuntimeAssertions");
                    case 58: return get("RuntimeAssertionsFilter");
                    case 59: return get("SharedLibrary");
                    case 60: return get("SpawnIsolates");
                    case 61: return get("StackSize");
                    case 62: return get("StackTrace");
                    case 63: return get("StaticExecutable");
                    case 64: return get("StaticExecutableWithDynamicLibC");
                    case 65: return get("TearDownFailureNanos");
                    case 66: return get("TearDownWarningNanos");
                    case 67: return get("TraceClassInitialization");
                    case 68: return get("TraceVMOperations");
                    case 69: return get("UseCalleeSavedRegisters");
                    case 70: return get("UseCardRememberedSetHeap");
                    case 71: return get("UseDedicatedVMOperationThread");
                    case 72: return get("UseReferenceHandlerThread");
                    case 73: return get("VerboseGC");
                    case 74: return get("VerifyHeap");
                    case 75: return get("VerifyNamingConventions");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
