/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi.posix;

import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NFIUnsatisfiedLinkError;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.posix.Target_com_oracle_truffle_nfi_impl_NFIContextLinux;
import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class PosixTruffleNFISupport
extends TruffleNFISupport {
    private static final int ISOLATED_NAMESPACE_FLAG = 65536;
    private static final int ISOLATED_NAMESPACE_NOT_SUPPORTED_FLAG = 0;
    static int isolatedNamespaceFlag;

    static void initialize() {
        isolatedNamespaceFlag = LibCBase.singleton().hasIsolatedNamespaces() ? 65536 : 0;
        ImageSingletons.add(TruffleNFISupport.class, (Object)new PosixTruffleNFISupport());
    }

    private PosixTruffleNFISupport() {
        super(PosixTruffleNFISupport.getErrnoGetterFunctionName());
    }

    private static String getErrnoGetterFunctionName() {
        if (Platform.includedIn(Platform.LINUX.class)) {
            return "__errno_location";
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return "__error";
        }
        throw VMError.unsupportedFeature("unsupported platform for TruffleNFIFeature");
    }

    @Override
    protected CCharPointer strdupImpl(CCharPointer src) {
        return LibC.strdup(src);
    }

    private static PointerBase dlmopen(Dlfcn.GNUExtensions.Lmid_t lmid, String filename, int mode) {
        try (CTypeConversion.CCharPointerHolder pathPin = CTypeConversion.toCString((CharSequence)filename);){
            CCharPointer pathPtr = pathPin.get();
            PointerBase pointerBase = Dlfcn.GNUExtensions.dlmopen(lmid, pathPtr, mode);
            return pointerBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PointerBase loadLibraryInNamespace(long nativeContext, String name, int mode) {
        assert ((mode & isolatedNamespaceFlag) == 0);
        Target_com_oracle_truffle_nfi_impl_NFIContextLinux context = KnownIntrinsics.convertUnknownValue(PosixTruffleNFISupport.getContext(nativeContext), Target_com_oracle_truffle_nfi_impl_NFIContextLinux.class);
        long namespaceId = context.isolatedNamespaceId;
        if (namespaceId == 0L) {
            Target_com_oracle_truffle_nfi_impl_NFIContextLinux target_com_oracle_truffle_nfi_impl_NFIContextLinux = context;
            synchronized (target_com_oracle_truffle_nfi_impl_NFIContextLinux) {
                namespaceId = context.isolatedNamespaceId;
                if (namespaceId == 0L) {
                    PointerBase handle = PosixTruffleNFISupport.dlmopen((Dlfcn.GNUExtensions.Lmid_t)WordFactory.signed((int)Dlfcn.GNUExtensions.LM_ID_NEWLM()), name, mode);
                    if (handle.equal((ComparableWord)WordFactory.zero())) {
                        return handle;
                    }
                    Dlfcn.GNUExtensions.Lmid_tPointer namespacePtr = (Dlfcn.GNUExtensions.Lmid_tPointer)StackValue.get(Dlfcn.GNUExtensions.Lmid_tPointer.class);
                    int ret = Dlfcn.GNUExtensions.dlinfo(handle, Dlfcn.GNUExtensions.RTLD_DI_LMID(), namespacePtr);
                    if (ret != 0) {
                        CompilerDirectives.transferToInterpreter();
                        String error = PosixUtils.dlerror();
                        throw VMError.shouldNotReachHere("dlinfo failed to obtain link-map list (namespace) of '" + name + "': " + error);
                    }
                    namespaceId = namespacePtr.read().rawValue();
                    assert (namespaceId != 0L);
                    context.isolatedNamespaceId = namespaceId;
                    return handle;
                }
            }
        }
        assert (namespaceId != 0L);
        return PosixTruffleNFISupport.dlmopen((Dlfcn.GNUExtensions.Lmid_t)WordFactory.signed((long)namespaceId), name, mode);
    }

    @Override
    protected long loadLibraryImpl(long nativeContext, String name, int flags) {
        PointerBase handle = Platform.includedIn(Platform.LINUX.class) && (flags & isolatedNamespaceFlag) != 0 ? PosixTruffleNFISupport.loadLibraryInNamespace(nativeContext, name, flags & ~isolatedNamespaceFlag) : PosixUtils.dlopen(name, flags);
        if (handle.equal((ComparableWord)WordFactory.zero())) {
            CompilerDirectives.transferToInterpreter();
            String error = PosixUtils.dlerror();
            throw new UnsatisfiedLinkError(error);
        }
        return handle.rawValue();
    }

    @Override
    protected void freeLibraryImpl(long library) {
        Dlfcn.dlclose(WordFactory.pointer((long)library));
    }

    @Override
    protected long lookupImpl(long nativeContext, long library, String name) {
        Dlfcn.dlerror();
        PlatformNativeLibrarySupport nativeLibrarySupport = PlatformNativeLibrarySupport.singleton();
        Object ret = library == 0L ? nativeLibrarySupport.findBuiltinSymbol(name) : PosixUtils.dlsym(WordFactory.pointer((long)library), name);
        if (ret.equal((ComparableWord)WordFactory.zero())) {
            CompilerDirectives.transferToInterpreter();
            String error = PosixUtils.dlerror();
            if (error != null) {
                throw KnownIntrinsics.convertUnknownValue(new Target_com_oracle_truffle_nfi_impl_NFIUnsatisfiedLinkError(error), UnsatisfiedLinkError.class);
            }
        }
        return ret.rawValue();
    }
}

