/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.hosted.image.sources.SourceCache;
import com.oracle.svm.hosted.image.sources.SourceCacheType;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JDKSourceCache
extends SourceCache {
    private static final String JAVA_HOME_PROP = "java.home";
    private static final String JAVA_SPEC_VERSION_PROP = "java.specification.version";

    protected JDKSourceCache() {
        this.initSrcRoots();
    }

    @Override
    protected final SourceCacheType getType() {
        return SourceCacheType.JDK;
    }

    private void initSrcRoots() {
        Path srcZipPath;
        String javaHome = System.getProperty(JAVA_HOME_PROP);
        assert (javaHome != null);
        Path javaHomePath = Paths.get("", javaHome);
        String javaSpecVersion = System.getProperty(JAVA_SPEC_VERSION_PROP);
        if (javaSpecVersion.equals("1.8")) {
            srcZipPath = javaHomePath.resolve("src.zip");
        } else {
            assert (javaSpecVersion.matches("[1-9][0-9]"));
            srcZipPath = javaHomePath.resolve("lib").resolve("src.zip");
        }
        if (srcZipPath.toFile().exists()) {
            try {
                FileSystem srcFileSystem = FileSystems.newFileSystem(srcZipPath, (ClassLoader)null);
                for (Path root : srcFileSystem.getRootDirectories()) {
                    this.srcRoots.add(root);
                }
            }
            catch (IOException | FileSystemNotFoundException exception) {
                // empty catch block
            }
        }
    }
}

