/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.image.ExecutableViaCCBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.SharedLibraryViaCCBootImage;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import org.graalvm.compiler.debug.DebugContext;

public abstract class AbstractBootImage {
    protected final HostedMetaAccess metaAccess;
    protected final HostedUniverse universe;
    protected final NativeLibraries nativeLibs;
    protected final NativeImageHeap heap;
    protected final ClassLoader imageClassLoader;
    protected final NativeImageCodeCache codeCache;
    protected final List<HostedMethod> entryPoints;
    protected int resultingImageSize;
    protected final NativeImageKind kind;

    protected AbstractBootImage(NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader imageClassLoader) {
        this.kind = k;
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.nativeLibs = nativeLibs;
        this.heap = heap;
        this.codeCache = codeCache;
        this.entryPoints = entryPoints;
        this.imageClassLoader = imageClassLoader;
    }

    public NativeImageKind getBootImageKind() {
        return this.kind;
    }

    public int getImageSize() {
        return this.resultingImageSize;
    }

    public NativeLibraries getNativeLibs() {
        return this.nativeLibs;
    }

    public abstract void build(DebugContext var1, ImageHeapLayouter var2);

    public abstract LinkerInvocation write(DebugContext var1, Path var2, Path var3, String var4, FeatureImpl.BeforeImageWriteAccessImpl var5);

    public abstract ObjectFile.Section getTextSection();

    public static AbstractBootImage create(NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader classLoader) {
        switch (k) {
            case SHARED_LIBRARY: {
                return new SharedLibraryViaCCBootImage(universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, classLoader);
            }
        }
        return new ExecutableViaCCBootImage(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, classLoader);
    }

    public abstract String[] makeLaunchCommand(NativeImageKind var1, String var2, Path var3, Path var4, Method var5);

    public NativeImageCodeCache getCodeCache() {
        return this.codeCache;
    }

    public NativeImageHeap getHeap() {
        return this.heap;
    }

    public abstract ObjectFile getOrCreateDebugObjectFile();

    public boolean requiresCustomDebugRelocation() {
        return false;
    }

    public NativeImageKind getKind() {
        return this.kind;
    }

    public static enum NativeImageKind {
        SHARED_LIBRARY(false){

            @Override
            public String getFilenameSuffix() {
                switch (ObjectFile.getNativeFormat()) {
                    case ELF: {
                        return ".so";
                    }
                    case MACH_O: {
                        return ".dylib";
                    }
                    case PECOFF: {
                        return ".dll";
                    }
                }
                throw new AssertionError((Object)"unreachable");
            }

            @Override
            public String getFilenamePrefix() {
                return ObjectFile.getNativeFormat() == ObjectFile.Format.PECOFF ? "" : "lib";
            }
        }
        ,
        EXECUTABLE(true),
        STATIC_EXECUTABLE(true);

        public final boolean isExecutable;
        public final String mainEntryPointName;

        private NativeImageKind(boolean executable) {
            this.isExecutable = executable;
            this.mainEntryPointName = executable ? "main" : "run_main";
        }

        public String getFilenameSuffix() {
            return ObjectFile.getNativeFormat() == ObjectFile.Format.PECOFF ? ".exe" : "";
        }

        public String getFilenamePrefix() {
            return "";
        }

        public String getFilename(String basename) {
            return this.getFilenamePrefix() + basename + this.getFilenameSuffix();
        }
    }
}

