/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.dashboard.DashboardDumpFeature;
import com.oracle.svm.hosted.image.NativeImageHeap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.nativeimage.hosted.Feature;

class HeapBreakdownDumper {
    HeapBreakdownDumper() {
    }

    DashboardDumpFeature.Dict dump(Feature.AfterHeapLayoutAccess access) {
        FeatureImpl.AfterHeapLayoutAccessImpl config = (FeatureImpl.AfterHeapLayoutAccessImpl)access;
        NativeImageHeap heap = config.getHeap();
        HashMap<String, Statistics> sizes = new HashMap<String, Statistics>();
        for (NativeImageHeap.ObjectInfo objectInfo : heap.getObjects()) {
            String string = objectInfo.getClazz().getName();
            Statistics stats = (Statistics)sizes.get(string);
            if (stats == null) {
                stats = new Statistics();
                sizes.put(string, stats);
            }
            stats.size += objectInfo.getSize();
            ++stats.count;
        }
        ArrayList<DashboardDumpFeature.Dict> classInfos = new ArrayList<DashboardDumpFeature.Dict>();
        for (Map.Entry entry : sizes.entrySet()) {
            String className = (String)entry.getKey();
            Statistics stats = (Statistics)entry.getValue();
            DashboardDumpFeature.Dict classInfo = new DashboardDumpFeature.Dict();
            classInfo.insert("name", className);
            classInfo.insert("size", stats.size);
            classInfo.insert("count", stats.count);
            classInfos.add(classInfo);
        }
        DashboardDumpFeature.Dict dict = new DashboardDumpFeature.Dict();
        dict.insert("heap-size", classInfos);
        return dict;
    }

    private class Statistics {
        long size = 0L;
        long count = 0L;

        private Statistics() {
        }
    }
}

