/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.annotate.Hybrid;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.NumUtil;

public class HybridLayout<T> {
    private final ObjectLayout layout;
    private final HostedField arrayField;
    private final HostedField bitsetField;
    private final int instanceSize;

    public static boolean isHybrid(ResolvedJavaType clazz) {
        return clazz.getAnnotation(Hybrid.class) != null;
    }

    public static boolean isHybridField(ResolvedJavaField field) {
        return field.getAnnotation(Hybrid.Array.class) != null || field.getAnnotation(Hybrid.Bitset.class) != null;
    }

    public HybridLayout(Class<T> hybridClass, ObjectLayout layout, HostedMetaAccess metaAccess) {
        this((HostedInstanceClass)metaAccess.lookupJavaType((Class)hybridClass), layout);
    }

    public HybridLayout(HostedInstanceClass hybridClass, ObjectLayout layout) {
        this.layout = layout;
        assert (hybridClass.getAnnotation(Hybrid.class) != null);
        assert (Modifier.isFinal(hybridClass.getModifiers()));
        HostedField foundArrayField = null;
        HostedField foundBitsetField = null;
        for (HostedField field : hybridClass.getInstanceFields(true)) {
            if (field.getAnnotation(Hybrid.Array.class) != null) {
                assert (foundArrayField == null) : "must have exactly one hybrid array field";
                assert (field.getType().isArray());
                foundArrayField = field;
            }
            if (field.getAnnotation(Hybrid.Bitset.class) == null) continue;
            assert (foundBitsetField == null) : "must have at most one hybrid bitset field";
            assert (!field.getType().isArray());
            foundBitsetField = field;
        }
        assert (foundArrayField != null) : "must have exactly one hybrid array field";
        this.arrayField = foundArrayField;
        this.bitsetField = foundBitsetField;
        this.instanceSize = hybridClass.getInstanceSize();
    }

    public JavaKind getArrayElementStorageKind() {
        return this.arrayField.getType().getComponentType().getStorageKind();
    }

    public int getArrayBaseOffset() {
        return NumUtil.roundUp((int)this.instanceSize, (int)this.layout.sizeInBytes(this.getArrayElementStorageKind()));
    }

    public long getArrayElementOffset(int index) {
        return this.getArrayBaseOffset() + index * this.layout.sizeInBytes(this.getArrayElementStorageKind());
    }

    public long getTotalSize(int length) {
        return this.layout.alignUp(this.getArrayElementOffset(length));
    }

    public HostedField getArrayField() {
        return this.arrayField;
    }

    public HostedField getBitsetField() {
        return this.bitsetField;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getBitFieldOffset() {
        return this.layout.getArrayLengthOffset() + this.layout.sizeInBytes(JavaKind.Int);
    }
}

