/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.CErrorNumber;
import com.oracle.svm.core.jdk.SubstrateOperatingSystemMXBean;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Resource;
import com.oracle.svm.core.posix.headers.Times;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.DarwinStat;
import com.oracle.svm.core.posix.headers.linux.LinuxStat;
import com.oracle.svm.core.util.VMError;
import com.sun.management.UnixOperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;

class PosixSubstrateOperatingSystemMXBean
extends SubstrateOperatingSystemMXBean
implements UnixOperatingSystemMXBean {
    PosixSubstrateOperatingSystemMXBean() {
    }

    @Override
    public long getProcessCpuTime() {
        long clkTck = Unistd.sysconf(Unistd._SC_CLK_TCK());
        if (clkTck == -1L) {
            return -1L;
        }
        long nsPerTick = TimeUnit.SECONDS.toNanos(1L) / clkTck;
        Times.tms time = (Times.tms)StackValue.get(Times.tms.class);
        Times.times(time);
        return (time.tms_utime() + time.tms_stime()) * nsPerTick;
    }

    @Override
    public long getMaxFileDescriptorCount() {
        Resource.rlimit rlp = (Resource.rlimit)StackValue.get(Resource.rlimit.class);
        if (Resource.getrlimit(Resource.RLIMIT_NOFILE(), rlp) < 0) {
            PosixSubstrateOperatingSystemMXBean.throwUnchecked(PosixUtils.newIOExceptionWithLastError("getrlimit failed"));
        }
        return rlp.rlim_cur().rawValue();
    }

    @Override
    public long getOpenFileDescriptorCount() {
        int maxFileDescriptor = Unistd.getdtablesize();
        long count = 0L;
        for (int i = 0; i <= maxFileDescriptor; ++i) {
            if (PosixSubstrateOperatingSystemMXBean.fstat(i) != 0 && CErrorNumber.getCErrorNumber() == Errno.EBADF()) continue;
            ++count;
        }
        return count;
    }

    private static int fstat(int fd) {
        if (Platform.includedIn(Platform.LINUX.class)) {
            LinuxStat.stat64 stat = (LinuxStat.stat64)StackValue.get(LinuxStat.stat64.class);
            return LinuxStat.fstat64(fd, stat);
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            DarwinStat.stat64 stat = (DarwinStat.stat64)StackValue.get(DarwinStat.stat64.class);
            return DarwinStat.fstat64(fd, stat);
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    private static <T extends Throwable> void throwUnchecked(Throwable exception) throws T {
        throw exception;
    }
}

