/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.IdentityHashCodeSupport;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@TargetClass(value=System.class)
final class Target_java_lang_System {
    @Alias
    private static PrintStream out;
    @Alias
    private static PrintStream err;
    @Alias
    private static InputStream in;
    @Delete
    private static Properties props;

    Target_java_lang_System() {
    }

    @Substitute
    private static void setIn(InputStream is) {
        in = is;
    }

    @Substitute
    private static void setOut(PrintStream ps) {
        out = ps;
    }

    @Substitute
    private static void setErr(PrintStream ps) {
        err = ps;
    }

    @Substitute
    private static int identityHashCode(Object obj) {
        int hashCodeOffset;
        if (obj == null) {
            return 0;
        }
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        if (layout.getInstanceIdentityHashCodeOffset() >= 0 && layout.getInstanceIdentityHashCodeOffset() == layout.getArrayIdentityHashcodeOffset()) {
            hashCodeOffset = layout.getInstanceIdentityHashCodeOffset();
        } else {
            DynamicHub hub = KnownIntrinsics.readHub(obj);
            hashCodeOffset = hub.getHashCodeOffset();
        }
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (hashCodeOffset == 0 ? 1 : 0) != 0)) {
            throw VMError.shouldNotReachHere("identityHashCode called on illegal object");
        }
        UnsignedWord hashCodeOffsetWord = WordFactory.unsigned((int)hashCodeOffset);
        int hashCode = ObjectAccess.readInt((Object)obj, (WordBase)hashCodeOffsetWord, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
        if (BranchProbabilityNode.probability((double)0.99, (hashCode != 0 ? 1 : 0) != 0)) {
            return hashCode;
        }
        return IdentityHashCodeSupport.generateIdentityHashCode(obj, hashCodeOffset);
    }

    @Substitute
    private static Properties getProperties() {
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).getProperties();
    }

    @Substitute
    private static void setProperties(Properties props) {
        ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).setProperties(props);
    }

    @Substitute
    public static String setProperty(String key, String value) {
        Target_java_lang_System.checkKey(key);
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).setProperty(key, value);
    }

    @Substitute
    private static String getProperty(String key) {
        Target_java_lang_System.checkKey(key);
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).getProperty(key);
    }

    @Substitute
    public static String clearProperty(String key) {
        Target_java_lang_System.checkKey(key);
        return ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).clearProperty(key);
    }

    @Substitute
    private static String getProperty(String key, String def) {
        String result = Target_java_lang_System.getProperty(key);
        return result != null ? result : def;
    }

    @Alias
    private static native void checkKey(String var0);

    @Substitute
    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary(libname);
    }

    @Substitute
    public static void load(String filename) {
        Runtime.getRuntime().load(filename);
    }

    @Substitute
    private static void setSecurityManager(SecurityManager s) {
        if (s != null) {
            throw VMError.shouldNotReachHere("Installing a SecurityManager is not yet supported");
        }
    }
}

