/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.Target_java_util_SplittableRandom;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

public class SplittableRandomAccessors {
    private static final boolean SECURE_SEED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("java.util.secureRandomSeed");
        }
    });
    private static volatile AtomicLong defaultGen;
    private static final Object lock;

    public static AtomicLong getDefaultGen() {
        AtomicLong result = defaultGen;
        if (result == null) {
            result = SplittableRandomAccessors.initialize();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AtomicLong initialize() {
        Object object = lock;
        synchronized (object) {
            long seed;
            AtomicLong result = defaultGen;
            if (result != null) {
                return result;
            }
            if (SECURE_SEED) {
                byte[] seedBytes = SecureRandom.getSeed(8);
                seed = (long)seedBytes[0] & 0xFFL;
                for (int i = 1; i < 8; ++i) {
                    seed = seed << 8 | (long)seedBytes[i] & 0xFFL;
                }
            } else {
                seed = Target_java_util_SplittableRandom.mix64(System.currentTimeMillis()) ^ Target_java_util_SplittableRandom.mix64(System.nanoTime());
            }
            defaultGen = result = new AtomicLong(seed);
            return result;
        }
    }

    static {
        lock = new Object();
    }
}

