/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import java.util.SplittableRandom;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class IdentityHashCodeSupport {
    public static final LocationIdentity IDENTITY_HASHCODE_LOCATION = NamedLocationIdentity.mutable((String)"identityHashCode");
    private static final FastThreadLocalObject<SplittableRandom> hashCodeGeneratorTL = FastThreadLocalFactory.createObject(SplittableRandom.class);

    public static void ensureInitialized() {
        new SplittableRandom().nextInt();
    }

    public static int generateIdentityHashCode(Object obj, int hashCodeOffset) {
        UnsignedWord hashCodeOffsetWord = WordFactory.unsigned((int)hashCodeOffset);
        int newHashCode = IdentityHashCodeSupport.generateHashCode();
        if (!GraalUnsafeAccess.getUnsafe().compareAndSwapInt(obj, hashCodeOffset, 0, newHashCode)) {
            newHashCode = ObjectAccess.readInt((Object)obj, (WordBase)hashCodeOffsetWord, (LocationIdentity)IDENTITY_HASHCODE_LOCATION);
        }
        VMError.guarantee(newHashCode != 0, "Missing identity hash code");
        return newHashCode;
    }

    private static int generateHashCode() {
        SplittableRandom hashCodeGenerator = hashCodeGeneratorTL.get();
        if (hashCodeGenerator == null) {
            hashCodeGenerator = new SplittableRandom();
            hashCodeGeneratorTL.set(hashCodeGenerator);
        }
        int hashCode = hashCodeGenerator.nextInt(Integer.MAX_VALUE) + 1;
        assert (hashCode != 0) : "Must not return 0 because it means 'hash code not computed yet' in the field that stores the hash code";
        assert (hashCode > 0) : "The Java HotSpot VM only returns positive numbers for the identity hash code, so we want to have the same restriction on Substrate VM in order to not surprise users";
        return hashCode;
    }
}

